/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.tenant.common.dao.SysTenantUpgradeMapper;
import com.jxdinfo.hussar.tenant.common.dto.QueryUpgradeDto;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.UpgradeMicroServiceModel;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.service.impl.sysTenantUpgradeServiceImpl")
public class SysTenantUpgradeServiceImpl
extends HussarBaseServiceImpl<SysTenantUpgradeMapper, SysTenantUpgrade>
implements ISysTenantUpgradeService {
    private Logger LOGGER = LoggerFactory.getLogger(SysTenantUpgradeServiceImpl.class);
    @Autowired
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysTenantDataSourceService sysTenantDataSourceService;
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSQLExecutor;

    public Page<SysTenantUpgrade> search(QueryUpgradeDto queryUpgradeDto) {
        Page page = new Page();
        long size = queryUpgradeDto.getSize();
        long current = queryUpgradeDto.getCurrent();
        String tenantCode = queryUpgradeDto.getTenantCode();
        String serviceName = queryUpgradeDto.getServiceName();
        String updateStatus = queryUpgradeDto.getUpdateStatus();
        page.setSize(size);
        page.setCurrent(current);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            wrapper.eq(SysTenantUpgrade::getTenantCode, (Object)StringUtils.trim((String)tenantCode));
        }
        if (StringUtils.isNotBlank((CharSequence)serviceName)) {
            wrapper.eq(SysTenantUpgrade::getServiceName, (Object)StringUtils.trim((String)serviceName));
        }
        if (StringUtils.isNotBlank((CharSequence)updateStatus)) {
            wrapper.eq(SysTenantUpgrade::getUpdateStatus, (Object)StringUtils.trim((String)updateStatus));
        }
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        Page result = (Page)this.page((IPage)page, (Wrapper)wrapper);
        List records = result.getRecords();
        if (HussarUtils.isNotEmpty((Object)records)) {
            for (SysTenantUpgrade upgrade : records) {
                upgrade.setTenantName(TenantCacheUtil.loadFromCacheByTenantId((Long)upgrade.getTenantId()).getTenantName());
            }
        }
        return result;
    }

    public void updateSingle() {
        this.checkSingle();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)"0");
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        List list = this.sysTenantService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)list)) {
            ((ExecutorService)SpringContextHolder.getBean(ExecutorService.class)).execute(() -> this.asyncUpdateSingle(list));
        }
    }

    private void checkSingle() {
        List list = this.list();
        if (HussarUtils.isNotEmpty((Object)list)) {
            Optional<SysTenantUpgrade> any = list.parallelStream().filter(item -> item.getUpdateStatus().equals("0")).findAny();
            if (any.isPresent()) {
                throw new BaseException("\u8bf7\u9996\u5148\u5904\u7406\u5b8c\u4e0a\u6b21\u5347\u7ea7\u5931\u8d25\u7684\u79df\u6237");
            }
            List ids = EntityUtils.toList((Collection)list, SysTenantUpgrade::getId);
            this.removeByIds(ids);
        }
    }

    private void checkMicroService(String serviceName) {
        new LambdaQueryWrapper().eq(SysTenantUpgrade::getServiceName, (Object)serviceName);
        List list = this.list();
        if (HussarUtils.isNotEmpty((Object)list)) {
            Optional<SysTenantUpgrade> any = list.parallelStream().filter(item -> item.getUpdateStatus().equals("0") && item.getServiceName().equalsIgnoreCase(serviceName)).findAny();
            if (any.isPresent()) {
                throw new BaseException("\u8bf7\u9996\u5148\u5904\u7406\u5b8c\u670d\u52a1" + serviceName + "\u4e0a\u6b21\u5347\u7ea7\u5931\u8d25\u7684\u79df\u6237");
            }
            List ids = EntityUtils.toList((Collection)list, SysTenantUpgrade::getId);
            this.removeByIds(ids);
        }
    }

    public void updateSingleById(Long id) {
        SysTenantUpgrade sysTenantUpgrade = (SysTenantUpgrade)this.getById(id);
        Long tenantId = sysTenantUpgrade.getTenantId();
        SysTenant tenant = (SysTenant)this.sysTenantService.getById((Serializable)tenantId);
        ((ExecutorService)SpringContextHolder.getBean(ExecutorService.class)).execute(() -> this.asyncUpdateSingleOne(sysTenantUpgrade, tenant));
    }

    public void updateMicroServiceById(Long id) {
        SysTenantUpgrade sysTenantUpgrade = (SysTenantUpgrade)this.getById(id);
        Long tenantId = sysTenantUpgrade.getTenantId();
        ((ExecutorService)SpringContextHolder.getBean(ExecutorService.class)).execute(() -> this.updateMicroServiceOne(sysTenantUpgrade.getServiceName(), id));
    }

    public String viewTenantUpgrade(Long id) {
        SysTenantUpgrade upgrade = (SysTenantUpgrade)this.getById(id);
        if (HussarUtils.isNotEmpty((Object)upgrade)) {
            return upgrade.getUpdateError();
        }
        return null;
    }

    private RedisTemplate getRedisTemplate() {
        return (RedisTemplate)SpringContextHolder.getBean((String)"redisTemplate");
    }

    public void updateMicroService(String serviceName) {
        this.checkMicroService(serviceName);
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (Objects.equals(serviceName, currentServiceName)) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)"0");
            wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
            List list = this.sysTenantService.list((Wrapper)wrapper);
            if (HussarUtils.isNotEmpty((Object)list)) {
                ((ExecutorService)SpringContextHolder.getBean(ExecutorService.class)).execute(() -> {
                    for (SysTenant tenant : list) {
                        SysTenantUpgrade sysTenantUpgrade = new SysTenantUpgrade();
                        this.asyncUpdateMicroServiceOne(currentServiceName, sysTenantUpgrade, tenant);
                    }
                });
            }
        } else {
            UpgradeMicroServiceModel upgradeMicroServiceModel = new UpgradeMicroServiceModel();
            upgradeMicroServiceModel.setServiceName(serviceName);
            this.getRedisTemplate().convertAndSend("topic_microservice_upgrade", (Object)upgradeMicroServiceModel);
        }
    }

    public void updateMicroServiceOne(String serviceName, Long tenantId) {
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (Objects.equals(serviceName, currentServiceName)) {
            SysTenant tenantById = (SysTenant)this.sysTenantService.getById((Serializable)tenantId);
            if (HussarUtils.isNotEmpty((Object)tenantById)) {
                ((ExecutorService)SpringContextHolder.getBean(ExecutorService.class)).execute(() -> {
                    SysTenantUpgrade sysTenantUpgrade = new SysTenantUpgrade();
                    this.asyncUpdateMicroServiceOne(currentServiceName, sysTenantUpgrade, tenantById);
                });
            }
        } else {
            UpgradeMicroServiceModel upgradeMicroServiceModel = new UpgradeMicroServiceModel();
            upgradeMicroServiceModel.setServiceName(serviceName);
            upgradeMicroServiceModel.setTenantId(tenantId);
            this.getRedisTemplate().convertAndSend("topic_microservice_upgrade", (Object)upgradeMicroServiceModel);
        }
    }

    private void asyncUpdateMicroServiceOne(String serviceName, SysTenantUpgrade sysTenantUpgrade, SysTenant tenant) {
        String connName = tenant.getConnName();
        sysTenantUpgrade.setTenantCode(tenant.getTenantCode());
        sysTenantUpgrade.setTenantId(tenant.getId());
        sysTenantUpgrade.setConnName(connName);
        sysTenantUpgrade.setServiceName(serviceName);
        LambdaQueryWrapper datasourceWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        SysTenantDatasource sysTenantDatasource = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)datasourceWrapper, false);
        if (HussarUtils.isNotEmpty((Object)sysTenantDatasource)) {
            String dbUrl = sysTenantDatasource.getJdbcUrl();
            String dbType = DbUtil.getDbType((String)dbUrl);
            try {
                String path = "tenantsql/upgrade/" + dbType;
                Object[] upgradeExecuteSQLScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
                if (HussarUtils.isNotEmpty((Object[])upgradeExecuteSQLScripts)) {
                    for (Object resource : upgradeExecuteSQLScripts) {
                        boolean check;
                        String updateScript = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                        boolean bl = check = StringUtils.isNotBlank((CharSequence)updateScript) && updateScript.contains("UPDATE");
                        if (check) continue;
                        throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                    }
                } else {
                    throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                }
                this.hussarBaseSQLExecutor.execSqlFile(connName, (Resource[])upgradeExecuteSQLScripts);
                sysTenantUpgrade.setUpdateStatus("1");
            }
            catch (Exception e) {
                sysTenantUpgrade.setUpdateStatus("0");
                sysTenantUpgrade.setUpdateError(e.getMessage());
                this.LOGGER.error("\u5347\u7ea7\u670d\u52a1\u3010" + serviceName + "\u3011- \u79df\u6237\uff1a" + tenant.getTenantCode() + "\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                e.printStackTrace();
            }
            this.saveOrUpdate((BaseEntity)sysTenantUpgrade);
        }
    }

    private void asyncUpdateSingleOne(SysTenantUpgrade sysTenantUpgrade, SysTenant tenant) {
        String connName = tenant.getConnName();
        sysTenantUpgrade.setTenantCode(tenant.getTenantCode());
        sysTenantUpgrade.setTenantId(tenant.getId());
        sysTenantUpgrade.setConnName(connName);
        sysTenantUpgrade.setServiceName("");
        LambdaQueryWrapper datasourceWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        SysTenantDatasource sysTenantDatasource = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)datasourceWrapper, false);
        if (HussarUtils.isNotEmpty((Object)sysTenantDatasource)) {
            String dbUrl = sysTenantDatasource.getJdbcUrl();
            String dbType = DbUtil.getDbType((String)dbUrl);
            try {
                String path = "tenantsql/upgrade/" + dbType;
                Object[] upgradeExecuteSQLScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
                if (HussarUtils.isNotEmpty((Object[])upgradeExecuteSQLScripts)) {
                    for (Object resource : upgradeExecuteSQLScripts) {
                        boolean check;
                        String updateScript = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                        boolean bl = check = StringUtils.isNotBlank((CharSequence)updateScript) && updateScript.contains("UPDATE");
                        if (check) continue;
                        throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                    }
                } else {
                    throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                }
                this.hussarBaseSQLExecutor.execSqlFile(connName, (Resource[])upgradeExecuteSQLScripts);
                sysTenantUpgrade.setUpdateStatus("1");
            }
            catch (Exception e) {
                sysTenantUpgrade.setUpdateStatus("0");
                sysTenantUpgrade.setUpdateError(e.getMessage());
                this.LOGGER.error("\u5347\u7ea7" + tenant.getTenantCode() + "\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                e.printStackTrace();
            }
            this.saveOrUpdate((BaseEntity)sysTenantUpgrade);
        }
    }

    private void asyncUpdateSingle(List<SysTenant> list) {
        for (SysTenant tenant : list) {
            SysTenantUpgrade sysTenantUpgrade = new SysTenantUpgrade();
            this.asyncUpdateSingleOne(sysTenantUpgrade, tenant);
        }
    }
}

