/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.runner;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarCacheProperties;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantJobInfo;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSecure;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantJobInfoService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSecureService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.tenant.runner.environmentCheckRunner")
@Order(value=900000)
public class EnvironmentCheckRunner
implements ApplicationRunner {
    @Resource
    private HussarCacheProperties hussarCacheProperties;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired
    private ISysTenantRecordService sysTenantRecordService;
    @Autowired
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysTenantSecureService tenantSecureService;
    @Autowired
    private ISysTenantJobInfoService tenantJobInfoService;

    public void run(ApplicationArguments args) throws Exception {
        boolean tenantOpen = this.hussarTenantProperties.isEnabled();
        boolean redisOpen = "redis".equals(this.hussarCacheProperties.getCacheType());
        if (tenantOpen && !redisOpen) {
            throw new BaseException("\u591a\u79df\u6237\u6a21\u5f0f\u5fc5\u987b\u5f00\u542fredis\u7f13\u5b58\u914d\u7f6e");
        }
        TenantCacheUtil.clearTenantCache();
        List list = this.sysTenantRecordService.list();
        if (HussarUtils.isNotEmpty((Object)list)) {
            ArrayList codes = Lists.newArrayList();
            for (SysTenantRecord record : list) {
                String className = record.getTenantClass();
                String param = record.getTenantParams();
                Long tenantId = record.getTenantId();
                SysTenant byId = (SysTenant)this.sysTenantService.getById((Serializable)tenantId);
                if (!HussarUtils.isNotEmpty((Object)byId)) continue;
                try {
                    HussarTenantDefinition definition = (HussarTenantDefinition)JSON.parseObject((String)param, Class.forName(className));
                    definition.setTenantStatus(byId.getTenantStatus());
                    SysTenantSecure one = (SysTenantSecure)this.tenantSecureService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getTenantId, (Object)tenantId));
                    if (HussarUtils.isNotEmpty((Object)one)) {
                        definition.setClientId(one.getClientId());
                        definition.setClientSecret(one.getClientSecret());
                    }
                    definition.setTenantAdminId(byId.getTenantAdminId());
                    HussarFixedCacheUtil.put((String)"tenant_info", (Object)tenantId, (Object)definition);
                    codes.add(definition.getTenantCode());
                }
                catch (ClassNotFoundException e) {
                    byId.setTenantStatus("0");
                    this.sysTenantService.updateById((Object)byId);
                    this.sysTenantRecordService.removeById((Serializable)record.getId());
                    HussarFixedCacheUtil.evict((String)"tenant_info", (Object)byId.getId());
                }
            }
            codes.add("0");
            this.tenantJobInfoService.remove((Wrapper)new LambdaQueryWrapper().notIn(SysTenantJobInfo::getTenantCode, (Collection)codes));
        }
    }
}

