/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.job;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class HussarBaseCheckExpiredTenantJob
implements BasicProcessor {
    @Resource
    private ISysTenantService tenantService;

    public ProcessResult process(TaskContext context) throws Exception {
        HussarContextHolder.setTenant((String)context.getDbName(), (String)context.getTenantCode());
        List tenantList = this.tenantService.list();
        LocalDateTime now = LocalDateTime.now();
        ArrayList<SysTenant> expiredTenant = new ArrayList<SysTenant>();
        for (SysTenant item : tenantList) {
            if (!"1".equals(item.getTimeLimit()) || !now.isAfter(item.getEndTime())) continue;
            item.setTenantStatus("2");
            expiredTenant.add(item);
        }
        if (HussarUtils.isNotEmpty(expiredTenant)) {
            this.tenantService.updateBatchById(expiredTenant);
        }
        return new ProcessResult(true, "success");
    }
}

