/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.support.job.core.enums.TimeExpressionType;
import com.jxdinfo.hussar.support.job.core.exception.JobRuntimeException;
import com.jxdinfo.hussar.tenant.common.model.SysTenantJobInfo;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.core.util.CronExpression;

public class TenantJobUtil {
    private TenantJobUtil() {
    }

    public static List<SysTenantJobInfo> getDefaultInitJob(String connName, Long tenantId, String tenantCode) {
        ArrayList<SysTenantJobInfo> tenantJobInfoList = new ArrayList<SysTenantJobInfo>();
        SysTenantJobInfo acccountJob = new SysTenantJobInfo();
        acccountJob.setAppId(Long.valueOf(543099687121723392L));
        acccountJob.setConcurrency(Integer.valueOf(5));
        acccountJob.setDispatchStrategy(Integer.valueOf(1));
        acccountJob.setExecuteType(Integer.valueOf(1));
        acccountJob.setInstanceRetryNum(Integer.valueOf(1));
        acccountJob.setInstanceTimeLimit(Long.valueOf(0L));
        acccountJob.setJobDescription("\u8d26\u6237\u72b6\u6001\u68c0\u6d4b");
        acccountJob.setJobName("AccountJob");
        acccountJob.setMaxInstanceNum(Integer.valueOf(0));
        acccountJob.setMaxWorkerCount(Integer.valueOf(0));
        acccountJob.setMinCpuCores(Double.valueOf(0.0));
        acccountJob.setMinDiskSpace(Double.valueOf(0.0));
        acccountJob.setMinMemorySpace(Double.valueOf(0.0));
        acccountJob.setProcessorInfo("com.jxdinfo.hussar.schedule.job.AccountJob");
        acccountJob.setProcessorType(Integer.valueOf(1));
        acccountJob.setTaskRetryNum(Integer.valueOf(0));
        acccountJob.setTimeExpressionType(Integer.valueOf(2));
        acccountJob.setTimeExpression("00 00 00 * * ? *");
        acccountJob.setStatus(Integer.valueOf(1));
        acccountJob.setTenantId(tenantId);
        acccountJob.setTenantCode(tenantCode);
        acccountJob.setDbName(connName);
        acccountJob.setDelFlag("0");
        TenantJobUtil.calculateNextTriggerTime(acccountJob);
        tenantJobInfoList.add(acccountJob);
        SysTenantJobInfo updateOnlineHist = new SysTenantJobInfo();
        updateOnlineHist.setAppId(Long.valueOf(543099687121723392L));
        updateOnlineHist.setConcurrency(Integer.valueOf(5));
        updateOnlineHist.setDispatchStrategy(Integer.valueOf(1));
        updateOnlineHist.setExecuteType(Integer.valueOf(1));
        updateOnlineHist.setInstanceRetryNum(Integer.valueOf(1));
        updateOnlineHist.setInstanceTimeLimit(Long.valueOf(0L));
        updateOnlineHist.setJobDescription("\u5728\u7ebf\u5386\u53f2\u66f4\u65b0");
        updateOnlineHist.setJobName("UpdateOnlineHist");
        updateOnlineHist.setMaxInstanceNum(Integer.valueOf(0));
        updateOnlineHist.setMaxWorkerCount(Integer.valueOf(0));
        updateOnlineHist.setMinCpuCores(Double.valueOf(0.0));
        updateOnlineHist.setMinDiskSpace(Double.valueOf(0.0));
        updateOnlineHist.setMinMemorySpace(Double.valueOf(0.0));
        updateOnlineHist.setProcessorInfo("com.jxdinfo.hussar.operations.job.BaseDbSyncUserCache");
        updateOnlineHist.setProcessorType(Integer.valueOf(1));
        updateOnlineHist.setTaskRetryNum(Integer.valueOf(0));
        updateOnlineHist.setTimeExpressionType(Integer.valueOf(2));
        updateOnlineHist.setTimeExpression("00 0/10 * * * ? *");
        updateOnlineHist.setStatus(Integer.valueOf(1));
        updateOnlineHist.setTenantId(tenantId);
        updateOnlineHist.setTenantCode(tenantCode);
        updateOnlineHist.setDbName(connName);
        updateOnlineHist.setDelFlag("0");
        TenantJobUtil.calculateNextTriggerTime(updateOnlineHist);
        tenantJobInfoList.add(updateOnlineHist);
        SysTenantJobInfo unlockJob = new SysTenantJobInfo();
        unlockJob.setAppId(Long.valueOf(543099687121723392L));
        unlockJob.setConcurrency(Integer.valueOf(5));
        unlockJob.setDispatchStrategy(Integer.valueOf(1));
        unlockJob.setExecuteType(Integer.valueOf(1));
        unlockJob.setInstanceRetryNum(Integer.valueOf(0));
        unlockJob.setInstanceTimeLimit(Long.valueOf(0L));
        unlockJob.setJobDescription("\u81ea\u52a8\u89e3\u9501\u5b9a\u65f6\u4efb\u52a1");
        unlockJob.setJobName("UnlockJob");
        unlockJob.setMaxInstanceNum(Integer.valueOf(0));
        unlockJob.setMaxWorkerCount(Integer.valueOf(0));
        unlockJob.setMinCpuCores(Double.valueOf(0.0));
        unlockJob.setMinDiskSpace(Double.valueOf(0.0));
        unlockJob.setMinMemorySpace(Double.valueOf(0.0));
        unlockJob.setProcessorInfo("com.jxdinfo.hussar.authentication.job.UnlockJob");
        unlockJob.setProcessorType(Integer.valueOf(1));
        unlockJob.setTaskRetryNum(Integer.valueOf(0));
        unlockJob.setTimeExpressionType(Integer.valueOf(2));
        unlockJob.setTimeExpression("00 0/1 * ? * *");
        unlockJob.setStatus(Integer.valueOf(1));
        unlockJob.setTenantId(tenantId);
        unlockJob.setTenantCode(tenantCode);
        unlockJob.setDbName(connName);
        unlockJob.setDelFlag("0");
        TenantJobUtil.calculateNextTriggerTime(unlockJob);
        tenantJobInfoList.add(unlockJob);
        SysTenantJobInfo auditCountJob = new SysTenantJobInfo();
        auditCountJob.setAppId(Long.valueOf(543099687121723392L));
        auditCountJob.setConcurrency(Integer.valueOf(5));
        auditCountJob.setDispatchStrategy(Integer.valueOf(1));
        auditCountJob.setExecuteType(Integer.valueOf(1));
        auditCountJob.setInstanceRetryNum(Integer.valueOf(1));
        auditCountJob.setInstanceTimeLimit(Long.valueOf(0L));
        auditCountJob.setJobDescription("\u5ba1\u8ba1\u65e5\u5fd7\u5b9a\u65f6\u4efb\u52a1");
        auditCountJob.setJobName("AuditCountJob");
        auditCountJob.setMaxInstanceNum(Integer.valueOf(0));
        auditCountJob.setMaxWorkerCount(Integer.valueOf(0));
        auditCountJob.setMinCpuCores(Double.valueOf(0.0));
        auditCountJob.setMinDiskSpace(Double.valueOf(0.0));
        auditCountJob.setMinMemorySpace(Double.valueOf(0.0));
        auditCountJob.setProcessorInfo("com.jxdinfo.hussar.schedule.job.AuditCountJob");
        auditCountJob.setProcessorType(Integer.valueOf(1));
        auditCountJob.setTaskRetryNum(Integer.valueOf(0));
        auditCountJob.setTimeExpressionType(Integer.valueOf(2));
        auditCountJob.setTimeExpression("00 0/5 * ? * *");
        auditCountJob.setStatus(Integer.valueOf(1));
        auditCountJob.setTenantId(tenantId);
        auditCountJob.setTenantCode(tenantCode);
        auditCountJob.setDbName(connName);
        auditCountJob.setDelFlag("0");
        TenantJobUtil.calculateNextTriggerTime(auditCountJob);
        tenantJobInfoList.add(auditCountJob);
        SysTenantJobInfo organizationJob = new SysTenantJobInfo();
        organizationJob.setAppId(Long.valueOf(543099687121723392L));
        organizationJob.setConcurrency(Integer.valueOf(5));
        organizationJob.setDispatchStrategy(Integer.valueOf(1));
        organizationJob.setExecuteType(Integer.valueOf(1));
        organizationJob.setInstanceRetryNum(Integer.valueOf(1));
        organizationJob.setInstanceTimeLimit(Long.valueOf(0L));
        organizationJob.setJobDescription("\u5237\u65b0\u7ec4\u7ec7\u673a\u6784\u5c42\u7ea7\u7801");
        organizationJob.setJobName("OrganizationJob");
        organizationJob.setMaxInstanceNum(Integer.valueOf(0));
        organizationJob.setMaxWorkerCount(Integer.valueOf(0));
        organizationJob.setMinCpuCores(Double.valueOf(0.0));
        organizationJob.setMinDiskSpace(Double.valueOf(0.0));
        organizationJob.setMinMemorySpace(Double.valueOf(0.0));
        organizationJob.setProcessorInfo("com.jxdinfo.hussar.schedule.job.HussarOrganizationJob");
        organizationJob.setProcessorType(Integer.valueOf(1));
        organizationJob.setTaskRetryNum(Integer.valueOf(0));
        organizationJob.setTimeExpressionType(Integer.valueOf(2));
        organizationJob.setTimeExpression("* * 1/1 ? * *");
        organizationJob.setStatus(Integer.valueOf(2));
        organizationJob.setTenantId(tenantId);
        organizationJob.setTenantCode(tenantCode);
        organizationJob.setDbName(connName);
        organizationJob.setDelFlag("0");
        TenantJobUtil.calculateNextTriggerTime(organizationJob);
        tenantJobInfoList.add(organizationJob);
        return tenantJobInfoList;
    }

    private static void calculateNextTriggerTime(SysTenantJobInfo tenantJobInfo) {
        try {
            Date now = new Date();
            TimeExpressionType timeExpressionType = TimeExpressionType.of((int)tenantJobInfo.getTimeExpressionType());
            if (timeExpressionType == TimeExpressionType.CRON) {
                CronExpression cronExpression = new CronExpression(tenantJobInfo.getTimeExpression());
                Date nextValidTime = cronExpression.getNextValidTimeAfter(now);
                if (nextValidTime == null) {
                    throw new JobRuntimeException("cron expression is out of date: " + tenantJobInfo.getTimeExpression());
                }
                tenantJobInfo.setNextTriggerTime(DateTimeUtil.toDateTime((Instant)nextValidTime.toInstant()));
            } else if (timeExpressionType == TimeExpressionType.API || timeExpressionType == TimeExpressionType.WORKFLOW) {
                tenantJobInfo.setTimeExpression((String)null);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

