/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.job;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class HussarBaseCheckExpiredTenantJob
implements BasicProcessor {
    @Resource
    private ISysTenantService tenantService;
    @Resource
    private ISysTenantRecordService tenantRecordService;

    public ProcessResult process(TaskContext context) throws Exception {
        HussarContextHolder.setTenant((String)context.getDbName(), (String)context.getTenantCode());
        List tenantList = this.tenantService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantStatus, (Object)"1"));
        LocalDateTime now = LocalDateTime.now();
        ArrayList<SysTenant> expiredTenant = new ArrayList<SysTenant>();
        for (SysTenant item : tenantList) {
            if (!"1".equals(item.getTimeLimit()) || !now.isAfter(item.getEndTime())) continue;
            item.setTenantStatus("2");
            expiredTenant.add(item);
        }
        if (HussarUtils.isNotEmpty(expiredTenant)) {
            List ids = EntityUtils.toList(expiredTenant, SysTenant::getId);
            List recordList = this.tenantRecordService.list((Wrapper)new LambdaQueryWrapper().in(SysTenantRecord::getTenantId, (Collection)ids));
            if (HussarUtils.isNotEmpty((Object)recordList)) {
                for (SysTenantRecord record : recordList) {
                    HussarTenantDefinition hussarTenantDefinition;
                    String paramStr = record.getTenantParams();
                    String className = record.getTenantClass();
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    HussarTenantDefinition definitionParse = (HussarTenantDefinition)JSON.parseObject((String)paramStr, clazz);
                    if (HussarUtils.isNotEmpty((Object)definitionParse)) {
                        definitionParse.setTenantStatus("2");
                        record.setTenantParams(JSON.toJSONString((Object)definitionParse));
                    }
                    if (!HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantId((Long)record.getTenantId())))) continue;
                    hussarTenantDefinition.setTenantStatus("2");
                    TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
                }
                this.tenantRecordService.updateBatchById((Collection)recordList);
            }
            this.tenantService.updateBatchById(expiredTenant);
        }
        return new ProcessResult(true, "success");
    }
}

