/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.OutSideTenantUpgradeResult;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u5347\u7ea7\u56de\u8c03"})
@RestController(value="com.jxdinfo.hussar.tenant.common.controller.hussarBaseTenantUpgradeCallBackController")
@RequestMapping(value={"/hussarBase/tenant/remote"})
public class HussarBaseTenantUpgradeCallBackController {
    @Autowired
    private ISysTenantUpgradeService sysTenantUpgradeService;

    @PostMapping(value={"/upgradeCallBackOutSide"})
    public void upgradeCallBack(@RequestBody List<OutSideTenantUpgradeResult> upgradeResultList) {
        if (HussarUtils.isEmpty(upgradeResultList)) {
            return;
        }
        ArrayList<SysTenantUpgrade> list = new ArrayList<SysTenantUpgrade>();
        for (OutSideTenantUpgradeResult upgradeResult : upgradeResultList) {
            Boolean success = upgradeResult.getSuccess();
            String errMsg = upgradeResult.getErrMsg();
            String serviceName = upgradeResult.getServiceName();
            String tenantCode = upgradeResult.getTenantCode();
            SysTenantUpgrade temp = (SysTenantUpgrade)this.sysTenantUpgradeService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantUpgrade::getTenantCode, (Object)tenantCode)).eq(SysTenantUpgrade::getServiceName, (Object)serviceName));
            if (!HussarUtils.isNotEmpty((Object)temp)) continue;
            temp.setUpdateStatus(success != false ? "1" : "0");
            temp.setUpdateError(errMsg);
            list.add(temp);
        }
        if (HussarUtils.isNotEmpty(list)) {
            this.sysTenantUpgradeService.updateBatchById(list);
        }
    }
}

