/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.service.ISysAppCopyService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppCopyServiceImpl")
public class SysAppCopyServiceImpl
implements ISysAppCopyService {
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysOfficeService iSysOfficeService;
    @Resource
    private ISysOrganTypeService sysOrganTypeService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private QueryStaffManager queryStaffManager;
    @Resource
    private QueryUserManager queryUserManager;
    @Resource
    private ISysStruAssistOrganService iSysStruAssistOrganService;
    @Resource
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysStruAssistOrganService sysStruAssistOrganService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;

    public void copy(String appCode, List<Long> userIds) {
        SysDataSource sysDataSource = this.sysDataSourceService.getByConnName(appCode);
        if (HussarUtils.isEmpty((Object)sysDataSource)) {
            throw new BaseException("\u5e94\u7528\u5e93\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        List sysAppUsers = this.sysUsersService.listByIds(sysDataSource.getConnName(), userIds);
        if (null != sysAppUsers && sysAppUsers.size() > 0) {
            List appUserIds = sysAppUsers.stream().map(SysUsers::getId).collect(Collectors.toList());
            userIds = userIds.stream().filter(item -> !appUserIds.contains(item)).collect(Collectors.toList());
        }
        if (null == userIds || userIds.size() <= 0) {
            return;
        }
        List userList = this.sysUsersService.listByIds(userIds);
        HashSet<Long> set = new HashSet<Long>();
        HashSet<Long> staffSet = new HashSet<Long>();
        Long l = 11L;
        for (SysUsers sysUsers : userList) {
            if (!l.equals(sysUsers.getDepartmentId())) {
                set.add(sysUsers.getDepartmentId());
            }
            if (!HussarUtils.isNotEmpty((Object)sysUsers.getEmployeeId())) continue;
            staffSet.add(sysUsers.getEmployeeId());
        }
        List<Long> struIds = set.stream().collect(Collectors.toList());
        List<Long> staffIds = staffSet.stream().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(struIds)) {
            this.qryStruInfo(appCode, struIds);
        }
        if (HussarUtils.isNotEmpty(staffIds)) {
            this.qryStaffInfo(appCode, staffIds);
        }
        if (HussarUtils.isNotEmpty(userIds)) {
            this.qryUserRole(appCode, userIds);
        }
    }

    private void qryUserRole(String appCode, List<Long> userIds) {
        List userRoles = this.sysUserRoleService.getUserRolesByUserIds(userIds);
        List sysUsers = this.sysUsersService.listByIds(userIds);
        HashSet<Long> developUserIdSet = new HashSet<Long>();
        HashSet<Long> roleIdSet = new HashSet<Long>();
        HashSet<Long> roleGroupIdSet = new HashSet<Long>();
        Long developRoleId = 690264237607755776L;
        for (SysUserRole userRole : userRoles) {
            roleIdSet.add(userRole.getGrantedRole());
            if (!developRoleId.equals(userRole.getGrantedRole())) continue;
            developUserIdSet.add(userRole.getUserId());
        }
        List developUserIds = developUserIdSet.stream().collect(Collectors.toList());
        List noDevelopUserIds = userIds.stream().filter(n -> !developUserIds.contains(n)).collect(Collectors.toList());
        for (Object noDevelopUserId : noDevelopUserIds) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId((Long)noDevelopUserId);
            sysUserRole.setGrantedRole(developRoleId);
            sysUserRole.setAdminOption("1");
            userRoles.add(sysUserRole);
        }
        ArrayList<SysUsers> systemUsers = new ArrayList<SysUsers>();
        for (SysUsers sysUser : sysUsers) {
            if (!HussarUtils.isEmpty((Object)sysUser.getEmployeeId())) continue;
            systemUsers.add(sysUser);
        }
        List roleIds = roleIdSet.stream().collect(Collectors.toList());
        List sysRoles = this.sysRolesService.listByIds(roleIds);
        for (SysRoles sysRole : sysRoles) {
            roleGroupIdSet.add(sysRole.getGroupId());
        }
        List roleGroupIds = roleGroupIdSet.stream().collect(Collectors.toList());
        List sysRoleGroups = this.sysRoleGroupService.listByIds(roleGroupIds);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("roleGroups", sysRoleGroups);
        data.put("roles", sysRoles);
        data.put("userRole", userRoles);
        data.put("users", systemUsers);
        this.copyUserRole(appCode, data);
    }

    public static void main(String[] args) {
        ArrayList<Long> developUserIds = new ArrayList<Long>();
        developUserIds.add(1L);
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(1L);
        userIds.add(2L);
        List collect = userIds.stream().filter(n -> !developUserIds.contains(n)).collect(Collectors.toList());
        System.out.println(collect);
    }

    private void copyUserRole(String appCode, Map<String, Object> map) {
        List sysRoleGroups = (List)map.get("roleGroups");
        List sysRoles = (List)map.get("roles");
        List userRoles = (List)map.get("userRole");
        List sysUsers = (List)map.get("users");
        Map groupCount = this.sysRoleGroupService.saveOrUpdateGroupList(appCode, sysRoleGroups);
        Map roleCount = this.sysRolesService.saveOrUpdateRoleList(appCode, sysRoles);
        Map userRoleCount = this.sysUserRoleService.saveOrUpdateBatchUserRoles(appCode, userRoles);
        if (null != sysUsers && sysUsers.size() > 0) {
            Map map2 = this.sysUsersService.saveOrUpdateUserList(appCode, sysUsers);
        }
    }

    private void qryStaffInfo(String appCode, List<Long> staffIds) {
        List strus = this.sysStruService.getStruByStruIds(staffIds);
        List staffs = this.queryStaffManager.selectStaffByStruIds(staffIds);
        List users = this.queryUserManager.selectUsersByStruIds(staffIds);
        List sysStruAssistOrgan = this.iSysStruAssistOrganService.getStruAssistOrganByStruIds(staffIds);
        ArrayList<Long> organIdList = new ArrayList<Long>();
        for (SysStru sysStru : strus) {
            Long organId = sysStru.getOrganId();
            organIdList.add(organId);
        }
        List organs = this.queryOrganizationManager.getOrganByIds(organIdList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("sysStruAssistOrgan", sysStruAssistOrgan);
        this.copyStaffInfo(appCode, data);
    }

    private void copyStaffInfo(String appCode, Map<String, Object> data) {
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List staffs = (List)data.get("staffs");
        List users = (List)data.get("users");
        List sysStruAssistOrgan = (List)data.get("sysStruAssistOrgan");
        Map stuCount = this.sysStruService.saveOrUpdateStruList(appCode, strus);
        Map organCount = this.sysOrganService.saveOrUpdateOrganList(appCode, organs);
        Map staffCount = this.sysStaffService.saveOrUpdateStaffList(appCode, staffs);
        Map userCount = this.sysUsersService.saveOrUpdateUserList(appCode, users);
        Map assistCount = this.sysStruAssistOrganService.saveOrUpdateAssitList(appCode, sysStruAssistOrgan);
    }

    private void qryStruInfo(String appCode, List<Long> struIds) {
        List strus = this.sysStruService.getStruByStruIds(struIds);
        HashSet<Long> struSet = new HashSet<Long>();
        for (SysStru sysStru : strus) {
            String struFid = sysStru.getStruFid().substring(1);
            String[] ids = struFid.split("/");
            for (String id : ids) {
                struSet.add(Long.parseLong(id));
            }
        }
        List allStruIds = struSet.stream().collect(Collectors.toList());
        List allStru = this.sysStruService.getStruByStruIds(allStruIds);
        ArrayList<Long> organIdList = new ArrayList<Long>();
        ArrayList<String> struTypeList = new ArrayList<String>();
        for (SysStru sysStru : allStru) {
            Long organId = sysStru.getOrganId();
            String struType = sysStru.getStruType();
            organIdList.add(organId);
            struTypeList.add(struType);
        }
        List struTypeLong = struTypeList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List organs = this.sysOrganService.getOrgansByOrganIds(organIdList);
        List organTypes = this.sysOrganTypeService.getOrganTypeByOrganTypeIds(struTypeLong);
        List offices = this.iSysOfficeService.getSysOfficeByStruId(struIds);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("strus", allStru);
        map.put("organs", organs);
        map.put("orgTypes", organTypes);
        map.put("offices", offices);
        this.copyStruInfo(appCode, map);
    }

    private void copyStruInfo(String connName, Map<String, Object> map) {
        List strus = (List)map.get("strus");
        List organs = (List)map.get("organs");
        List organTypes = (List)map.get("orgTypes");
        List offices = (List)map.get("offices");
        Map struCount = this.sysStruService.saveOrUpdateStruList(connName, strus);
        Map organCount = this.sysOrganService.saveOrUpdateOrganList(connName, organs);
        Map organTypeCount = this.sysOrganTypeService.saveOrUpdateOrganTypeList(connName, organTypes);
        Map officeCount = this.iSysOfficeService.saveOrUpdateOfficeList(connName, offices);
    }
}

