/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.tenant.common.dto.TenantLogDto;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.service.IHussarRetryService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u8fd0\u884c\u65e5\u5fd7"})
@RestController(value="com.jxdinfo.hussar.tenant.common.controller.hussarBaseTenantLogController")
@RequestMapping(value={"/hussarBase/tenant/log"})
public class HussarBaseTenantLogReplayingController {
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private IHussarRetryService retryService;

    @GetMapping(value={"/logList"})
    @ApiOperation(value="\u79df\u6237\u8fd0\u884c\u65e5\u5fd7\u5217\u8868", notes="\u79df\u6237\u8fd0\u884c\u65e5\u5fd7\u5217\u8868")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u79df\u6237\u8fd0\u884c\u65e5\u5fd7\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SysTenantLog>> logList(@ApiParam(value="\u65e5\u5fd7\u67e5\u8be2\u4fe1\u606f") TenantLogDto tenantLogDto) {
        return ApiResponse.success((Object)this.sysTenantLogService.logList(tenantLogDto));
    }

    @GetMapping(value={"/retry"})
    @ApiOperation(value="\u79df\u6237\u8fd0\u884c\u6b65\u9aa4\u91cd\u8bd5", notes="\u79df\u6237\u8fd0\u884c\u6b65\u9aa4\u91cd\u8bd5")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u79df\u6237\u8fd0\u884c\u6b65\u9aa4\u91cd\u8bd5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> retry(@ApiParam(value="\u79df\u6237\u7f16\u7801") @RequestParam String tenantCode) {
        this.retryService.replay(tenantCode);
        return ApiResponse.success((String)"\u91cd\u8bd5\u4e2d");
    }

    @GetMapping(value={"/replayOne"})
    @ApiOperation(value="\u79df\u6237\u8fd0\u884c\u5355\u6b65\u91cd\u8bd5", notes="\u79df\u6237\u8fd0\u884c\u5355\u6b65\u91cd\u8bd5")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u79df\u6237\u8fd0\u884c\u5355\u6b65\u91cd\u8bd5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> replayOne(@ApiParam(value="\u79df\u6237\u7f16\u7801") @RequestParam String tenantCode, @ApiParam(value="\u6b65\u9aa4\u7f16\u53f7") @RequestParam Integer stepNo) {
        SysTenantLog log = this.sysTenantLogService.getByTenantCodeAndStepNo(tenantCode, "", stepNo);
        AssertUtil.isTrue((boolean)HussarUtils.isNotEmpty((Object)log), (String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u65e5\u5fd7");
        this.retryService.replayOne(tenantCode, stepNo);
        return ApiResponse.success((String)("\u91cd\u8bd5\u3010" + log.getMethodDesc() + "\u3011\u4e2d"));
    }
}

