/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.job;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.dispatch.api.entity.JobInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class HussarBaseCheckExpiredTenantJob
implements BasicProcessor {
    @Resource
    private ISysTenantService tenantService;
    @Resource
    private ISysTenantRecordService tenantRecordService;
    @Autowired
    private JobServiceService jobServiceService;

    public ProcessResult process(TaskContext context) throws Exception {
        HussarContextHolder.setTenant((String)context.getDbName(), (String)context.getTenantCode());
        List tenantList = this.tenantService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantStatus, (Object)"1"));
        LocalDateTime now = LocalDateTime.now();
        ArrayList<SysTenant> expiredTenant = new ArrayList<SysTenant>();
        for (SysTenant item : tenantList) {
            if (!"1".equals(item.getTimeLimit()) || !now.isAfter(item.getEndTime())) continue;
            item.setTenantStatus("2");
            expiredTenant.add(item);
        }
        if (HussarUtils.isNotEmpty(expiredTenant)) {
            List recordList;
            List ids = EntityUtils.toList(expiredTenant, SysTenant::getId);
            List tenantCodes = EntityUtils.toList(expiredTenant, SysTenant::getTenantCode);
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put("tenantCode_in", new String[]{String.join((CharSequence)",", tenantCodes)});
            List jobList = (List)this.jobServiceService.getJobListApi(map).getData();
            if (HussarUtils.isNotEmpty((Object)jobList)) {
                for (JobInfoEntity job : jobList) {
                    ((JobServiceService)SpringContextHolder.getBean(JobServiceService.class)).disableJobApi(job.getId());
                }
            }
            if (HussarUtils.isNotEmpty((Object)(recordList = this.tenantRecordService.list((Wrapper)new LambdaQueryWrapper().in(SysTenantRecord::getTenantId, (Collection)ids))))) {
                for (SysTenantRecord record : recordList) {
                    HussarTenantDefinition definitionParse;
                    String paramStr = record.getTenantParams();
                    String className = record.getTenantClass();
                    Class clazz = null;
                    try {
                        clazz = ClassUtils.forName((String)className, (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    if (!HussarUtils.isNotEmpty((Object)(definitionParse = (HussarTenantDefinition)JSON.parseObject((String)paramStr, (Class)clazz)))) continue;
                    definitionParse.setTenantStatus("2");
                    record.setTenantParams(JSON.toJSONString((Object)definitionParse));
                    TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definitionParse);
                }
                this.tenantRecordService.updateBatchById((Collection)recordList);
            }
            this.tenantService.updateBatchById(expiredTenant);
        }
        return new ProcessResult(true, "success");
    }
}

