/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.factory.StorageFactory;
import com.jxdinfo.hussar.datasource.model.RDBStorageDefinition;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.job.dispatch.api.entity.JobInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.model.HussarMethod;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSecure;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.TenantPermissionData;
import com.jxdinfo.hussar.tenant.common.service.IAsyncUpdateTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideCreateStorageService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideDeleteDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSecureService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantLogUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;

public abstract class AbstractHussarBaseTenantService<T extends HussarTenantDefinition>
implements IHussarBaseTenantService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHussarBaseTenantService.class);
    @Autowired
    private ISysTenantService tenantService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysRoleFunctionsService roleFunctionsService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysFunctionsService functionsService;
    @Autowired
    private SysAuthClientModelService sysAuthClientModelService;
    @Autowired
    private JobServiceService jobServiceService;
    @Autowired
    private ISysTenantSecureService tenantSecureService;
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Autowired
    private ISysResourcesService resourcesService;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private ISysTenantDataSourceService sysTenantDataSourceService;
    private static ExecutorService hussarBaseTenantExecutor = (ExecutorService)SpringContextHolder.getBean(ExecutorService.class);
    @Autowired
    private ISysRoleResourceService roleResourceService;
    @Autowired
    private ISysTenantRecordService tenantRecordService;
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSQLExecutor;
    @Autowired
    private ISysTenantUpgradeService sysTenantUpgradeService;
    @Autowired
    private IAsyncUpdateTenantLogService asyncUpdateTenantLogService;
    @Autowired
    private ISysTenantRegisterService sysTenantRegisterService;

    public HussarTenantDefinition getTenantByTenantCode(String tenantCode) {
        return this.tenantService.getTenantByTenantCode(tenantCode);
    }

    public HussarTenantDefinition getTenantByTenantId(Long tenantId) {
        return this.tenantService.getTenantByTenantId(tenantId);
    }

    public HussarTenantDefinition getTenantByDomain(String domain) {
        return this.tenantService.getTenantByDomain(domain);
    }

    public void addTenant(T t) {
        Long tenantId = IdWorker.getId(t);
        t.setTenantId(tenantId);
        t.setTenantStatus("3");
        this.checkData(t);
        TenantCacheUtil.putTenat2Cache(t);
        SysTenant sysTenant = TenantUtil.convert2SysTenant(t);
        this.tenantService.save((Object)sysTenant);
        LOGGER.info("\u521b\u5efa\u79df\u6237START{}", (Object)t.getTenantCode());
        hussarBaseTenantExecutor.execute(() -> this.asyncAdd(t));
    }

    public void deleteTenant(Long tenantId) {
        AssertUtil.isNotNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SysTenant tenant = (SysTenant)this.tenantService.getById((Serializable)tenantId);
        AssertUtil.isNotNull((Object)tenant, (String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
        String tenantCode = tenant.getTenantCode();
        String connName = tenant.getConnName();
        tenant.setTenantStatus("0");
        this.tenantService.updateById((Object)tenant);
        HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantId((Long)tenantId);
        if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
            hussarTenantDefinition.setTenantStatus("0");
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
        }
        try {
            LOGGER.info("\u5220\u9664\u79df\u6237\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f");
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put("tenantCode_eq", new String[]{tenantCode});
            List joblist = (List)this.jobServiceService.getJobListApi(map).getData();
            if (HussarUtils.isNotEmpty((Object)joblist)) {
                for (JobInfoEntity job : joblist) {
                    this.jobServiceService.physicalDeleteJob(job.getId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79df\u6237\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff1a{}" + e.getMessage());
        }
        try {
            LOGGER.info("\u5220\u9664\u79df\u6237\u5347\u7ea7\u65e5\u5fd7\u7b49\u4fe1\u606f");
            this.sysTenantLogService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode));
            this.tenantSecureService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getTenantCode, (Object)tenantCode));
            this.sysTenantUpgradeService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantUpgrade::getTenantCode, (Object)tenantCode));
            this.tenantRecordService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79df\u6237\u5347\u7ea7\u65e5\u5fd7\u5931\u8d25\uff1a{}" + e.getMessage());
        }
        try {
            String currentServiceName;
            List serviceList;
            LOGGER.info("\u5220\u9664\u79df\u6237\u6570\u636e\u6e90\u4fe1\u606f");
            LambdaQueryWrapper dswrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName)).eq(SysTenantDatasource::getDatasourceType, (Object)"1");
            SysTenantDatasource dsTemp = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)dswrapper);
            if (HussarUtils.isNotEmpty((Object)dsTemp)) {
                dsTemp.setDelFlag("1");
                this.sysTenantDataSourceService.updateById((Object)dsTemp);
            }
            this.dynamicDatasourceService.removeDynamicDatasource(connName);
            boolean microService = EnvironmentUtil.isMicroService();
            if (microService && HussarUtils.isNotEmpty((Object)(serviceList = this.sysTenantRegisterService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantRegister::getServiceName, (Object)(currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"))))))) {
                for (SysTenantRegister temp : serviceList) {
                    ((IOutSideDeleteDataSourceService)SpringContextHolder.getBean(IOutSideDeleteDataSourceService.class)).doDeleteDataSource(connName, temp.getServiceName());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79df\u6237\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a{}" + e.getMessage());
        }
    }

    private void dealFail(String tenantCode) {
        SysTenant sysTenant = (SysTenant)this.tenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode));
        if (HussarUtils.isNotEmpty((Object)sysTenant)) {
            sysTenant.setTenantStatus("4");
            this.tenantService.updateById((Object)sysTenant);
            HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
            if (HussarUtils.isNotEmpty((Object)definition)) {
                definition.setTenantStatus("4");
                TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
            }
        }
    }

    public void asyncAdd(T t) {
        String connName = t.getConnName();
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        try {
            this.createDb(t);
            LOGGER.info("\u521b\u5efa\u6570\u636e\u6e90{}\u5b8c\u6210", (Object)connName);
        }
        catch (Exception e) {
            this.dynamicDatasourceService.removeDynamicDatasource(connName);
            this.dealFail(t.getTenantCode());
            LOGGER.info("\u521b\u5efa\u6570\u636e\u5b58\u50a8{}\u5931\u8d25", (Object)connName);
            throw e;
        }
        SysTenantLog beforeAddTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.BEFORE_ADD_TENANT));
        if (HussarUtils.isEmpty((Object)beforeAddTenantLog)) {
            beforeAddTenantLog = TenantLogUtil.newBeforeAddTenantLog(t);
        }
        try {
            this.beforeAddTenant(t);
            LOGGER.info("\u524d\u7f6e\u64cd\u4f5c\u5b8c\u6210");
            beforeAddTenantLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(beforeAddTenantLog);
        }
        catch (Exception e) {
            beforeAddTenantLog.setExecStatus(Integer.valueOf(0));
            beforeAddTenantLog.setErrorTimes(Integer.valueOf(beforeAddTenantLog.getErrorTimes() + 1));
            beforeAddTenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(beforeAddTenantLog);
            LOGGER.error("\u6dfb\u52a0\u79df\u6237\u4e4b\u524d\u7684\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantPermissionLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_TENANT_PERMISSION));
        if (HussarUtils.isEmpty((Object)initTenantPermissionLog)) {
            initTenantPermissionLog = TenantLogUtil.newInitTenantPermissionLog(t);
        }
        try {
            this.initTenantPermissionData(connName);
            initTenantPermissionLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantPermissionLog);
        }
        catch (Exception e) {
            initTenantPermissionLog.setExecStatus(Integer.valueOf(0));
            initTenantPermissionLog.setErrorTimes(Integer.valueOf(initTenantPermissionLog.getErrorTimes() + 1));
            initTenantPermissionLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantPermissionLog);
            LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u6743\u9650\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantAdminLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_TENANT_ADMIN));
        if (HussarUtils.isEmpty((Object)initTenantAdminLog)) {
            initTenantAdminLog = TenantLogUtil.initTenantAdminLog(t);
        }
        try {
            this.initTenantAdmin(connName, t);
            LOGGER.info("\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u5b8c\u6210");
            initTenantAdminLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantAdminLog);
        }
        catch (Exception e) {
            initTenantAdminLog.setExecStatus(Integer.valueOf(0));
            initTenantAdminLog.setErrorTimes(Integer.valueOf(initTenantAdminLog.getErrorTimes() + 1));
            initTenantAdminLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantAdminLog);
            LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantAdminRoleLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_TENANT_ROLE));
        if (HussarUtils.isEmpty((Object)initTenantAdminRoleLog)) {
            initTenantAdminRoleLog = TenantLogUtil.newInitTenantAdminRoleLog(t);
        }
        try {
            this.initTenantAdminRole(connName, t.getTenantAdminId());
            LOGGER.info("\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u89d2\u8272\u5b8c\u6210");
            initTenantAdminRoleLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantAdminRoleLog);
        }
        catch (Exception e) {
            initTenantAdminRoleLog.setExecStatus(Integer.valueOf(0));
            initTenantAdminRoleLog.setErrorTimes(Integer.valueOf(initTenantAdminRoleLog.getErrorTimes() + 1));
            initTenantAdminRoleLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantAdminRoleLog);
            LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u7ba1\u7406\u5458\u89d2\u8272\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initClientInfoLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_CLIENT_INFO));
        if (HussarUtils.isEmpty((Object)initClientInfoLog)) {
            initClientInfoLog = TenantLogUtil.newInitClientInfoLog(t);
        }
        try {
            this.initClientInfo(connName, (HussarTenantDefinition)t);
            LOGGER.info("\u521d\u59cb\u5316\u79df\u6237\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f\u5b8c\u6210");
            initClientInfoLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initClientInfoLog);
        }
        catch (Exception e) {
            initClientInfoLog.setExecStatus(Integer.valueOf(0));
            initClientInfoLog.setErrorTimes(Integer.valueOf(initClientInfoLog.getErrorTimes() + 1));
            initClientInfoLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initClientInfoLog);
            LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        this.initJobInfo(connName, t.getTenantId(), t.getTenantCode());
        LOGGER.info("\u521d\u59cb\u5316\u79df\u6237\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f\u5b8c\u6210");
        SysTenantLog saveTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.SAVE_TENANT));
        if (HussarUtils.isEmpty((Object)saveTenantLog)) {
            saveTenantLog = TenantLogUtil.newSaveTenantLog(t);
        }
        try {
            this.saveTenant(t);
            LOGGER.info("\u4fdd\u5b58\u79df\u6237\u57fa\u7840\u4fe1\u606f\u5b8c\u6210");
            saveTenantLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(saveTenantLog);
        }
        catch (Exception e) {
            saveTenantLog.setExecStatus(Integer.valueOf(0));
            saveTenantLog.setErrorTimes(Integer.valueOf(saveTenantLog.getErrorTimes() + 1));
            saveTenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(saveTenantLog);
            LOGGER.error("\u4fdd\u5b58\u79df\u6237\u57fa\u7840\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog afterAddTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.AFTER_ADD_TENANT));
        if (HussarUtils.isEmpty((Object)afterAddTenantLog)) {
            afterAddTenantLog = TenantLogUtil.newAfterAddTenantLog(t);
        }
        try {
            this.afterAddTenant(t);
            LOGGER.info("\u540e\u7f6e\u64cd\u4f5c\u5b8c\u6210");
            afterAddTenantLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(afterAddTenantLog);
        }
        catch (Exception e) {
            afterAddTenantLog.setExecStatus(Integer.valueOf(0));
            afterAddTenantLog.setErrorTimes(Integer.valueOf(saveTenantLog.getErrorTimes() + 1));
            afterAddTenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(afterAddTenantLog);
            LOGGER.error("\u6dfb\u52a0\u79df\u6237\u4e4b\u540e\u7684\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
        this.tenantService.updateTenantStatus(t.getTenantCode());
    }

    public void initTenantPermissionData(String connName) {
        List functionsList;
        List resourcesList = this.resourcesService.list(connName);
        if (HussarUtils.isNotEmpty((Object)resourcesList)) {
            this.buildRelationOfResource(connName, resourcesList);
        }
        if (HussarUtils.isNotEmpty((Object)(functionsList = this.functionsService.list(connName)))) {
            this.buildRelationOfFunction(connName, functionsList);
        }
        LOGGER.info("\u521d\u59cb\u5316\u79df\u6237\u6743\u9650\u5b8c\u6210");
    }

    private void buildRelationOfResource(String connName, Collection<SysResources> resourcesList) {
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        if (HussarUtils.isNotEmpty(resourcesList)) {
            for (SysResources resources : resourcesList) {
                SysRoleResource roleResource = new SysRoleResource();
                roleResource.setResourceId(resources.getId());
                roleResource.setRoleId(TenantConstant.ADMIN_ROLE);
                roleResource.setRelationSource("2");
                roleResourceList.add(roleResource);
            }
            this.roleResourceService.saveBatch(connName, roleResourceList);
        }
    }

    private void buildRelationOfFunction(String connName, Collection<SysFunctions> functionsList) {
        ArrayList<SysRoleFunctions> roleFunctionsList = new ArrayList<SysRoleFunctions>();
        if (HussarUtils.isNotEmpty(functionsList)) {
            for (SysFunctions function : functionsList) {
                SysRoleFunctions roleFunctions = new SysRoleFunctions();
                roleFunctions.setFunctionId(function.getId());
                roleFunctions.setRoleId(TenantConstant.ADMIN_ROLE);
                roleFunctionsList.add(roleFunctions);
            }
            this.roleFunctionsService.saveBatch(connName, roleFunctionsList);
        }
    }

    public void checkData(T t) {
        String domain;
        T definition = t;
        String tenantCode = definition.getTenantCode();
        long tenantId = definition.getTenantId();
        String validateMsg = this.validateService.validate(definition);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        List tenantList = this.tenantService.list();
        if (HussarUtils.isNotEmpty((Object)tenantList)) {
            Optional<SysTenant> anyTenantCode = tenantList.stream().filter(item -> item.getTenantCode().equalsIgnoreCase(tenantCode)).findAny();
            AssertUtil.isFalse((boolean)anyTenantCode.isPresent(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u79df\u6237\u7f16\u7801\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        if (StringUtils.isNotBlank((CharSequence)(domain = definition.getTenantDomain()))) {
            AssertUtil.isTrue((boolean)domain.matches("^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}"), (String)"\u975e\u6cd5\u57df\u540d\uff01");
            if (HussarUtils.isNotEmpty((Object)tenantList)) {
                Optional<SysTenant> anyDomain = tenantList.stream().filter(item -> HussarUtils.isNotBlank((CharSequence)item.getTenantDomain()) && item.getTenantDomain().equalsIgnoreCase(domain)).findAny();
                AssertUtil.isFalse((boolean)anyDomain.isPresent(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u79df\u6237\u7ed1\u5b9a\u57df\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09\uff01");
            }
        }
        String connName = StringUtils.trimToEmpty((String)definition.getConnName());
        boolean flag = false;
        if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equalsIgnoreCase("master")) {
            String regex = "^[A-Za-z]+[A-Za-z0-9-]*$";
            flag = connName.matches(regex);
        }
        AssertUtil.isTrue((boolean)flag, (String)"\u975e\u6cd5\u6570\u636e\u6e90\u540d\u79f0\uff01");
        Set allDatasourcesName = this.dynamicDatasourceService.getAllDatasourcesName();
        boolean contains = false;
        if (HussarUtils.isNotEmpty((Object)allDatasourcesName)) {
            for (String dsName : allDatasourcesName) {
                if (!dsName.equalsIgnoreCase(connName)) continue;
                contains = true;
                break;
            }
        }
        AssertUtil.isFalse((boolean)contains, (String)"\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d\uff01");
        List dsList = this.sysTenantDataSourceService.list();
        if (HussarUtils.isNotEmpty((Object)dsList)) {
            Optional<SysTenantDatasource> anyDs = dsList.stream().filter(item -> item.getConnName().equalsIgnoreCase(connName)).findAny();
            AssertUtil.isFalse((boolean)anyDs.isPresent(), (String)"\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d\uff01");
        }
        List storagePropertiesList = definition.getStoragePropertiesList();
        AssertUtil.isTrue((boolean)HussarUtils.isNotEmpty((Object)storagePropertiesList), (String)"\u79df\u6237\u6570\u636e\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a\uff01");
        for (Map mapDb : storagePropertiesList) {
            this.checkDb(mapDb);
        }
        this.tenantRecordService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        SysTenantRecord record = new SysTenantRecord();
        record.setTenantId(Long.valueOf(tenantId));
        record.setConnName(definition.getConnName());
        record.setTenantCode(tenantCode);
        record.setConnName(connName);
        record.setTenantClass(t.getClass().getName());
        record.setTenantParams(JSON.toJSONString(t));
        this.tenantRecordService.save((Object)record);
    }

    private void checkDb(Map<String, Object> storageProperties) {
        String storageType = (String)storageProperties.get("storageType");
        if (!storageType.equals("rdb")) {
            return;
        }
        String json = JSON.toJSONString(storageProperties);
        RDBStorageDefinition definition = (RDBStorageDefinition)JSON.parseObject((String)json, RDBStorageDefinition.class);
        String creation = definition.getCreation();
        if (creation.equals("2")) {
            String jdbcUrl = definition.getJdbcUrl();
            String userName = definition.getUserName();
            String password = definition.getPassword();
            AssertUtil.isTrue((boolean)this.hussarBaseSQLExecutor.checkDbConnection(jdbcUrl, userName, password), (String)"\u79df\u6237\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
    }

    private void createDb(T t) {
        T definition = t;
        List storagePropertiesList = definition.getStoragePropertiesList();
        boolean isMicroservice = EnvironmentUtil.isMicroService();
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (HussarUtils.isNotEmpty((Object)storagePropertiesList)) {
            if (isMicroservice) {
                LOGGER.info("\u5f00\u59cb\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8");
                ArrayList<Map> storagePropertiesListOther = new ArrayList<Map>();
                Map<String, Object> masterstorageProperties = new HashMap<String, Object>();
                for (Map storageProperties : storagePropertiesList) {
                    String serviceName = (String)storageProperties.get("serviceName");
                    AssertUtil.isNotEmpty((String)serviceName, (String)"\u5fae\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    storageProperties.put("tenantCode", definition.getTenantCode());
                    storageProperties.put("connName", definition.getConnName());
                    if (serviceName.equalsIgnoreCase(currentServiceName)) {
                        masterstorageProperties = storageProperties;
                        continue;
                    }
                    storageProperties.put("caller", currentServiceName);
                    storagePropertiesListOther.add(storageProperties);
                }
                SysTenantLog createDb = this.getSysTenantCreateDbLog(t, currentServiceName, masterstorageProperties);
                try {
                    String storageType = (String)masterstorageProperties.get("storageType");
                    if (HussarUtils.isBlank((CharSequence)storageType)) {
                        storageType = "rdb";
                    }
                    StorageFactory.get((String)storageType).createDatabaseAndInitData(masterstorageProperties);
                    SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)definition.getTenantCode()), false);
                    if (HussarUtils.isNotEmpty((Object)recordTemp)) {
                        recordTemp.setTenantParams(JSON.toJSONString(t));
                        this.tenantRecordService.updateById((Object)recordTemp);
                    }
                    createDb.setExecStatus(Integer.valueOf(1));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                }
                catch (Exception e) {
                    createDb.setExecStatus(Integer.valueOf(0));
                    createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
                    createDb.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                    throw new BaseException("\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01", (Throwable)e);
                }
                if (HussarUtils.isEmpty(storagePropertiesListOther)) {
                    return;
                }
                IOutSideCreateStorageService outSideCreateStorageService = (IOutSideCreateStorageService)SpringContextHolder.getBean(IOutSideCreateStorageService.class);
                AssertUtil.isNotNull((Object)outSideCreateStorageService, (String)"\u83b7\u53d6IOutSideCreateStorageService\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f15\u5165hussar-tenant-outside\u5305\uff01");
                int startNo = StepConstants.MICROSERVICE_CREATE_DB_MIN;
                ArrayList<SysTenantLog> serviceLogs = new ArrayList<SysTenantLog>();
                for (Map outSideStorageProperties : storagePropertiesListOther) {
                    String serviceNameTemp = (String)outSideStorageProperties.get("serviceName");
                    SysTenantLog createDbTemp = this.getSysTenantCreateDbLog(t, serviceNameTemp, outSideStorageProperties);
                    createDbTemp.setStepNo(Integer.valueOf(startNo++));
                    serviceLogs.add(createDbTemp);
                }
                this.sysTenantLogService.saveBatch(serviceLogs);
                for (Map outSideStorageProperties : storagePropertiesListOther) {
                    outSideCreateStorageService.dealCreateStorage(outSideStorageProperties, (String)outSideStorageProperties.get("serviceName"));
                }
            } else {
                LOGGER.info("\u5f00\u59cb\u521b\u5efa\u6570\u636e\u5b58\u50a8");
                Map storageProperties = (Map)storagePropertiesList.get(0);
                String storageType = (String)storageProperties.get("storageType");
                storageProperties.put("tenantCode", definition.getTenantCode());
                storageProperties.put("connName", definition.getConnName());
                SysTenantLog createDb = this.getSysTenantCreateDbLog(t, currentServiceName, storageProperties);
                try {
                    StorageFactory.get((String)storageType).createDatabaseAndInitData(storageProperties);
                    SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)definition.getTenantCode()), false);
                    if (HussarUtils.isNotEmpty((Object)recordTemp)) {
                        recordTemp.setTenantParams(JSON.toJSONString(t));
                        this.tenantRecordService.updateById((Object)recordTemp);
                    }
                    createDb.setExecStatus(Integer.valueOf(1));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                }
                catch (Exception e) {
                    createDb.setExecStatus(Integer.valueOf(0));
                    createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
                    createDb.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                    throw new BaseException("\u521b\u5efa\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01", (Throwable)e);
                }
            }
        }
    }

    @NotNull
    private SysTenantLog getSysTenantCreateDbLog(T t, String currentServiceName, Map<String, Object> masterstorageProperties) {
        SysTenantLog createDb = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.CREATE_DB));
        if (HussarUtils.isEmpty((Object)createDb)) {
            createDb = TenantLogUtil.newCreateDbLog(t.getClass(), (String)t.getTenantCode(), (String)t.getConnName(), (String)currentServiceName, masterstorageProperties);
        }
        return createDb;
    }

    public abstract void saveTenant(T var1);

    private void initTenantAdminRole(String connName, Long userId) {
        SysRoles adminRole = new SysRoles();
        adminRole.setId(TenantConstant.ADMIN_ROLE);
        adminRole.setRolePermission("ADMIN_ROLE");
        adminRole.setRoleName("\u7ba1\u7406\u5458\u89d2\u8272");
        adminRole.setRoleAlias("\u7ba1\u7406\u5458\u89d2\u8272");
        adminRole.setIsSys("1");
        adminRole.setGroupId(Long.valueOf(1450785135866925059L));
        adminRole.setRoleOrder(Integer.valueOf(10));
        this.sysRolesService.save(connName, (Object)adminRole);
        this.sysUserRoleService.saveUserRole(connName, userId);
    }

    public void initClientInfo(String connName, HussarTenantDefinition definition) {
        SysAuthClientModel authClientModel = new SysAuthClientModel();
        long id = IdWorker.getId((Object)authClientModel);
        authClientModel.setId(Long.valueOf(id));
        authClientModel.setClientId(String.valueOf(definition.getTenantId()));
        authClientModel.setClientSecret(UUID.randomUUID().toString().replace("-", ""));
        authClientModel.setAuthorizedGrantType("client_credentials");
        authClientModel.setContractScope("server");
        authClientModel.setAllowUrl("*");
        authClientModel.setAccessTokenValidTime(1800L);
        authClientModel.setRefreshTokenValidTime(86400L);
        definition.setClientId(authClientModel.getClientId());
        definition.setClientSecret(authClientModel.getClientSecret());
        try {
            this.sysAuthClientModelService.saveAuthClientModel(connName, authClientModel);
            SysTenantSecure sysTenantSecure = new SysTenantSecure();
            sysTenantSecure.setTenantId(definition.getTenantId());
            sysTenantSecure.setTenantCode(definition.getTenantCode());
            sysTenantSecure.setClientId(authClientModel.getClientId());
            sysTenantSecure.setClientSecret(authClientModel.getClientSecret());
            this.tenantSecureService.save((Object)sysTenantSecure);
            SysTenant tenant = TenantUtil.convert2SysTenant(definition);
            this.tenantService.updateById((Object)tenant);
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5ba2\u6237\u7aef\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
    }

    public void initJobInfo(String connName, Long tenantId, String tenantCode) {
        SysTenantLog initJobInfoLog = null;
        List<JobInfoEntity> tenantJobInfoList = this.getDefaultInitJob(connName, tenantId, tenantCode);
        if (HussarUtils.isNotEmpty(tenantJobInfoList)) {
            try {
                initJobInfoLog = this.newInitJobInfoLog(tenantCode, connName, tenantJobInfoList);
                this.deleteJobByTenantCode(tenantCode);
                ApiResponse booleanApiResponse = this.jobServiceService.saveJobList(tenantJobInfoList);
                if (booleanApiResponse.isSuccess()) {
                    initJobInfoLog.setExecStatus(Integer.valueOf(1));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(initJobInfoLog);
                } else {
                    this.deleteJobByTenantCode(tenantCode);
                    initJobInfoLog.setExecStatus(Integer.valueOf(0));
                    initJobInfoLog.setErrorTimes(Integer.valueOf(1));
                    initJobInfoLog.setExecError("\u521d\u59cb\u5316\u79df\u6237\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff01");
                    this.asyncUpdateTenantLogService.tenantlogUpdate(initJobInfoLog);
                }
            }
            catch (Exception e) {
                this.deleteJobByTenantCode(tenantCode);
                initJobInfoLog.setExecStatus(Integer.valueOf(0));
                initJobInfoLog.setErrorTimes(Integer.valueOf(1));
                initJobInfoLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                this.asyncUpdateTenantLogService.tenantlogUpdate(initJobInfoLog);
                LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff01", (Throwable)e);
            }
        }
    }

    private void deleteJobByTenantCode(String tenantCode) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("tenantCode_eq", new String[]{tenantCode});
        List jobList = (List)this.jobServiceService.getJobListApi(map).getData();
        if (HussarUtils.isEmpty((Object)jobList)) {
            return;
        }
        for (JobInfoEntity temp : jobList) {
            this.jobServiceService.physicalDeleteJob(temp.getId());
        }
    }

    public SysTenantLog newInitJobInfoLog(String tenantCode, String connName, List<JobInfoEntity> tenantJobInfoList) {
        SysTenantLog initJobInfoLog = new SysTenantLog();
        initJobInfoLog.setStepNo(Integer.valueOf(StepConstants.INIT_JOB_INFO));
        initJobInfoLog.setMethodTag("initJobInfo");
        initJobInfoLog.setTenantCode(tenantCode);
        initJobInfoLog.setBeanName("JobServiceService");
        initJobInfoLog.setMethodName("saveBatch");
        initJobInfoLog.setMethodDesc("\u521d\u59cb\u5316\u79df\u6237\u5b9a\u65f6\u4efb\u52a1");
        initJobInfoLog.setConnName(connName);
        Class[] paramClass = new Class[]{String.class, List.class};
        Object[] paramValues = new Object[]{tenantCode, tenantJobInfoList};
        initJobInfoLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(List.class, paramClass, paramValues)));
        initJobInfoLog.setExecStatus(Integer.valueOf(2));
        initJobInfoLog.setErrorTimes(Integer.valueOf(0));
        if (EnvironmentUtil.isMicroService()) {
            initJobInfoLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return initJobInfoLog;
    }

    public TenantPermissionData subtract(TenantPermissionData a, TenantPermissionData b) {
        TenantPermissionData ret = new TenantPermissionData();
        Collection afunctionModules = a.getFunctionModules();
        Collection afunctions = a.getFunctions();
        Collection aresourceModules = a.getResourceModules();
        Collection aresources = a.getResources();
        Collection amenus = a.getMenus();
        Collection afunctionResources = a.getFunctionResources();
        Collection bfunctionModules = b.getFunctionModules();
        Set bfunctionModuleIds = EntityUtils.toSet((Collection)bfunctionModules, SysFunctionModules::getId);
        Collection bfunctions = b.getFunctions();
        Set bfunctionIds = EntityUtils.toSet((Collection)bfunctions, SysFunctions::getId);
        Collection bresourceModules = b.getResourceModules();
        Set bresourceModuleIds = EntityUtils.toSet((Collection)bresourceModules, SysResourceModules::getId);
        Collection bresources = b.getResources();
        Set bresourceIds = EntityUtils.toSet((Collection)bresources, SysResources::getId);
        Collection bmenus = b.getMenus();
        Set bmenuIds = EntityUtils.toSet((Collection)bmenus, SysMenu::getId);
        Collection bfunctionResources = b.getFunctionResources();
        Set functionModules = afunctionModules.stream().filter(e -> !bfunctionModuleIds.contains(e.getId())).collect(Collectors.toSet());
        Set functions = afunctions.stream().filter(e -> !bfunctionIds.contains(e.getId())).collect(Collectors.toSet());
        Set resourceModules = aresourceModules.stream().filter(e -> !bresourceModuleIds.contains(e.getId())).collect(Collectors.toSet());
        Set resources = aresources.stream().filter(e -> !bresourceIds.contains(e.getId())).collect(Collectors.toSet());
        Set menus = amenus.stream().filter(e -> !bmenuIds.contains(e.getId())).collect(Collectors.toSet());
        HashSet<SysFunctionResources> functionResources = new HashSet<SysFunctionResources>();
        for (SysFunctionResources asysFunctionResources : afunctionResources) {
            for (SysFunctionResources bsysFunctionResources : bfunctionResources) {
                if (asysFunctionResources.getResourceId().equals(bsysFunctionResources.getResourceId()) && asysFunctionResources.getFunctionId().equals(bsysFunctionResources.getFunctionId())) continue;
                functionResources.add(asysFunctionResources);
            }
        }
        ret.setFunctions(functions);
        ret.setFunctionModules(functionModules);
        ret.setResources(resources);
        ret.setResourceModules(resourceModules);
        ret.setMenus(menus);
        ret.setFunctionResources(functionResources);
        return ret;
    }

    public void editTenant(T t) {
        boolean microService;
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        SysTenant tenant = TenantUtil.convert2SysTenant(t);
        LocalDateTime now = LocalDateTime.now();
        if ("1".equals(tenant.getTimeLimit()) && "2".equals(tenant.getTenantStatus()) && tenant.getEndTime().isAfter(now)) {
            tenant.setTenantStatus("1");
            t.setTenantStatus("1");
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put("tenantCode_eq", new String[]{tenant.getTenantCode()});
            List jobList = (List)((JobServiceService)SpringContextHolder.getBean(JobServiceService.class)).getJobListApi(map).getData();
            if (HussarUtils.isNotEmpty((Object)jobList)) {
                for (JobInfoEntity job : jobList) {
                    try {
                        ((JobServiceService)SpringContextHolder.getBean(JobServiceService.class)).enableJobApi(job.getId());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ("0".equals(tenant.getTimeLimit()) && "2".equals(tenant.getTenantStatus())) {
            tenant.setTenantStatus("1");
            t.setTenantStatus("1");
        }
        TenantCacheUtil.putTenat2Cache(t);
        this.tenantService.updateById((Object)tenant);
        SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantId, (Object)tenant.getId()));
        if (HussarUtils.isNotEmpty((Object)recordTemp)) {
            recordTemp.setTenantParams(JSON.toJSONString(t));
            this.tenantRecordService.updateById((Object)recordTemp);
        }
        if (!(microService = EnvironmentUtil.isMicroService())) {
            return;
        }
        List storagePropertiesList = t.getStoragePropertiesList();
        List sysTenantLogs = this.sysTenantLogService.listByTenantCode(tenant.getTenantCode());
        Set<Object> serviceNames = new HashSet();
        if (HussarUtils.isNotEmpty((Object)sysTenantLogs)) {
            serviceNames = sysTenantLogs.stream().map(SysTenantLog::getServiceName).collect(Collectors.toSet());
        }
        List<Map> storagePropertiesListOther = new ArrayList();
        if (HussarUtils.isNotEmpty(serviceNames)) {
            for (Map storagePropertiesMap : storagePropertiesList) {
                storagePropertiesMap.put("tenantCode", t.getTenantCode());
                storagePropertiesMap.put("connName", t.getConnName());
                storagePropertiesMap.put("caller", currentServiceName);
                String serviceName = (String)storagePropertiesMap.get("serviceName");
                String serviceUsed = (String)storagePropertiesMap.get("inUse");
                if (!serviceNames.contains(serviceName) && HussarUtils.isNotBlank((CharSequence)serviceUsed) && "1".equals(serviceUsed)) {
                    storagePropertiesListOther.add(storagePropertiesMap);
                }
                if (!serviceNames.contains(serviceName) || !HussarUtils.isNotBlank((CharSequence)serviceUsed)) continue;
                storagePropertiesMap.put("inUse", "");
            }
        } else {
            storagePropertiesListOther = storagePropertiesList;
        }
        if (HussarUtils.isNotEmpty(storagePropertiesListOther)) {
            tenant.setTenantStatus("3");
            HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantId((Long)tenant.getId());
            if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                hussarTenantDefinition.setTenantStatus("3");
                TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
            }
            this.tenantService.updateById((Object)tenant);
            Integer maxCreateDbStepNo = this.sysTenantLogService.getMaxCreateDbStepNo(tenant.getTenantCode());
            ArrayList<SysTenantLog> serviceLogs = new ArrayList<SysTenantLog>();
            for (Map outSideStorageProperties : storagePropertiesListOther) {
                outSideStorageProperties.put("caller", ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
                String serviceNameTemp = (String)outSideStorageProperties.get("serviceName");
                SysTenantLog createDbTemp = this.getSysTenantCreateDbLog(t, serviceNameTemp, outSideStorageProperties);
                maxCreateDbStepNo = maxCreateDbStepNo + 1;
                createDbTemp.setStepNo(maxCreateDbStepNo);
                serviceLogs.add(createDbTemp);
            }
            this.sysTenantLogService.saveBatch(serviceLogs);
            IOutSideCreateStorageService outSideCreateStorageService = (IOutSideCreateStorageService)SpringContextHolder.getBean(IOutSideCreateStorageService.class);
            ArrayList storagePropertiesListOtherCopy = new ArrayList(storagePropertiesListOther);
            hussarBaseTenantExecutor.execute(() -> {
                for (Map outSideStorageProperties : storagePropertiesListOtherCopy) {
                    outSideCreateStorageService.dealCreateStorage(outSideStorageProperties, (String)outSideStorageProperties.get("serviceName"));
                }
            });
        }
    }

    private List<JobInfoEntity> getDefaultInitJob(String connName, Long tenantId, String tenantCode) {
        String readJson = null;
        try {
            Resource resource = SpringContextHolder.getApplicationContext().getResource("classpath:tenantsql/initjob/tenantJob.json");
            readJson = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            if (HussarUtils.isNotBlank((CharSequence)readJson)) {
                List tenantJobInfoList = JSON.parseArray((String)readJson, JobInfoEntity.class);
                if (HussarUtils.isNotEmpty((Object)tenantJobInfoList)) {
                    for (JobInfoEntity sysTenantJobInfo : tenantJobInfoList) {
                        sysTenantJobInfo.setTenantCode(tenantCode);
                        sysTenantJobInfo.setDbName(connName);
                    }
                }
                return tenantJobInfoList;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public void updateTenantStatus() {
        ArrayList status = Lists.newArrayList((Object[])new String[]{"4", "2", "0"});
        List list = this.tenantService.list((Wrapper)new LambdaQueryWrapper().notIn(SysTenant::getTenantStatus, (Collection)status));
        if (HussarUtils.isEmpty((Object)list)) {
            return;
        }
        for (SysTenant sysTenant : list) {
            String tenantCode = sysTenant.getTenantCode();
            List allLogList = this.sysTenantLogService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode));
            Optional<SysTenantLog> any = allLogList.stream().filter(item -> Objects.equals(item.getStepNo(), StepConstants.AFTER_ADD_TENANT)).findAny();
            List errorLogList = allLogList.stream().filter(item -> item.getExecStatus().equals(0)).collect(Collectors.toList());
            List executeLogList = allLogList.stream().filter(item -> item.getExecStatus().equals(2)).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty((Object)allLogList) && HussarUtils.isEmpty(errorLogList) && HussarUtils.isEmpty(executeLogList) && any.isPresent()) {
                this.updateTenantStatus(tenantCode, "1");
                LOGGER.info("\u66f4\u65b0\u79df\u6237{}\u72b6\u6001\u4e3a\u6b63\u5e38", (Object)tenantCode);
            }
            if (HussarUtils.isNotEmpty(errorLogList)) {
                this.updateTenantStatus(tenantCode, "4");
                LOGGER.info("\u66f4\u65b0\u79df\u6237{}\u72b6\u6001\u4e3a\u521b\u5efa\u5931\u8d25", (Object)tenantCode);
                continue;
            }
            if (!HussarUtils.isNotEmpty((Object)allLogList) || !HussarUtils.isNotEmpty(executeLogList)) continue;
            this.updateTenantStatus(tenantCode, "3");
            LOGGER.info("\u66f4\u65b0\u79df\u6237{}\u72b6\u6001\u4e3a\u521b\u5efa\u4e2d", (Object)tenantCode);
        }
    }

    public void updateTenantStatus(String tenantCode, String tenantStatus) {
        SysTenant sysTenant = (SysTenant)this.tenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode), false);
        if (HussarUtils.isNotEmpty((Object)sysTenant)) {
            sysTenant.setTenantStatus(tenantStatus);
            this.tenantService.updateById((Object)sysTenant);
            HussarTenantDefinition tenantByTenantCode = this.tenantService.getTenantByTenantCode(tenantCode);
            tenantByTenantCode.setTenantStatus(tenantStatus);
            SysTenantRecord sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
            sysTenantRecord.setTenantParams(JSON.toJSONString((Object)tenantByTenantCode));
            this.tenantRecordService.updateById((Object)sysTenantRecord);
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)tenantByTenantCode);
        }
    }
}

