/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.service.IAsyncUpdateTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AsyncUpdateTenantLogServiceImpl
implements IAsyncUpdateTenantLogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncUpdateTenantLogServiceImpl.class);
    @Autowired
    private ExecutorService hussarBaseTenantExecutor;
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private ISysTenantService tenantService;
    @Autowired
    private DefaultIdentifierGenerator identifierGenerator;
    @Autowired
    private ISysTenantRecordService tenantRecordService;

    public void tenantlogUpdate(SysTenantLog tenantLog) {
        this.hussarBaseTenantExecutor.execute(() -> {
            if (HussarUtils.isNotEmpty((Object)tenantLog)) {
                String serviceName;
                Integer stepNo = tenantLog.getStepNo();
                String tenantCode = tenantLog.getTenantCode();
                SysTenantLog logTemp = this.sysTenantLogService.getByTenantCodeAndStepNo(tenantCode, serviceName = tenantLog.getServiceName(), stepNo);
                if (HussarUtils.isEmpty((Object)logTemp)) {
                    AtomicBoolean flag = new AtomicBoolean(false);
                    do {
                        Long id = this.identifierGenerator.nextId((Object)tenantLog);
                        tenantLog.setId(id);
                        try {
                            this.sysTenantLogService.save((Object)tenantLog);
                            flag.set(true);
                            LOGGER.info("\u65b0\u589e\u65e5\u5fd7\uff0ctenantCode={},serviceName={}\uff0cstepNo={}", new Object[]{tenantCode, serviceName, stepNo});
                        }
                        catch (Exception e) {
                            flag.set(false);
                        }
                    } while (!flag.get());
                } else {
                    LOGGER.info("\u66f4\u65b0\u65e5\u5fd7\uff0ctenantCode={},serviceName={}\uff0cstepNo={}", new Object[]{tenantCode, serviceName, stepNo});
                    tenantLog.setId(logTemp.getId());
                    this.sysTenantLogService.updateById((Object)tenantLog);
                }
            }
            String tenantCode = tenantLog.getTenantCode();
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode);
            List logs = this.sysTenantLogService.list((Wrapper)wrapper);
            LambdaQueryWrapper tenantWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode);
            SysTenant one = (SysTenant)this.tenantService.getOne((Wrapper)tenantWrapper);
            if (HussarUtils.isNotEmpty((Object)logs)) {
                if (logs.stream().filter(item -> item.getExecStatus().equals(0)).findAny().isPresent()) {
                    one.setTenantStatus("4");
                } else if (logs.stream().filter(item -> item.getExecStatus().equals(2)).findAny().isPresent()) {
                    one.setTenantStatus("3");
                } else {
                    LambdaQueryWrapper wrapper2 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getStepNo, (Object)StepConstants.AFTER_ADD_TENANT);
                    SysTenantLog one1 = (SysTenantLog)this.sysTenantLogService.getOne((Wrapper)wrapper2);
                    if (HussarUtils.isNotEmpty((Object)one1)) {
                        one.setTenantStatus("1");
                    }
                }
            }
            this.tenantService.updateById((Object)one);
            HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
            if (HussarUtils.isNotEmpty((Object)definition)) {
                definition.setTenantStatus(one.getTenantStatus());
            } else {
                definition = this.tenantService.getTenantByTenantCode(tenantCode);
                definition.setTenantStatus(one.getTenantStatus());
            }
            SysTenantRecord sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
            sysTenantRecord.setTenantParams(JSON.toJSONString((Object)definition));
            this.tenantRecordService.updateById((Object)sysTenantRecord);
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
        });
    }
}

