/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.OutSideTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.service.IAsyncUpdateTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u8fd0\u884c\u65e5\u5fd7"})
@RestController(value="com.jxdinfo.hussar.tenant.common.controller.hussarBaseTenantOutSideMicroServiceLogController")
@RequestMapping(value={"/hussarBase/tenant/outsideLog"})
public class HussarBaseTenantOutSideMicroServiceLogController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseTenantOutSideMicroServiceLogController.class);
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private ISysTenantRecordService tenantRecordService;
    @Autowired
    private IAsyncUpdateTenantLogService asyncUpdateTenantLogService;

    @PostMapping(value={"/updateOutSideMicroServiceTenant"})
    public void updateOutSideMicroServiceTenant(@RequestBody OutSideTenantLog outSideTenantLog) {
        Boolean success = outSideTenantLog.getSuccess();
        String errMsg = outSideTenantLog.getErrMsg();
        String serviceName = outSideTenantLog.getServiceName();
        String tenantCode = outSideTenantLog.getTenantCode();
        String jdbcUrl = outSideTenantLog.getJdbcUrl();
        SysTenantLog updateLog = (SysTenantLog)this.sysTenantLogService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getServiceName, (Object)serviceName));
        AssertUtil.isNotNull((Object)updateLog, (String)("\u672a\u67e5\u8be2\u5230\u79df\u6237\u7f16\u7801\u4e3a" + tenantCode + ",\u5fae\u670d\u52a1\u540d\u79f0\u4e3a" + serviceName + "\u7684\u65e5\u5fd7\u4fe1\u606f\uff01"));
        if (success.booleanValue()) {
            updateLog.setExecStatus(Integer.valueOf(1));
        } else {
            updateLog.setExecStatus(Integer.valueOf(0));
            updateLog.setExecError(errMsg);
            updateLog.setErrorTimes(Integer.valueOf(updateLog.getErrorTimes() + 1));
        }
        LOGGER.info("\u79df\u6237\u7f16\u7801={}\u5fae\u670d\u52a1\u540d\u79f0={}\u6267\u884c\u56de\u8c03\u66f4\u65b0\u65e5\u5fd7\u5b8c\u6bd5", (Object)tenantCode, (Object)serviceName);
        if (HussarUtils.isNotBlank((CharSequence)jdbcUrl)) {
            SysTenantRecord tenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
            AssertUtil.isNotNull((Object)tenantRecord, (String)("\u672a\u67e5\u8be2\u5230\u79df\u6237\u7f16\u7801\u4e3a" + tenantCode + "\u7684\u521b\u5efa\u65e5\u5fd7\u53c2\u6570\u4fe1\u606f\uff01"));
            String param = tenantRecord.getTenantParams();
            JSONObject jsonObject = JSON.parseObject((String)param);
            JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"storagePropertiesList");
            if (HussarUtils.isNotEmpty((Object)jsonArray)) {
                for (Object o : jsonArray) {
                    JSONObject jsonObjectTemp = (JSONObject)o;
                    String serviceNameTemp = jsonObjectTemp.getString("serviceName");
                    if (!serviceName.equals(serviceNameTemp)) continue;
                    jsonObjectTemp.put("jdbcUrl", (Object)jdbcUrl);
                    jsonObjectTemp.put("inUse", (Object)"");
                    break;
                }
                String tenantParam = JSON.toJSONString((Object)jsonObject);
                HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
                if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                    List storagePropertiesList = hussarTenantDefinition.getStoragePropertiesList();
                    for (Map temp : storagePropertiesList) {
                        String serviceNameTemp = (String)temp.get("serviceName");
                        if (!serviceName.equals(serviceNameTemp)) continue;
                        temp.put("jdbcUrl", jdbcUrl);
                        temp.put("inUse", "");
                        break;
                    }
                    TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
                }
                tenantRecord.setTenantParams(tenantParam);
                this.tenantRecordService.updateById((Object)tenantRecord);
                LOGGER.info("\u79df\u6237\u7f16\u7801={}\u5fae\u670d\u52a1\u540d\u79f0={}\u6267\u884c\u66f4\u65b0jdbcUrl", (Object)tenantCode, (Object)serviceName);
            }
        }
        this.asyncUpdateTenantLogService.tenantlogUpdate(updateLog);
    }
}

