/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.tenant.common.dao.SysTenantLogMapper;
import com.jxdinfo.hussar.tenant.common.dao.SysTenantMapper;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.service.impl.sysTenantServiceImpl")
public class SysTenantServiceImpl
extends HussarServiceImpl<SysTenantMapper, SysTenant>
implements ISysTenantService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysTenantServiceImpl.class);
    @Resource
    private SysTenantMapper sysTenantMapper;
    @Resource
    private SysTenantLogMapper sysTenantLogMapper;
    @Autowired
    private ISysTenantRecordService tenantRecordService;

    public HussarTenantDefinition getTenantByTenantCode(String tenantCode) {
        return this.wrap(this.sysTenantMapper.getTenantByTenantCode(tenantCode));
    }

    private HussarTenantDefinition wrap(HussarTenantDefinition definition) {
        SysTenantRecord sysTenantRecord;
        if (HussarUtils.isNotEmpty((Object)definition) && HussarUtils.isNotEmpty((Object)(sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantId, (Object)definition.getTenantId()))))) {
            String paramStr = sysTenantRecord.getTenantParams();
            String className = sysTenantRecord.getTenantClass();
            Class clazz = null;
            try {
                clazz = ClassUtils.forName((String)className, (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            HussarTenantDefinition definitionParse = (HussarTenantDefinition)JSON.parseObject((String)paramStr, (Class)clazz);
            definition.setStoragePropertiesList(definitionParse.getStoragePropertiesList());
        }
        return definition;
    }

    public HussarTenantDefinition getTenantByTenantId(Long tenantId) {
        return this.wrap(this.sysTenantMapper.getTenantByTenantId(tenantId));
    }

    public HussarTenantDefinition getTenantByDomain(String domain) {
        return this.wrap(this.sysTenantMapper.getTenantByDomain(domain));
    }

    public void updateTenantStatus(String tenantCode) {
        LOGGER.info("\u66f4\u65b0\u79df\u6237{}\u72b6\u6001", (Object)tenantCode);
        List logList = this.sysTenantLogMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getExecStatus, (Object)0));
        ArrayList status = Lists.newArrayList((Object[])new String[]{"4", "2", "0"});
        SysTenant one = (SysTenant)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode)).notIn(SysTenant::getTenantStatus, (Collection)status), false);
        if (HussarUtils.isEmpty((Object)logList)) {
            HussarTenantDefinition definition;
            if (HussarUtils.isNotEmpty((Object)one)) {
                one.setTenantStatus("1");
                this.updateById((BaseEntity)one);
            }
            if (HussarUtils.isNotEmpty((Object)(definition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode)))) {
                definition.setTenantStatus("1");
                TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
            }
        } else {
            HussarTenantDefinition definition;
            LOGGER.info("\u79df\u6237{}\u5b58\u5728\u9519\u8bef\u65e5\u5fd7\uff0c\u5c06\u66f4\u65b0\u72b6\u6001\u4e3a", (Object)tenantCode, (Object)"4");
            if (HussarUtils.isNotEmpty((Object)one)) {
                one.setTenantStatus("4");
                this.updateById((BaseEntity)one);
            }
            if (HussarUtils.isNotEmpty((Object)(definition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode)))) {
                definition.setTenantStatus("4");
                TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
            }
        }
    }

    public void batchUpdateTenantStatus(List<String> tenantCodes) {
        ArrayList<String> updateList = new ArrayList<String>();
        List logList = this.sysTenantLogMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysTenantLog::getTenantCode, tenantCodes));
        if (HussarUtils.isNotEmpty((Object)logList)) {
            Collection subtract = CollectionUtils.subtract(tenantCodes, (Collection)EntityUtils.toSet((Collection)logList, SysTenantLog::getTenantCode));
            updateList.addAll(subtract);
        } else {
            updateList.addAll(tenantCodes);
        }
        if (HussarUtils.isNotEmpty(updateList)) {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SysTenant::getTenantCode, updateList)).set(SysTenant::getTenantStatus, (Object)"1"));
            List hussarTenantDefinitions = TenantCacheUtil.loadFromCacheByTenantCodes(updateList);
            for (HussarTenantDefinition definition : hussarTenantDefinitions) {
                definition.setTenantStatus("1");
                TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
            }
        }
    }
}

