/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.onsystem.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.properties.HussarTemplateFileProperties;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.properties.GitlabProperties;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.GitlabUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.UrlUtils;
import com.jxdinfo.hussar.general.common.service.IHussarTenantConfigService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.factory.StorageFactory;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.MiddleStep;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.model.TenantDbModel;
import com.jxdinfo.hussar.tenant.common.service.IOutSideCreateStorageService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideDeleteDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.impl.AbstractHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.onsystem.dao.SysTenantOnSystemMapper;
import com.jxdinfo.hussar.tenant.onsystem.model.SolitaryOnSystemTenant;
import com.jxdinfo.hussar.tenant.onsystem.model.SysTenantDeveloper;
import com.jxdinfo.hussar.tenant.onsystem.service.ISysTenantDeveloperService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.onsystem.service.impl.hussarBaseSolitaryOnSystemTenantServiceImpl")
public class HussarBaseSolitaryOnSystemTenantServiceImpl
extends AbstractHussarBaseTenantService<SolitaryOnSystemTenant> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseSolitaryOnSystemTenantServiceImpl.class);
    @Resource
    private HussarTemplateFileProperties templateFileProperties;
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantOnSystemMapper sysTenantOnSystemMapper;
    @Autowired
    private GitlabProperties gitlabProperties;
    @Autowired
    private ISysTenantDeveloperService tenantDelegateUserService;
    @Resource
    private IHussarBaseSQLExecutor hussarBaseSqlExecutor;
    @Resource
    private DatasourceService datasourceService;

    public Page<SolitaryOnSystemTenant> searchTenant(QueryTenantDto queryTenantDto) {
        Page page = new Page(queryTenantDto.getCurrent(), queryTenantDto.getSize());
        List<Object> solitaryOnSystemTenant = Lists.newArrayList();
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("tenantCode", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantCode()));
        queryOrgParams.put("tenantName", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantName()));
        queryOrgParams.put("tenantStatus", queryTenantDto.getTenantStatus());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails();
        Map extendUserMap = loginUserDetails.getExtendUserMap();
        List roleListIds = BaseSecurityUtil.formatToLongList(extendUserMap.get("rolesList"));
        if (!HussarUtils.isNotEmpty((Object)roleListIds) || !roleListIds.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue()) && !roleListIds.contains(SysUserAndRole.SYSTEMADMIN_ROLE.getValue())) {
            Long userId = loginUserDetails.getUserId();
            List tenantIds = this.tenantDelegateUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantDeveloper::getUserId, (Object)userId)).stream().map(SysTenantDeveloper::getTenantId).collect(Collectors.toList());
            List createTenantIds = this.sysTenantService.list((Wrapper)Wrappers.lambdaQuery().eq(HussarBaseEntity::getCreator, (Object)userId)).stream().map(SysTenant::getId).collect(Collectors.toList());
            tenantIds.addAll(createTenantIds);
            if (CollectionUtils.isEmpty(tenantIds)) {
                page.setRecords((List)solitaryOnSystemTenant);
                return page;
            }
            queryOrgParams.put("tenantId", tenantIds);
        }
        solitaryOnSystemTenant = this.sysTenantOnSystemMapper.searchSolitaryOnSystemTenant((Page<SolitaryOnSystemTenant>)page, queryOrgParams);
        page.setRecords((List)solitaryOnSystemTenant);
        return page;
    }

    public SolitaryOnSystemTenant findTenantById(Long tenantId) {
        HussarTenantDefinition tenantByTenantId = this.getTenantByTenantId(tenantId);
        return (SolitaryOnSystemTenant)TenantUtil.convert((HussarTenantDefinition)tenantByTenantId, SolitaryOnSystemTenant.class);
    }

    public void initTenantAdmin(String connName, SolitaryOnSystemTenant solitaryTenant) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setUserName(solitaryTenant.getLinkman());
        sysUsers.setMobile(solitaryTenant.getContactNumber());
        sysUsers.setUserAccount(solitaryTenant.getUserAccount());
        TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
        String encodeSecure = TenantUtil.getEncodeSecure((String)solitaryTenant.getSecure());
        sysUsers.setPassword(encodeSecure);
        Integer userOrder = this.usersService.getUserMaxOrder();
        userOrder = HussarUtils.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        sysUsers.setUserOrder(userOrder);
        this.usersService.save(connName, (Object)sysUsers);
        solitaryTenant.setTenantAdminId(sysUsers.getId());
        UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails();
        Long nowUserId = loginUserDetails.getUserId();
        SysUsers nowUser = this.usersService.getById(nowUserId);
        ArrayList<SysTenantDeveloper> addList = new ArrayList<SysTenantDeveloper>();
        SysTenantDeveloper tenantDelegateUser = new SysTenantDeveloper();
        tenantDelegateUser.setUserId(nowUserId);
        tenantDelegateUser.setTenantId(solitaryTenant.getTenantId());
        addList.add(tenantDelegateUser);
        this.tenantDelegateUserService.saveBatch(addList);
        ArrayList<SysUsers> tenantUsers = new ArrayList<SysUsers>();
        SysUsers adminUser = new SysUsers();
        adminUser.setId(nowUserId);
        adminUser.setUserName(nowUser.getUserName());
        adminUser.setMobile(nowUser.getMobile());
        adminUser.setUserAccount(nowUser.getUserAccount());
        adminUser.setAccountStatus(UserStatus.OK.getCode());
        adminUser.setIsCpublic("0");
        adminUser.setTypeProperty("1");
        adminUser.setSecurityLevel(Integer.valueOf(3));
        adminUser.setMaxSessions(Integer.valueOf(-1));
        adminUser.setCorporationId(Long.valueOf(12L));
        adminUser.setDepartmentId(Long.valueOf(12L));
        adminUser.setIsSys("1");
        adminUser.setLoginIpLimit("0");
        adminUser.setLoginTimeLimit("0");
        String adminEncodeSecure = TenantUtil.getEncodeSecure((String)"123456");
        adminUser.setPassword(adminEncodeSecure);
        tenantUsers.add(adminUser);
        this.usersService.saveOrUpdateBatch(connName, tenantUsers);
        ArrayList<SysUserRole> tenantUserRoles = new ArrayList<SysUserRole>();
        SysUserRole sysUserRole1 = new SysUserRole();
        sysUserRole1.setUserId(nowUserId);
        sysUserRole1.setGrantedRole(TenantConstant.ADMIN_ROLE);
        sysUserRole1.setAdminOption(UserRoleStatus.OK.getCode());
        tenantUserRoles.add(sysUserRole1);
        SysUserRole sysUserRole2 = new SysUserRole();
        sysUserRole2.setUserId(nowUserId);
        sysUserRole2.setGrantedRole(SysUserAndRole.DEVELOP_ROLE.getValue());
        sysUserRole2.setAdminOption(UserRoleStatus.OK.getCode());
        tenantUserRoles.add(sysUserRole2);
        this.sysUserRoleService.saveBatch(connName, tenantUserRoles);
    }

    protected List<TenantDbModel> checkAndGetTenantDbModelList(SolitaryOnSystemTenant solitaryOnSystemTenant) {
        boolean notMaster;
        String tenantCode = solitaryOnSystemTenant.getTenantCode();
        String locale = LocaleContextHolder.getLocale().toLanguageTag();
        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("1:" + TranslateUtil.getTranslateName((String)"LOG_ADD_TENANT", (String)"\u68c0\u67e5\u9879\u76ee\u914d\u7f6e\u4fe1\u606f")));
        String connName = solitaryOnSystemTenant.getConnName();
        boolean bl = notMaster = HussarUtils.isNotBlank((CharSequence)connName) && !connName.equalsIgnoreCase("master");
        if (!notMaster) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("0:" + TranslateUtil.getTranslateName((String)"ILLEGAL_DATE_SOURCE_NAME", (String)"\u975e\u6cd5\u6570\u636e\u6e90\u540d\u79f0")));
            throw new BaseException(TranslateUtil.getTranslateName((String)"ILLEGAL_DATE_SOURCE_NAME", (String)"\u975e\u6cd5\u6570\u636e\u6e90\u540d\u79f0"));
        }
        if (connName.contains("-") || connName.contains("_")) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("0:" + TranslateUtil.getTranslateName((String)"DATE_SOURCE_EXCEPT", (String)"\u6570\u636e\u6e90\u540d\u79f0\u4e0d\u80fd\u5305\u542b-\u6216\u8005_")));
            throw new BaseException(TranslateUtil.getTranslateName((String)"DATE_SOURCE_EXCEPT", (String)"\u6570\u636e\u6e90\u540d\u79f0\u4e0d\u80fd\u5305\u542b-\u6216\u8005_"));
        }
        Set allDatasourcesName = this.dynamicDatasourceService.getAllDatasourcesName();
        boolean contains = false;
        if (HussarUtils.isNotEmpty((Object)allDatasourcesName)) {
            for (String dsName : allDatasourcesName) {
                if (!dsName.equalsIgnoreCase(connName)) continue;
                contains = true;
                break;
            }
        }
        if (contains) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("0:" + TranslateUtil.getTranslateName((String)"DATE_NAME_REPEAT", (String)"\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d")));
            throw new BaseException(TranslateUtil.getTranslateName((String)"DATE_NAME_REPEAT", (String)"\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d"));
        }
        Optional<SysTenantDatasource> anyDs = this.sysTenantDataSourceService.list().stream().filter(item -> item.getConnName().equalsIgnoreCase(connName)).findAny();
        if (anyDs.isPresent()) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("0:" + TranslateUtil.getTranslateName((String)"DATE_NAME_REPEAT", (String)"\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d")));
            throw new BaseException(TranslateUtil.getTranslateName((String)"DATE_NAME_REPEAT", (String)"\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d"));
        }
        List storagePropertiesList = solitaryOnSystemTenant.getStoragePropertiesList();
        if (HussarUtils.isEmpty((Object)storagePropertiesList)) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("0:" + TranslateUtil.getTranslateName((String)"PROJECT_DATE_EMPTY", (String)"\u9879\u76ee\u6570\u636e\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a")));
            throw new BaseException(TranslateUtil.getTranslateName((String)"PROJECT_DATE_EMPTY", (String)"\u9879\u76ee\u6570\u636e\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a"));
        }
        List tenantDbModelList = this.sysTenantDataSourceService.ofTenant((HussarTenantDefinition)solitaryOnSystemTenant);
        try {
            for (TenantDbModel dto : tenantDbModelList) {
                this.checkDb(dto);
            }
        }
        catch (BaseException e) {
            String errorContent = e.getMessage().replace("\u79df\u6237", "\u9879\u76ee");
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode), (Object)("0:" + errorContent));
            throw new BaseException(errorContent);
        }
        return tenantDbModelList;
    }

    public void checkData(SolitaryOnSystemTenant solitaryOnSystemTenant) {
        String locale = LocaleContextHolder.getLocale().toLanguageTag();
        String tenantCode = solitaryOnSystemTenant.getTenantCode();
        long tenantId = solitaryOnSystemTenant.getTenantId();
        String validateMsg = this.validateService.validate((Object)solitaryOnSystemTenant);
        if (StringUtils.isNotBlank((CharSequence)validateMsg)) {
            throw new BaseException(validateMsg);
        }
        Optional<SysTenant> anyTenantCode = this.tenantService.list().stream().filter(item -> item.getTenantCode().equalsIgnoreCase(tenantCode)).findAny();
        if (anyTenantCode.isPresent()) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("0:" + TranslateUtil.getTranslateName((String)"ADD_FALL_CODE", (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u9879\u76ee\u7f16\u7801\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09")));
            throw new BaseException(TranslateUtil.getTranslateName((String)"ADD_FALL_CODE", (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u9879\u76ee\u7f16\u7801\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09"));
        }
        String gitUrl = solitaryOnSystemTenant.getGitUrl();
        String gitToken = solitaryOnSystemTenant.getGitToken();
        String gitGroup = UrlUtils.getLastPartOfUrl((String)gitUrl);
        String gitUri = gitUrl.replace("/" + gitGroup, "");
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(gitUri + "/api/v4/groups/" + gitGroup);
            httpGet.setHeader("private-token", gitToken);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"GIT_CONF_ERR", (String)"git\u914d\u7f6e\u6709\u8bef"));
            }
        }
        catch (Exception e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"GIT_CONF_ERR", (String)"git\u914d\u7f6e\u6709\u8bef"));
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException ex) {
                    throw new HussarException((Throwable)ex);
                }
            }
        }
        String connName = solitaryOnSystemTenant.getConnName();
        this.tenantRecordService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        SysTenantRecord sysTenantRecord = new SysTenantRecord();
        sysTenantRecord.setTenantId(Long.valueOf(tenantId));
        sysTenantRecord.setConnName(solitaryOnSystemTenant.getConnName());
        sysTenantRecord.setTenantCode(tenantCode);
        sysTenantRecord.setConnName(connName);
        sysTenantRecord.setTenantClass(SolitaryOnSystemTenant.class.getName());
        sysTenantRecord.setTenantParams(JSON.toJSONString((Object)solitaryOnSystemTenant));
        this.tenantRecordService.save((Object)sysTenantRecord);
    }

    protected void createDbInSingleEnvironment(SolitaryOnSystemTenant solitaryOnSystemTenant, List<TenantDbModel> tenantDbModelList, HussarTenantDefinition definition, List<Map<String, Object>> storagePropertiesList, String currentServiceName) {
        this.createDbOfSingle((HussarTenantDefinition)solitaryOnSystemTenant, tenantDbModelList, definition, storagePropertiesList, currentServiceName);
    }

    protected void createDbInMicroServiceEnvironment(SolitaryOnSystemTenant solitaryOnSystemTenant, List<TenantDbModel> tenantDbModelList, HussarTenantDefinition definition, List<Map<String, Object>> storagePropertiesList, String currentServiceName, Map<String, TenantDbModel> tenantDbModelMap) {
        LOGGER.info("\u5f00\u59cb\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8");
        String locale = LocaleContextHolder.getLocale().toLanguageTag();
        String tenantCode = solitaryOnSystemTenant.getTenantCode();
        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("2:" + TranslateUtil.getTranslateName((String)"INIT_DATE_BASE_WAIT", (String)"\u521d\u59cb\u5316\u9879\u76ee\u6570\u636e\u5e93\uff08\u6570\u636e\u5e93\u521d\u59cb\u5316\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u51e0\u5206\u949f\uff09")));
        ArrayList storagePropertiesListOther = new ArrayList();
        Map masterstorageProperties = new HashMap();
        masterstorageProperties = this.splitStoragePropertiesMap(storagePropertiesList, currentServiceName, storagePropertiesListOther, masterstorageProperties);
        TenantDbModel tenantDbModelMaster = tenantDbModelMap.get(currentServiceName);
        SysTenantLog createDb = this.getSysTenantCreateDbLog((HussarTenantDefinition)solitaryOnSystemTenant, currentServiceName, masterstorageProperties, tenantDbModelMaster);
        try {
            String storageType = (String)masterstorageProperties.get("storageType");
            if (HussarUtils.isBlank((CharSequence)storageType)) {
                storageType = "rdb";
            }
            StorageFactory.get((String)storageType).createDatabaseAndInitData(masterstorageProperties, tenantDbModelMaster);
            SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode), false);
            if (HussarUtils.isNotEmpty((Object)recordTemp)) {
                recordTemp.setTenantParams(JSON.toJSONString((Object)solitaryOnSystemTenant));
                this.tenantRecordService.updateById((Object)recordTemp);
            }
            createDb.setExecStatus(Integer.valueOf(1));
            TenantCacheUtil.putTenantDataSourceCache((String)tenantCode, masterstorageProperties);
            this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            createDb.setExecStatus(Integer.valueOf(0));
            createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
            createDb.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("0:" + TranslateUtil.getTranslateName((String)"CREATE_MIC_SERVER_ERR", (String)"\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01")));
            throw new BaseException(TranslateUtil.getTranslateName((String)"CREATE_MIC_SERVER_ERR", (String)"\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01"), (Throwable)e);
        }
        if (HussarUtils.isEmpty(storagePropertiesListOther)) {
            return;
        }
        IOutSideCreateStorageService outSideCreateStorageService = (IOutSideCreateStorageService)SpringContextHolder.getBean(IOutSideCreateStorageService.class);
        if (HussarUtils.isEmpty((Object)outSideCreateStorageService)) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)("0:" + TranslateUtil.getTranslateName((String)"OUTSIDE_SERVICE_NULL_CHECK", (String)"\u83b7\u53d6IOutSideCreateStorageService\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f15\u5165hussar-tenant-outside\u5305\uff01")));
            throw new BaseException(TranslateUtil.getTranslateName((String)"OUTSIDE_SERVICE_NULL_CHECK", (String)"\u83b7\u53d6IOutSideCreateStorageService\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f15\u5165hussar-tenant-outside\u5305\uff01"));
        }
        int startNo = 11;
        this.saveMicroServiceTenantLog((HussarTenantDefinition)solitaryOnSystemTenant, tenantDbModelMap, storagePropertiesListOther, startNo);
        for (Map outSideStorageProperties : storagePropertiesListOther) {
            Boolean flag;
            String serviceName = (String)outSideStorageProperties.get("serviceName");
            try {
                IHussarTenantConfigService hussarTenantConfigService = (IHussarTenantConfigService)SpringContextHolder.getBean(IHussarTenantConfigService.class);
                flag = hussarTenantConfigService.checkTenant((String)outSideStorageProperties.get("serviceName"));
            }
            catch (Exception e) {
                LOGGER.error("\u6821\u9a8c\u5fae\u670d\u52a1{}\u662f\u5426\u5f00\u542f\u591a\u79df\u6237\u5931\u8d25", (Object)serviceName);
                SysTenantLog updateLog = (SysTenantLog)this.sysTenantLogService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getServiceName, (Object)serviceName));
                if (HussarUtils.isEmpty((Object)updateLog)) {
                    HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)String.format("0:" + TranslateUtil.getTranslateName((String)"MIC_SERVER_INFO_NULL", (String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u7801\u4e3a%s,\u5fae\u670d\u52a1\u540d\u79f0\u4e3a%s\u7684\u65e5\u5fd7\u4fe1\u606f\uff01"), tenantCode, serviceName));
                    throw new BaseException(String.format(TranslateUtil.getTranslateName((String)"MIC_SERVER_INFO_NULL", (String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u7801\u4e3a%s,\u5fae\u670d\u52a1\u540d\u79f0\u4e3a%s\u7684\u65e5\u5fd7\u4fe1\u606f\uff01"), tenantCode, serviceName));
                }
                updateLog.setExecStatus(Integer.valueOf(0));
                updateLog.setExecError(TranslateUtil.getTranslateName((String)"CHECK_OPEN_TENANT_ERR", (String)"\u6821\u9a8c\u662f\u5426\u5f00\u542f\u591a\u79df\u6237\u5931\u8d25"));
                updateLog.setErrorTimes(Integer.valueOf(updateLog.getErrorTimes() + 1));
                LOGGER.info("\u79df\u6237\u7f16\u7801={}\u5fae\u670d\u52a1\u540d\u79f0={}\u6267\u884c\u56de\u8c03\u66f4\u65b0\u65e5\u5fd7\u5b8c\u6bd5", (Object)tenantCode, (Object)serviceName);
                this.asyncUpdateTenantLogService.tenantlogUpdate(updateLog);
                continue;
            }
            if (flag.booleanValue()) {
                Optional<TenantDbModel> optionalTenantDbModel = tenantDbModelList.stream().filter(i -> i.isMicroservice() && i.getServiceName().equalsIgnoreCase(serviceName)).findFirst();
                if (!optionalTenantDbModel.isPresent()) continue;
                TenantDbModel tenantDbModel = optionalTenantDbModel.get();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("storageProperties", outSideStorageProperties);
                params.put("tenantDbModel", JSON.toJSONString((Object)tenantDbModel));
                outSideCreateStorageService.dealCreateStorage(params, serviceName);
                continue;
            }
            LOGGER.error("\u5fae\u670d\u52a1{}\u672a\u5f00\u542f\u591a\u79df\u6237\u6216\u672a\u5f15\u5165\u591a\u79df\u6237\u4f9d\u8d56", (Object)serviceName);
            SysTenantLog updateLog = (SysTenantLog)this.sysTenantLogService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getServiceName, (Object)serviceName));
            if (HussarUtils.isEmpty((Object)updateLog)) {
                HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode + ":" + locale), (Object)String.format("0:" + TranslateUtil.getTranslateName((String)"MIC_SERVER_INFO_NULL", (String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u7801\u4e3a%s,\u5fae\u670d\u52a1\u540d\u79f0\u4e3a%s\u7684\u65e5\u5fd7\u4fe1\u606f\uff01"), tenantCode, serviceName));
                throw new BaseException(String.format(TranslateUtil.getTranslateName((String)"MIC_SERVER_INFO_NULL", (String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u7801\u4e3a%s,\u5fae\u670d\u52a1\u540d\u79f0\u4e3a%s\u7684\u65e5\u5fd7\u4fe1\u606f\uff01"), tenantCode, serviceName));
            }
            updateLog.setExecStatus(Integer.valueOf(0));
            updateLog.setExecError(TranslateUtil.getTranslateName((String)"TENANT_CONF_CLOSE", (String)"\u672a\u5f00\u542f\u591a\u79df\u6237\u6216\u672a\u5f15\u5165\u591a\u79df\u6237\u4f9d\u8d56"));
            updateLog.setErrorTimes(Integer.valueOf(updateLog.getErrorTimes() + 1));
            LOGGER.info("\u79df\u6237\u7f16\u7801={}\u5fae\u670d\u52a1\u540d\u79f0={}\u6267\u884c\u56de\u8c03\u66f4\u65b0\u65e5\u5fd7\u5b8c\u6bd5", (Object)tenantCode, (Object)serviceName);
            this.asyncUpdateTenantLogService.tenantlogUpdate(updateLog);
        }
    }

    public void beforeAddTenant(SolitaryOnSystemTenant solitaryOnSystemTenant) {
        if (HussarUtils.isEmpty((Object)solitaryOnSystemTenant.getGitUrl())) {
            String gitUri = this.gitlabProperties.getGitUri();
            solitaryOnSystemTenant.setGitUrl(gitUri);
        }
        if (HussarUtils.isEmpty((Object)solitaryOnSystemTenant.getGitToken())) {
            String gitToken = this.gitlabProperties.getAccessToken();
            solitaryOnSystemTenant.setGitToken(gitToken);
        }
    }

    protected List<MiddleStep> defineDynamicStep(SolitaryOnSystemTenant solitaryOnSystemTenant) {
        String defaultBeanName = "com.jxdinfo.hussar.tenant.onsystem.service.impl.hussarBaseSolitaryOnSystemTenantServiceImpl";
        ArrayList<MiddleStep> result = new ArrayList<MiddleStep>();
        MiddleStep step1 = new MiddleStep();
        step1.setStepNo(Integer.valueOf(82));
        step1.setBeanName(defaultBeanName);
        step1.setMethodName("initTenantPermissionData");
        step1.setMethodDesc(TranslateUtil.getTranslateName((String)"TENANT_ADD_PERMISSION", (String)"\u79df\u6237\u5e93\u63d2\u5165\u6743\u9650\u6570\u636e"));
        Class[] initTenantPermissionDataParamClass = new Class[]{String.class};
        step1.setParamClass(initTenantPermissionDataParamClass);
        result.add(step1);
        MiddleStep step2 = new MiddleStep();
        step2.setStepNo(Integer.valueOf(83));
        step2.setBeanName(defaultBeanName);
        step2.setMethodName("initTenantAdmin");
        step2.setMethodDesc(TranslateUtil.getTranslateName((String)"TENANT_INIT_ADMIN", (String)"\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458"));
        Class[] initTenantAdminParamClass = new Class[]{String.class, SolitaryOnSystemTenant.class};
        step2.setParamClass(initTenantAdminParamClass);
        result.add(step2);
        MiddleStep step3 = new MiddleStep();
        step3.setStepNo(Integer.valueOf(84));
        step3.setMethodTag("initTenantAdminRole");
        step3.setBeanName(defaultBeanName);
        step3.setMethodName("initTenantAdminRole");
        step3.setMethodDesc(TranslateUtil.getTranslateName((String)"TENANT_INIT_ADMIN_ACTOR", (String)"\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u89d2\u8272"));
        Class[] initTenantAdminRoleParamClass = new Class[]{String.class, Long.class};
        step3.setParamClass(initTenantAdminRoleParamClass);
        result.add(step3);
        MiddleStep step4 = new MiddleStep();
        step4.setStepNo(Integer.valueOf(86));
        step4.setBeanName(defaultBeanName);
        step4.setMethodName("initClientInfo");
        step4.setMethodDesc(TranslateUtil.getTranslateName((String)"TENANT_INIT_CLIENT_AUTH", (String)"\u521d\u59cb\u5316\u79df\u6237\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f"));
        Class[] initClientInfoParamClass = new Class[]{String.class, SolitaryOnSystemTenant.class};
        step4.setParamClass(initClientInfoParamClass);
        result.add(step4);
        return result;
    }

    protected void executeStepFail(MiddleStep step, SolitaryOnSystemTenant solitaryOnSystemTenant, List<TenantDbModel> tenantDbModelList) {
        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + solitaryOnSystemTenant.getTenantCode()), (Object)("0:" + step.getMethodDesc()));
    }

    protected void executeStepSuccess(int stepNo, SolitaryOnSystemTenant solitaryOnSystemTenant, List<TenantDbModel> tenantDbModelList) {
    }

    protected boolean canExecute(int stepNo, SolitaryOnSystemTenant solitaryOnSystemTenant, List<TenantDbModel> tenantDbModelList) {
        return true;
    }

    protected Object[] getParamValues(int stepNo, SolitaryOnSystemTenant solitaryOnSystemTenant, List<TenantDbModel> tenantDbModelList) {
        String connName = solitaryOnSystemTenant.getConnName();
        if (82 == stepNo) {
            Object[] arr = new Object[]{connName};
            return arr;
        }
        if (83 == stepNo || 86 == stepNo) {
            Object[] arr = new Object[]{connName, solitaryOnSystemTenant};
            return arr;
        }
        if (84 == stepNo) {
            Long userId = solitaryOnSystemTenant.getTenantAdminId();
            Object[] arr = new Object[]{connName, userId};
            return arr;
        }
        return new Object[0];
    }

    public void afterAddTenant(SolitaryOnSystemTenant solitaryOnSystemTenant) {
        String tenantCodePlaceHolder = "{tenantCode}";
        if (!this.templateFileProperties.getMonolithicArchitecture().booleanValue()) {
            return;
        }
        GitDto gitDto = new GitDto();
        String templateFilePath = this.templateFileProperties.getTemplateFilePath();
        String tenantPath = this.templateFileProperties.getTenantPath();
        String templateBack = this.templateFileProperties.getTemplateBack();
        String templateFront = this.templateFileProperties.getTemplateFront();
        String templateMobile = this.templateFileProperties.getTemplateMobile();
        String templateDirBack = templateFilePath + templateBack;
        String templateDirFront = templateFilePath + templateFront;
        String templateDirMobile = templateFilePath + templateMobile;
        Path templatePathBack = Paths.get(templateDirBack, new String[0]);
        Path templatePathFront = Paths.get(templateDirFront, new String[0]);
        Path templatePathMobile = Paths.get(templateDirMobile, new String[0]);
        String targetDirBack = tenantPath + templateBack;
        String targetDirFront = tenantPath + templateFront;
        String targetDirMobile = tenantPath + templateMobile;
        String tenantCode = solitaryOnSystemTenant.getTenantCode();
        targetDirBack = targetDirBack.replace(tenantCodePlaceHolder, tenantCode);
        targetDirFront = targetDirFront.replace(tenantCodePlaceHolder, tenantCode);
        targetDirMobile = targetDirMobile.replace(tenantCodePlaceHolder, tenantCode);
        Path targetPathBack = Paths.get(targetDirBack, new String[0]);
        Path targetPathFront = Paths.get(targetDirFront, new String[0]);
        Path targetPathMobile = Paths.get(targetDirMobile, new String[0]);
        try {
            Files.createDirectories(targetPathBack.getParent(), new FileAttribute[0]);
            this.copyDirectory(templatePathBack, targetPathBack);
            this.copyDirectory(templatePathFront, targetPathFront);
            this.copyDirectory(templatePathMobile, targetPathMobile);
            String backStartModule = this.templateFileProperties.getBackStartModule();
            String targetDirBackPom1 = targetDirBack + File.separator + "pom.xml";
            String targetDirBackPom2 = targetDirBack + backStartModule + File.separator + "pom.xml";
            this.replaceTenantCodeInFiles(targetDirBackPom1, "${tenantCode}", tenantCode);
            this.replaceTenantCodeInFiles(targetDirBackPom2, "${tenantCode}", tenantCode);
            String targetDirMobilePackage = targetDirMobile + File.separator + "package.json";
            this.replaceTenantCodeInFiles(targetDirMobilePackage, tenantCodePlaceHolder, tenantCode);
            LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
            lambdaQueryWrapper.eq(SysTenantDatasource::getConnName, (Object)solitaryOnSystemTenant.getConnName());
            SysTenantDatasource tenantDatasource = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)lambdaQueryWrapper);
            String bootstrapPath = targetDirBack + backStartModule + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "bootstrap.yml";
            this.updateDatabaseConnection(tenantDatasource, bootstrapPath);
            gitDto.setCommitMsg(TranslateUtil.getTranslateName((String)"GIT_COMMIT_MSG", (String)"\u65b0\u5efa\u9879\u76ee\uff0c\u521b\u5efa\u76ee\u5f55"));
            gitDto.setPath(tenantPath.replace(tenantCodePlaceHolder, tenantCode));
            gitDto.setTenantCode(tenantCode);
            gitDto.setGitUri(solitaryOnSystemTenant.getGitUrl());
            gitDto.setAccessToken(solitaryOnSystemTenant.getGitToken());
            GitlabUtil.createProject((GitDto)gitDto);
        }
        catch (IOException e) {
            LOGGER.info("\u9879\u76ee\u63a8\u9001Git\u51fa\u9519:{}", (Object)e.getMessage());
            throw new HussarException(e.getMessage());
        }
        try {
            SysDataSourceDto dataSource = this.datasourceService.getDataSourceByConnName(solitaryOnSystemTenant.getConnName());
            String dbType = DbUtil.getDbType((String)dataSource.getJdbcUrl());
            String path = this.getIncrementSqlPath(dbType);
            Object[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/increment/onsystem/" + path + "/*.sql");
            if (HussarUtils.isNotEmpty((Object[])resources)) {
                this.hussarBaseSqlExecutor.execTenantSqlFile(solitaryOnSystemTenant.getConnName(), dbType, (org.springframework.core.io.Resource[])resources);
            }
        }
        catch (IOException | SQLException e) {
            throw new HussarException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @NotNull
    private String getIncrementSqlPath(String dbType) {
        String path = "mysql";
        if (DbType.DM.getDb().equals(dbType)) {
            path = "dm";
        } else if ("gauss".equals(dbType)) {
            path = dbType;
        } else if (DbType.HIGH_GO.getDb().equals(dbType)) {
            path = "highgo";
        } else if (DbType.KINGBASE_ES.getDb().equals(dbType)) {
            path = "kingbase";
        } else if (DbType.ORACLE.getDb().equals(dbType)) {
            path = "oracle";
        } else if (DbType.OSCAR.getDb().equals(dbType)) {
            path = "oscar";
        } else if (DbType.POSTGRE_SQL.getDb().equals(dbType)) {
            path = "postgre";
        } else if (DbType.SQL_SERVER.getDb().equals(dbType)) {
            path = "sqlserver";
        }
        return path;
    }

    private void afterDelTenant(SysTenant tenant) {
        if (HussarUtils.isNotEmpty((Object)tenant.getGitToken()) && HussarUtils.isNotEmpty((Object)tenant.getGitUrl())) {
            GitDto gitDto = new GitDto();
            gitDto.setTenantCode(tenant.getTenantCode());
            gitDto.setGitUri(tenant.getGitUrl());
            gitDto.setAccessToken(tenant.getGitToken());
            GitlabUtil.delProject((GitDto)gitDto);
        }
        try {
            FileUtils.deleteDirectory((File)new File(this.templateFileProperties.getTemplateFilePath() + File.separator + tenant.getTenantCode()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void copyDirectory(Path source, Path target) throws IOException {
        if (!Files.exists(source, new LinkOption[0])) {
            throw new IOException(TranslateUtil.getTranslateName((String)"SOURCE_DIR_NOT_EXIST", (String)"\u6e90\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a") + source);
        }
        if (Files.exists(target, new LinkOption[0])) {
            throw new IOException(TranslateUtil.getTranslateName((String)"TARGET_DIR_NOT_EXIST", (String)"\u76ee\u6807\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a") + target);
        }
        Files.createDirectories(target, new FileAttribute[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(source);){
            for (Path filePath : stream) {
                Path sourceFilePath = source.resolve(filePath.getFileName());
                Path targetFilePath = target.resolve(filePath.getFileName());
                if (Files.isDirectory(sourceFilePath, new LinkOption[0])) {
                    this.copyDirectory(sourceFilePath, targetFilePath);
                    continue;
                }
                Files.copy(sourceFilePath, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        try {
            var4_5 = null;
            try (Stream<Path> pathStream = Files.walk(target, new FileVisitOption[0]);){
                pathStream.forEach(path -> {
                    if (path.getFileName().toString().equals("${appCode}")) {
                        try {
                            this.deleteDirectoryRecursively((Path)path);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteDirectoryRecursively(Path directoryPath) throws IOException {
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directoryPath);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    this.deleteDirectoryRecursively(entry);
                    continue;
                }
                Files.delete(entry);
            }
        }
        Files.delete(directoryPath);
    }

    private void replaceTenantCodeInFiles(String directoryPath, final String placeholder, final String tenantCode) {
        Path directory = Paths.get(directoryPath, new String[0]);
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        String content = new String(Files.readAllBytes(file));
                        String newContent = content.replace(placeholder, tenantCode);
                        if (!content.equals(newContent)) {
                            Files.write(file, newContent.getBytes(), new OpenOption[0]);
                            System.out.println("Updated file: " + file);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateDatabaseConnection(final SysTenantDatasource tenantDatasource, String bootstrapPath) throws IOException {
        Path directory = Paths.get(bootstrapPath, new String[0]);
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        String content = new String(Files.readAllBytes(file));
                        String updatedContent = content.replace("${JDBC_URL}", tenantDatasource.getJdbcUrl()).replace("${SERVICE_USER}", tenantDatasource.getUserName()).replace("${SERVICE_PASSWORD}", tenantDatasource.getPassword()).replace("${DRIVER}", tenantDatasource.getDriverClass());
                        if (!content.equals(updatedContent)) {
                            Files.write(file, updatedContent.getBytes(), new OpenOption[0]);
                            System.out.println("Updated file: " + file);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void checkEditTenant(SolitaryOnSystemTenant solitaryOnSystemTenant) {
    }

    protected void updateSpecificData(SolitaryOnSystemTenant solitaryOnSystemTenant, Collection<String> serviceNames, List<TenantDbModel> tenantDbModelList) {
    }

    protected void deleteSpecificData(SysTenant tenant) {
        if (tenant == null) {
            return;
        }
        String connName = tenant.getConnName();
        try {
            String currentServiceName;
            List serviceList;
            LOGGER.info("\u5220\u9664\u79df\u6237\u6570\u636e\u6e90\u4fe1\u606f");
            LambdaQueryWrapper dswrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName)).eq(SysTenantDatasource::getDatasourceType, (Object)"1");
            SysTenantDatasource dsTemp = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)dswrapper);
            if (HussarUtils.isNotEmpty((Object)dsTemp)) {
                dsTemp.setDelFlag("1");
                this.sysTenantDataSourceService.updateById((Object)dsTemp);
            }
            this.dynamicDatasourceService.removeDynamicDatasource(connName);
            boolean microService = EnvironmentUtil.isMicroService();
            if (microService && HussarUtils.isNotEmpty((Object)(serviceList = this.sysTenantRegisterService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantRegister::getServiceName, (Object)(currentServiceName = EnvironmentUtil.getServiceName((boolean)microService))))))) {
                for (SysTenantRegister temp : serviceList) {
                    ((IOutSideDeleteDataSourceService)SpringContextHolder.getBean(IOutSideDeleteDataSourceService.class)).doDeleteDataSource(connName, temp.getServiceName());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79df\u6237\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        this.afterDelTenant(tenant);
    }

    public void saveTenant(SolitaryOnSystemTenant solitaryTenant) {
        SysTenant tenant = TenantUtil.convert2SysTenant((HussarTenantDefinition)solitaryTenant);
        this.sysTenantService.saveOrUpdate((Object)tenant);
    }
}

