/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffBaseService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.properties.HussarSystemIdProperties;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffBaseService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantAuthorizationUtils;
import com.jxdinfo.hussar.tenant.groupingmodel.dto.SyncAddStruParamsLogDto;
import com.jxdinfo.hussar.tenant.groupingmodel.dto.SyncUpdateUserParamsLogDto;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysSyncTenantLog;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantDatasourceGroup;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysSyncTenantLogService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantDatasourceGroupService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantStruService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.SyncTenantStruUserStaffService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.TenantOrganizationUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SyncTenantStruUserStaffServiceImpl
implements SyncTenantStruUserStaffService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncTenantStruUserStaffServiceImpl.class);
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysStruStaffBaseService sysStruStaffBaseService;
    @Autowired
    private ISysStaffBaseService sysStaffBaseService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantStruService sysTenantStruService;
    @Autowired
    private ISysTenantDatasourceGroupService tenantDatasourceService;
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private ICreateUserConfigService createUserConfigService;
    @Autowired
    private ISysSyncTenantLogService syncTenantLogService;
    @Autowired
    private TenantOrganizationUserService tenantOrganizationUserService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Lazy
    @Autowired
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysOfficeService sysOfficeService;
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Resource
    private HussarSystemIdProperties hussarSystemIdProperties;

    public void syncAddUser(List<SysUsers> sysUsers, List<SysStruUser> sysStruUsers, Long tenantIdParam) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                List sysTenantStrus = HussarUtils.isNotEmpty((Object)tenantIdParam) ? this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)tenantIdParam)) : this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantStru::getId, (Object)1L));
                if (HussarUtils.isNotEmpty((Object)sysTenantStrus)) {
                    HashMap userToStruUsersMap = new HashMap();
                    for (SysUsers sysUser : sysUsers) {
                        ArrayList<SysStruUser> currStruUser = new ArrayList<SysStruUser>();
                        Long userId = sysUser.getId();
                        for (SysStruUser sysStruUser : sysStruUsers) {
                            if (!HussarUtils.equals((Object)userId, (Object)sysStruUser.getUserId())) continue;
                            currStruUser.add(sysStruUser);
                        }
                        userToStruUsersMap.put(sysUser, currStruUser);
                    }
                    Map<Long, List<SysTenantStru>> sysTenantGroupByTenantIds = sysTenantStrus.stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId));
                    for (Map.Entry<Long, List<SysTenantStru>> tenantMap : sysTenantGroupByTenantIds.entrySet()) {
                        ArrayList<SysSyncTenantLog> sysSyncTenantLogList = new ArrayList<SysSyncTenantLog>();
                        for (Map.Entry entry : userToStruUsersMap.entrySet()) {
                            SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                            long tenantLogId = IdWorker.getId((Object)sysSyncTenantLog);
                            sysSyncTenantLog.setId(Long.valueOf(tenantLogId));
                            sysSyncTenantLog.setTenantId(tenantMap.getKey());
                            HashMap<String, Object> dataMap = new HashMap<String, Object>();
                            dataMap.put("sysUsers", entry.getKey());
                            dataMap.put("sysStruUsers", entry.getValue());
                            sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                            sysSyncTenantLog.setOperateType(1);
                            sysSyncTenantLog.setCurrDateId(((SysUsers)entry.getKey()).getId());
                            sysSyncTenantLog.setIsSuccess("0");
                            sysSyncTenantLogList.add(sysSyncTenantLog);
                        }
                        this.syncTenantLogService.saveBatch(sysSyncTenantLogList);
                        try {
                            Long dbId;
                            Long tenantId = tenantMap.getKey();
                            List list = tenantMap.getValue().stream().map(SysTenantStru::getStruId).collect(Collectors.toList());
                            boolean microService = EnvironmentUtil.isMicroService();
                            if (microService) {
                                String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                            } else {
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                            }
                            String connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName();
                            Set struIdChild = TenantAuthorizationUtils.getStruChild((List)this.sysStruService.list(), list);
                            List sysStruUsersAdd = sysStruUsers.parallelStream().filter(item -> struIdChild.contains(item.getStruId())).collect(Collectors.toList());
                            if (!HussarUtils.isNotEmpty(sysStruUsersAdd)) continue;
                            Set userIds = sysStruUsersAdd.parallelStream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                            List sysUsersAdd = sysUsers.parallelStream().filter(item -> userIds.contains(item.getId())).collect(Collectors.toList());
                            ArrayList<SysUserRole> sysUserRoles = new ArrayList<SysUserRole>();
                            for (SysUsers sysUsers1 : sysUsersAdd) {
                                SysUserRole sysUserRole = new SysUserRole();
                                sysUserRole.setUserId(sysUsers1.getId());
                                sysUserRole.setGrantedRole(Long.valueOf(1450785135866925064L));
                                sysUserRole.setAdminOption("1");
                                sysUserRoles.add(sysUserRole);
                            }
                            List staffIds = sysUsersAdd.parallelStream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                            List sysStaffsAdd = this.sysStaffBaseService.listByIds(staffIds);
                            List sysStruStaffAdd = this.sysStruStaffBaseService.list((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
                            this.tenantOrganizationUserService.addUserOrStaff(connName, sysUsersAdd, sysStruUsersAdd, sysUserRoles, sysStaffsAdd, sysStruStaffAdd);
                        }
                        catch (Exception e) {
                            sysSyncTenantLogList.forEach(item -> item.setIsSuccess("1"));
                            this.syncTenantLogService.updateBatchById(sysSyncTenantLogList);
                            LOGGER.error("\u540c\u6b65\u65b0\u589e\u7528\u6237\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void syncUpdateUser(List<SysUsers> sysUsersNew, List<SysUsers> sysUsersOld, List<SysStruUser> sysStruUsersNew, List<SysStruUser> sysStruUsersOld, Long tenantIdParam) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                Map<Long, List<SysTenantStru>> sysTenantGroupByTenantIds = HussarUtils.isNotEmpty((Object)tenantIdParam) ? this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)tenantIdParam)).stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId)) : this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantStru::getId, (Object)1L)).stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId));
                if (HussarUtils.isNotEmpty(sysTenantGroupByTenantIds)) {
                    ArrayList<SyncUpdateUserParamsLogDto> userParamsLogDtos = new ArrayList<SyncUpdateUserParamsLogDto>();
                    for (SysUsers sysUsers : sysUsersNew) {
                        SyncUpdateUserParamsLogDto userParamsLogDto = new SyncUpdateUserParamsLogDto();
                        Long usersId = sysUsers.getId();
                        SysUsers currSysUsersOld = sysUsersOld.parallelStream().filter(item -> HussarUtils.equals((Object)usersId, (Object)item.getId())).findFirst().orElse(new SysUsers());
                        List currSysStruUsersNew = sysStruUsersNew.parallelStream().filter(item -> HussarUtils.equals((Object)usersId, (Object)item.getUserId())).collect(Collectors.toList());
                        List currSysStruUsersOld = sysStruUsersOld.parallelStream().filter(item -> HussarUtils.equals((Object)usersId, (Object)item.getUserId())).collect(Collectors.toList());
                        userParamsLogDto.setCurrSysUsersNew(sysUsers);
                        userParamsLogDto.setCurrSysUsersOld(currSysUsersOld);
                        userParamsLogDto.setCurrSysStruUsersNew(currSysStruUsersNew);
                        userParamsLogDto.setCurrSysStruUsersOld(currSysStruUsersOld);
                        userParamsLogDtos.add(userParamsLogDto);
                    }
                    for (Map.Entry entry : sysTenantGroupByTenantIds.entrySet()) {
                        ArrayList<SysSyncTenantLog> sysSyncTenantLogList = new ArrayList<SysSyncTenantLog>();
                        for (SyncUpdateUserParamsLogDto userParamsLogDto : userParamsLogDtos) {
                            SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                            long tenantLogId = IdWorker.getId((Object)sysSyncTenantLog);
                            sysSyncTenantLog.setId(Long.valueOf(tenantLogId));
                            sysSyncTenantLog.setTenantId((Long)entry.getKey());
                            HashMap<String, Object> dataMap = new HashMap<String, Object>();
                            dataMap.put("sysUsersNew", userParamsLogDto.getCurrSysUsersNew());
                            dataMap.put("sysUsersOld", userParamsLogDto.getCurrSysUsersOld());
                            dataMap.put("sysStruUsersNew", userParamsLogDto.getCurrSysStruUsersNew());
                            dataMap.put("sysStruUsersOld", userParamsLogDto.getCurrSysStruUsersOld());
                            sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                            sysSyncTenantLog.setOperateType(2);
                            sysSyncTenantLog.setCurrDateId(userParamsLogDto.getCurrSysUsersNew().getId());
                            sysSyncTenantLog.setIsSuccess("0");
                            sysSyncTenantLogList.add(sysSyncTenantLog);
                        }
                        this.syncTenantLogService.saveBatch(sysSyncTenantLogList);
                        try {
                            Long dbId;
                            Long tenantId = (Long)entry.getKey();
                            List tenantStruIds = ((List)entry.getValue()).stream().map(SysTenantStru::getStruId).collect(Collectors.toList());
                            Set struIdChild = TenantAuthorizationUtils.getStruChild((List)this.sysStruService.list(), tenantStruIds);
                            boolean microService = EnvironmentUtil.isMicroService();
                            if (microService) {
                                String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                            } else {
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                            }
                            String connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName();
                            List sysStruUsersAdd = sysStruUsersNew.parallelStream().filter(item -> struIdChild.contains(item.getStruId())).collect(Collectors.toList());
                            List sysStruUsersDel = sysStruUsersOld.parallelStream().filter(item -> struIdChild.contains(item.getStruId())).collect(Collectors.toList());
                            if (HussarUtils.isNotEmpty(sysStruUsersDel)) {
                                Set userIdsDel = sysStruUsersDel.parallelStream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                                List struUsersIdsDel = sysStruUsersDel.parallelStream().map(SysStruUser::getId).collect(Collectors.toList());
                                List staffIdsDel = sysUsersOld.parallelStream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                                this.tenantOrganizationUserService.updateUserOrStaffDel(connName, userIdsDel, struUsersIdsDel, staffIdsDel);
                            }
                            if (!HussarUtils.isNotEmpty(sysStruUsersAdd)) continue;
                            Set userIdsAdd = sysStruUsersAdd.parallelStream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                            List sysUsersAdd = sysUsersNew.parallelStream().filter(item -> userIdsAdd.contains(item.getId())).collect(Collectors.toList());
                            ArrayList<SysUserRole> sysUserRoles = new ArrayList<SysUserRole>();
                            for (SysUsers sysUsers : sysUsersAdd) {
                                SysUserRole sysUserRole = new SysUserRole();
                                sysUserRole.setUserId(sysUsers.getId());
                                sysUserRole.setGrantedRole(Long.valueOf(1450785135866925064L));
                                sysUserRole.setAdminOption("1");
                                sysUserRoles.add(sysUserRole);
                            }
                            List staffIdsAdd = sysUsersAdd.parallelStream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                            List sysStaffsAdd = this.sysStaffBaseService.listByIds(staffIdsAdd);
                            List sysStruStaffAdd = this.sysStruStaffBaseService.list((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIdsAdd));
                            this.tenantOrganizationUserService.updateUserOrStaffAdd(connName, sysUsersAdd, sysStruUsersAdd, sysUserRoles, sysStaffsAdd, sysStruStaffAdd);
                        }
                        catch (Exception e) {
                            sysSyncTenantLogList.forEach(item -> item.setIsSuccess("1"));
                            this.syncTenantLogService.updateBatchById(sysSyncTenantLogList);
                            LOGGER.error("\u540c\u6b65\u4fee\u6539\u7528\u6237\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void syncDeleteUser(List<Long> userIds, Long tenantIdParam) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                List<Long> tenantIds = HussarUtils.isNotEmpty((Object)tenantIdParam) ? Collections.singletonList(tenantIdParam) : this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantStru::getId, (Object)1L)).stream().map(SysTenantStru::getTenantId).collect(Collectors.toList());
                for (Long tenantId : tenantIds) {
                    ArrayList<SysSyncTenantLog> sysSyncTenantLogList = new ArrayList<SysSyncTenantLog>();
                    for (Long currUserId : userIds) {
                        SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                        long tenantLogId = IdWorker.getId((Object)sysSyncTenantLog);
                        sysSyncTenantLog.setId(Long.valueOf(tenantLogId));
                        sysSyncTenantLog.setTenantId(tenantId);
                        HashMap<String, Long> dataMap = new HashMap<String, Long>();
                        dataMap.put("userIds", currUserId);
                        sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                        sysSyncTenantLog.setOperateType(3);
                        sysSyncTenantLog.setCurrDateId(currUserId);
                        sysSyncTenantLog.setIsSuccess("0");
                        sysSyncTenantLogList.add(sysSyncTenantLog);
                    }
                    this.syncTenantLogService.saveBatch(sysSyncTenantLogList);
                    try {
                        String connName;
                        List sysUsers;
                        Long dbId;
                        boolean microService = EnvironmentUtil.isMicroService();
                        if (microService) {
                            String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                            dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                        } else {
                            dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                        }
                        if (!HussarUtils.isNotEmpty((Object)(sysUsers = this.sysUsersService.listByIds(connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName(), (Collection)userIds)))) continue;
                        List staffIds = sysUsers.parallelStream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                        this.tenantOrganizationUserService.deleteOrStaffUser(connName, userIds, staffIds);
                    }
                    catch (Exception e) {
                        sysSyncTenantLogList.forEach(item -> item.setIsSuccess("1"));
                        this.syncTenantLogService.updateBatchById(sysSyncTenantLogList);
                        LOGGER.error("\u540c\u6b65\u5220\u9664\u7528\u6237\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                    }
                }
            });
        }
    }

    public void syncAddStru(List<SysStru> sysStrus, List<SysOrgan> sysOrgans, List<SysOffice> sysOffices, Long tenantIdParam) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                Map<Long, List<SysTenantStru>> sysTenantGroupByTenantIds = HussarUtils.isNotEmpty((Object)tenantIdParam) ? this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)tenantIdParam)).stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId)) : this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantStru::getId, (Object)1L)).stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId));
                if (HussarUtils.isNotEmpty(sysTenantGroupByTenantIds)) {
                    ArrayList<SyncAddStruParamsLogDto> struParamsLogDtos = new ArrayList<SyncAddStruParamsLogDto>();
                    for (SysStru sysStru : sysStrus) {
                        SyncAddStruParamsLogDto struParamsLogDto = new SyncAddStruParamsLogDto();
                        SysOrgan currSysOrgan = sysOrgans.parallelStream().filter(item -> HussarUtils.equals((Object)currSysStru.getOrganId(), (Object)item.getId())).findFirst().orElse(new SysOrgan());
                        SysOffice currSysOffice = sysOffices.parallelStream().filter(item -> HussarUtils.equals((Object)currSysStru.getId(), (Object)item.getStruId())).findFirst().orElse(new SysOffice());
                        struParamsLogDto.setSysStru(sysStru);
                        struParamsLogDto.setSysOrgan(currSysOrgan);
                        struParamsLogDto.setSysOffice(currSysOffice);
                        struParamsLogDtos.add(struParamsLogDto);
                    }
                    for (Map.Entry entry : sysTenantGroupByTenantIds.entrySet()) {
                        ArrayList<SysSyncTenantLog> sysSyncTenantLogList = new ArrayList<SysSyncTenantLog>();
                        for (SyncAddStruParamsLogDto struParamsLogDto : struParamsLogDtos) {
                            SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                            long tenantLogId = IdWorker.getId((Object)sysSyncTenantLog);
                            sysSyncTenantLog.setId(Long.valueOf(tenantLogId));
                            sysSyncTenantLog.setTenantId((Long)entry.getKey());
                            HashMap<String, Object> dataMap = new HashMap<String, Object>();
                            dataMap.put("sysStrus", struParamsLogDto.getSysStru());
                            dataMap.put("sysOrgans", struParamsLogDto.getSysOrgan());
                            dataMap.put("sysOffices", struParamsLogDto.getSysOffice());
                            sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                            sysSyncTenantLog.setOperateType(4);
                            sysSyncTenantLog.setCurrDateId(struParamsLogDto.getSysStru().getId());
                            sysSyncTenantLog.setIsSuccess("0");
                            sysSyncTenantLogList.add(sysSyncTenantLog);
                        }
                        this.syncTenantLogService.saveBatch(sysSyncTenantLogList);
                        try {
                            Long dbId;
                            Long tenantId = (Long)entry.getKey();
                            List tenantStruIds = ((List)entry.getValue()).stream().map(SysTenantStru::getStruId).collect(Collectors.toList());
                            Set struIdChild = TenantAuthorizationUtils.getStruChild((List)this.sysStruService.list(), tenantStruIds);
                            List sysStrusAdd = sysStrus.parallelStream().filter(item -> struIdChild.contains(item.getParentId())).collect(Collectors.toList());
                            if (!HussarUtils.isNotEmpty(sysStrusAdd)) continue;
                            List struIdsAdd = sysStrusAdd.parallelStream().map(SysStru::getId).collect(Collectors.toList());
                            List organIdsAdd = sysStrusAdd.parallelStream().map(SysStru::getOrganId).collect(Collectors.toList());
                            List sysOrgansAdd = sysOrgans.parallelStream().filter(item -> organIdsAdd.contains(item.getId())).collect(Collectors.toList());
                            List sysOfficesAdd = sysOffices.parallelStream().filter(item -> struIdsAdd.contains(item.getStruId())).collect(Collectors.toList());
                            boolean microService = EnvironmentUtil.isMicroService();
                            if (microService) {
                                String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                            } else {
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                            }
                            String connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName();
                            this.tenantOrganizationUserService.addStru(connName, sysStrusAdd, sysOrgansAdd, sysOfficesAdd);
                        }
                        catch (Exception e) {
                            sysSyncTenantLogList.forEach(item -> item.setIsSuccess("1"));
                            this.syncTenantLogService.updateBatchById(sysSyncTenantLogList);
                            LOGGER.error("\u540c\u6b65\u65b0\u589e\u7ec4\u7ec7\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void syncUpdateStru(List<SysStru> sysStrus, List<SysOrgan> sysOrgans, Long tenantIdParam) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                Set<Long> tenantIds = HussarUtils.isNotEmpty((Object)tenantIdParam) ? Collections.singleton(tenantIdParam) : this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantStru::getId, (Object)1L)).stream().map(SysTenantStru::getTenantId).collect(Collectors.toSet());
                HashMap<SysStru, SysOrgan> struToOrganMap = new HashMap<SysStru, SysOrgan>();
                for (SysStru currSysStru : sysStrus) {
                    Long organId = currSysStru.getOrganId();
                    SysOrgan currSysOrgan = sysOrgans.parallelStream().filter(item -> HussarUtils.equals((Object)organId, (Object)item.getId())).findFirst().orElse(new SysOrgan());
                    struToOrganMap.put(currSysStru, currSysOrgan);
                }
                for (Long tenantId : tenantIds) {
                    ArrayList<SysSyncTenantLog> sysSyncTenantLogList = new ArrayList<SysSyncTenantLog>();
                    for (Map.Entry struToOrgan : struToOrganMap.entrySet()) {
                        SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                        long tenantLogId = IdWorker.getId((Object)sysSyncTenantLog);
                        sysSyncTenantLog.setId(Long.valueOf(tenantLogId));
                        sysSyncTenantLog.setTenantId(tenantId);
                        HashMap<String, Object> dataMap = new HashMap<String, Object>();
                        dataMap.put("sysStrus", struToOrgan.getKey());
                        dataMap.put("sysOrgans", struToOrgan.getValue());
                        sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                        sysSyncTenantLog.setOperateType(5);
                        sysSyncTenantLog.setCurrDateId(((SysStru)struToOrgan.getKey()).getId());
                        sysSyncTenantLog.setIsSuccess("0");
                        sysSyncTenantLogList.add(sysSyncTenantLog);
                    }
                    this.syncTenantLogService.saveBatch(sysSyncTenantLogList);
                    try {
                        Long dbId;
                        boolean microService = EnvironmentUtil.isMicroService();
                        if (microService) {
                            String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                            dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                        } else {
                            dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                        }
                        String connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName();
                        for (SysStru sysStru : sysStrus) {
                            SysOrgan sysOrgan = sysOrgans.parallelStream().filter(sysOrganFor -> HussarUtils.equals((Object)sysOrganFor.getId(), (Object)sysStru.getOrganId())).findFirst().orElse(new SysOrgan());
                            this.tenantOrganizationUserService.updateStru(connName, sysStrus, sysStru, sysOrgan);
                        }
                    }
                    catch (Exception e) {
                        sysSyncTenantLogList.forEach(item -> item.setIsSuccess("1"));
                        this.syncTenantLogService.updateBatchById(sysSyncTenantLogList);
                        LOGGER.error("\u540c\u6b65\u4fee\u6539\u7ec4\u7ec7\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                    }
                }
            });
        }
    }

    public void syncDeleteStru(List<Long> struIds, List<Long> organIds, Long tenantIdParam) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                Set<Long> tenantIds = HussarUtils.isNotEmpty((Object)tenantIdParam) ? Collections.singleton(tenantIdParam) : this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantStru::getId, (Object)1L)).stream().map(SysTenantStru::getTenantId).collect(Collectors.toSet());
                for (Long tenantId : tenantIds) {
                    Long dbId;
                    boolean microService = EnvironmentUtil.isMicroService();
                    if (microService) {
                        String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                        dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                    } else {
                        dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                    }
                    String connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName();
                    ArrayList<SysSyncTenantLog> sysSyncTenantLogList = new ArrayList<SysSyncTenantLog>();
                    for (Long currStruId : struIds) {
                        SysStru currSysStru = (SysStru)this.sysStruService.getById(connName, (Serializable)currStruId);
                        if (!HussarUtils.isNotEmpty((Object)currSysStru)) continue;
                        Long currOrganId = currSysStru.getOrganId();
                        SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                        long tenantLogId = IdWorker.getId((Object)sysSyncTenantLog);
                        sysSyncTenantLog.setId(Long.valueOf(tenantLogId));
                        sysSyncTenantLog.setTenantId(tenantId);
                        HashMap<String, Long> dataMap = new HashMap<String, Long>();
                        dataMap.put("struIds", currStruId);
                        dataMap.put("organIds", currOrganId);
                        sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                        sysSyncTenantLog.setOperateType(6);
                        sysSyncTenantLog.setCurrDateId(currStruId);
                        sysSyncTenantLog.setIsSuccess("0");
                        sysSyncTenantLogList.add(sysSyncTenantLog);
                    }
                    this.syncTenantLogService.saveBatch(sysSyncTenantLogList);
                    try {
                        if (!HussarUtils.isNotEmpty(sysSyncTenantLogList)) continue;
                        this.tenantOrganizationUserService.deleteStru(connName, struIds, organIds);
                    }
                    catch (Exception e) {
                        sysSyncTenantLogList.forEach(item -> item.setIsSuccess("1"));
                        this.syncTenantLogService.updateBatchById(sysSyncTenantLogList);
                        LOGGER.error("\u540c\u6b65\u5220\u9664\u7ec4\u7ec7\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                    }
                }
            });
        }
    }

    public void syncAddStaff(List<SysStaff> sysStaffs, List<SysStruStaff> sysStruStaffs, List<SysUsers> sysUsers, List<SysStruUser> sysStruUsers, List<SysUserRole> sysUserRoles, Long tenantIdParam) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                Map<Long, List<SysTenantStru>> sysTenantGroupByTenantIds;
                if (this.createUserConfigService.isOperateStaffWithUser() && HussarUtils.isNotEmpty(sysTenantGroupByTenantIds = HussarUtils.isNotEmpty((Object)tenantIdParam) ? this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)tenantIdParam)).stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId)) : this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantStru::getId, (Object)1L)).stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId)))) {
                    for (Map.Entry<Long, List<SysTenantStru>> tenantMap : sysTenantGroupByTenantIds.entrySet()) {
                        try {
                            Long dbId;
                            Long tenantId = tenantMap.getKey();
                            List tenantStruIds = tenantMap.getValue().stream().map(SysTenantStru::getStruId).collect(Collectors.toList());
                            Set struIdChild = TenantAuthorizationUtils.getStruChild((List)this.sysStruService.list(), tenantStruIds);
                            List sysStruUsersAdd = sysStruUsers.parallelStream().filter(item -> struIdChild.contains(item.getStruId())).collect(Collectors.toList());
                            if (!HussarUtils.isNotEmpty(sysStruUsersAdd)) continue;
                            Set userIds = sysStruUsersAdd.parallelStream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                            List sysUsersAdd = sysUsers.parallelStream().filter(item -> userIds.contains(item.getId())).collect(Collectors.toList());
                            List staffIds = sysUsersAdd.parallelStream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                            List sysStaffsAdd = sysStaffs.parallelStream().filter(item -> staffIds.contains(item.getId())).collect(Collectors.toList());
                            List sysStruStaffAdd = sysStruStaffs.parallelStream().filter(item -> staffIds.contains(item.getStaffId())).collect(Collectors.toList());
                            boolean microService = EnvironmentUtil.isMicroService();
                            if (microService) {
                                String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                            } else {
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                            }
                            String connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName();
                            this.tenantOrganizationUserService.addUserOrStaff(connName, sysUsersAdd, sysStruUsersAdd, sysUserRoles, sysStaffsAdd, sysStruStaffAdd);
                        }
                        catch (Exception e) {
                            SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                            sysSyncTenantLog.setTenantId(tenantMap.getKey());
                            HashMap<String, List> dataMap = new HashMap<String, List>();
                            dataMap.put("sysStaffs", sysStaffs);
                            dataMap.put("sysStruStaffs", sysStruStaffs);
                            dataMap.put("sysUsers", sysUsers);
                            dataMap.put("sysStruUsers", sysStruUsers);
                            dataMap.put("sysUserRoles", sysUserRoles);
                            sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                            sysSyncTenantLog.setOperateType(7);
                            this.syncTenantLogService.save((Object)sysSyncTenantLog);
                            LOGGER.error("\u540c\u6b65\u65b0\u589e\u4eba\u5458\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void syncUpdateStaff(List<SysStaff> sysStaffs, List<SysStruStaff> sysStruStaffs, List<SysUsers> sysUsers, List<SysStruUser> sysStruUsersNew, List<SysStruUser> sysStruUsersOld, Long tenantIdParam) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                block14: {
                    Map<Long, List<SysTenantStru>> sysTenantGroupByTenantIds = HussarUtils.isNotEmpty((Object)tenantIdParam) ? this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantStru::getTenantId, (Object)tenantIdParam)).stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId)) : this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantStru::getId, (Object)1L)).stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId));
                    if (!HussarUtils.isNotEmpty(sysTenantGroupByTenantIds)) break block14;
                    if (this.createUserConfigService.isOperateStaffWithUser()) {
                        for (Map.Entry<Long, List<SysTenantStru>> tenantMap : sysTenantGroupByTenantIds.entrySet()) {
                            try {
                                Long dbId;
                                Long tenantId = tenantMap.getKey();
                                List tenantStruIds = tenantMap.getValue().stream().map(SysTenantStru::getStruId).collect(Collectors.toList());
                                Set struIdChild = TenantAuthorizationUtils.getStruChild((List)this.sysStruService.list(), tenantStruIds);
                                boolean microService = EnvironmentUtil.isMicroService();
                                if (microService) {
                                    String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                                    dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                                } else {
                                    dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                                }
                                String connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName();
                                List sysStruUsersAdd = sysStruUsersNew.parallelStream().filter(item -> struIdChild.contains(item.getStruId())).collect(Collectors.toList());
                                List sysStruUsersDel = sysStruUsersOld.parallelStream().filter(item -> struIdChild.contains(item.getStruId())).collect(Collectors.toList());
                                if (HussarUtils.isNotEmpty(sysStruUsersDel)) {
                                    Set userIdsDel = sysStruUsersDel.parallelStream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                                    List struUsersIdsDel = sysStruUsersDel.parallelStream().map(SysStruUser::getId).collect(Collectors.toList());
                                    List staffIdsDel = sysUsers.parallelStream().filter(item -> userIdsDel.contains(item.getId())).map(SysUsers::getEmployeeId).collect(Collectors.toList());
                                    this.tenantOrganizationUserService.updateUserOrStaffDel(connName, userIdsDel, struUsersIdsDel, staffIdsDel);
                                }
                                if (!HussarUtils.isNotEmpty(sysStruUsersAdd)) continue;
                                Set userIdsAdd = sysStruUsersAdd.parallelStream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                                List sysUsersAdd = sysUsers.parallelStream().filter(item -> userIdsAdd.contains(item.getId())).collect(Collectors.toList());
                                ArrayList<SysUserRole> sysUserRoles = new ArrayList<SysUserRole>();
                                for (SysUsers sysUsersFor : sysUsersAdd) {
                                    SysUserRole sysUserRole = new SysUserRole();
                                    sysUserRole.setUserId(sysUsersFor.getId());
                                    sysUserRole.setGrantedRole(Long.valueOf(1450785135866925064L));
                                    sysUserRole.setAdminOption("1");
                                    sysUserRoles.add(sysUserRole);
                                }
                                List staffIdsAdd = sysUsersAdd.parallelStream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                                List sysStaffsAdd = sysStaffs.parallelStream().filter(item -> staffIdsAdd.contains(item.getId())).collect(Collectors.toList());
                                List sysStruStaffAdd = sysStruStaffs.parallelStream().filter(item -> staffIdsAdd.contains(item.getStaffId())).collect(Collectors.toList());
                                this.tenantOrganizationUserService.updateUserOrStaffAdd(connName, sysUsersAdd, sysStruUsersAdd, sysUserRoles, sysStaffsAdd, sysStruStaffAdd);
                            }
                            catch (Exception e) {
                                SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                                sysSyncTenantLog.setTenantId(tenantMap.getKey());
                                HashMap<String, List> dataMap = new HashMap<String, List>();
                                dataMap.put("sysStaffs", sysStaffs);
                                dataMap.put("sysStruStaffs", sysStruStaffs);
                                dataMap.put("sysUsers", sysUsers);
                                dataMap.put("sysStruUsersNew", sysStruUsersNew);
                                dataMap.put("sysStruUsersOld", sysStruUsersOld);
                                sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                                sysSyncTenantLog.setOperateType(8);
                                this.syncTenantLogService.save((Object)sysSyncTenantLog);
                                LOGGER.error("\u540c\u6b65\u4fee\u6539\u4eba\u5458\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                            }
                        }
                    } else {
                        for (Map.Entry<Long, List<SysTenantStru>> tenantMap : sysTenantGroupByTenantIds.entrySet()) {
                            try {
                                Long dbId;
                                Long tenantId = tenantMap.getKey();
                                boolean microService = EnvironmentUtil.isMicroService();
                                if (microService) {
                                    String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                                    dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                                } else {
                                    dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                                }
                                String connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName();
                                this.tenantOrganizationUserService.updateStaff(connName, sysStaffs, sysStruStaffs);
                            }
                            catch (Exception e) {
                                SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                                sysSyncTenantLog.setTenantId(tenantMap.getKey());
                                HashMap<String, List> dataMap = new HashMap<String, List>();
                                dataMap.put("sysStaffs", sysStaffs);
                                dataMap.put("sysStruStaffs", sysStruStaffs);
                                dataMap.put("sysUsers", sysUsers);
                                dataMap.put("sysStruUsersNew", sysStruUsersNew);
                                dataMap.put("sysStruUsersOld", sysStruUsersOld);
                                sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                                sysSyncTenantLog.setOperateType(8);
                                this.syncTenantLogService.save((Object)sysSyncTenantLog);
                                LOGGER.error("\u540c\u6b65\u4fee\u6539\u4eba\u5458\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                            }
                        }
                    }
                }
            });
        }
    }

    public void syncDelStaff(List<Long> staffIds, List<Long> userIds, Long tenantIdParam) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseTenantExecutor != null) {
            hussarBaseTenantExecutor.execute(() -> {
                if (this.createUserConfigService.isOperateStaffWithUser()) {
                    List<Long> tenantIds = HussarUtils.isNotEmpty((Object)tenantIdParam) ? Collections.singletonList(tenantIdParam) : this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantStru::getId, (Object)1L)).stream().map(SysTenantStru::getTenantId).collect(Collectors.toList());
                    for (Long tenantId : tenantIds) {
                        try {
                            Long dbId;
                            boolean microService = EnvironmentUtil.isMicroService();
                            if (microService) {
                                String currentServiceName = EnvironmentUtil.getServiceName((boolean)microService);
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).eq(SysTenantDatasourceGroup::getServiceName, (Object)currentServiceName))).getDbId();
                            } else {
                                dbId = ((SysTenantDatasourceGroup)this.tenantDatasourceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasourceGroup::getTenantId, (Object)tenantId)).isNull(SysTenantDatasourceGroup::getServiceName)).ne(SysTenantDatasourceGroup::getTenantId, (Object)1L))).getDbId();
                            }
                            String connName = ((SysDataSource)this.datasourceService.getById((Serializable)dbId)).getConnName();
                            this.tenantOrganizationUserService.deleteOrStaffUser(connName, userIds, staffIds);
                        }
                        catch (Exception e) {
                            SysSyncTenantLog sysSyncTenantLog = new SysSyncTenantLog();
                            sysSyncTenantLog.setTenantId(tenantId);
                            HashMap<String, List> dataMap = new HashMap<String, List>();
                            dataMap.put("staffIds", staffIds);
                            dataMap.put("userIds", userIds);
                            sysSyncTenantLog.setContent(JSON.toJSONString(dataMap));
                            sysSyncTenantLog.setOperateType(9);
                            this.syncTenantLogService.save((Object)sysSyncTenantLog);
                            LOGGER.error("\u540c\u6b65\u5220\u9664\u4eba\u5458\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @HussarTransactional
    public boolean syncStruUserStaff(List<Long> tenantIds) {
        if (HussarUtils.isNotEmpty(tenantIds)) {
            try {
                Map<Long, List<Long>> tenantIdStruMap = this.sysTenantStruService.list((Wrapper)new LambdaQueryWrapper().in(SysTenantStru::getTenantId, tenantIds)).stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId, Collectors.mapping(SysTenantStru::getStruId, Collectors.toList())));
                this.handleSync(tenantIdStruMap);
            }
            catch (Exception e) {
                throw new BaseException("\u540c\u6b65\u5931\u8d25");
            }
        }
        try {
            Map<Long, List<Long>> tenantIdStruMap = this.sysTenantStruService.list().stream().collect(Collectors.groupingBy(SysTenantStru::getTenantId, Collectors.mapping(SysTenantStru::getStruId, Collectors.toList())));
            this.handleSync(tenantIdStruMap);
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u5931\u8d25");
        }
        return true;
    }

    private void handleSync(Map<Long, List<Long>> tenantIdStruMap) {
        List sysStrus = this.sysStruService.list();
        for (Map.Entry<Long, List<Long>> tenantIdStru : tenantIdStruMap.entrySet()) {
            Long tenantId = tenantIdStru.getKey();
            List<Long> struIds = tenantIdStru.getValue();
            String connName = ((SysTenant)this.sysTenantService.getById((Serializable)tenantId)).getConnName();
            this.tenantOrganizationUserService.removeSyncTenantStruAndUsers(connName);
            if (!HussarUtils.isNotEmpty(struIds)) continue;
            Set struIdChild = TenantAuthorizationUtils.getStruChild((List)sysStrus, struIds);
            List sysStruList = this.sysStruService.listByIds((Collection)struIdChild);
            TenantAuthorizationUtils.noParentSetParent((List)sysStruList, (Long)this.hussarSystemIdProperties.getInnerOrganNodeId());
            List organId = sysStruList.stream().map(SysStru::getOrganId).collect(Collectors.toList());
            List sysOrgans = this.sysOrganService.listByIds(organId);
            List sysOffices = this.sysOfficeService.list((Wrapper)new LambdaQueryWrapper().in(SysOffice::getStruId, (Collection)struIdChild));
            List sysStruUserList = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, (Collection)struIdChild));
            Set userIds = null;
            List sysUsers = null;
            List sysStaffs = null;
            List sysStruStaffList = null;
            if (HussarUtils.isNotEmpty((Object)sysStruUserList)) {
                userIds = sysStruUserList.stream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                sysUsers = this.usersService.listByIds(userIds);
                List sysStaffIds = sysUsers.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                sysStaffs = this.sysStaffService.listByIds(sysStaffIds);
                sysStruStaffList = this.sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, sysStaffIds));
            }
            this.tenantOrganizationUserService.syncTenantStruAndUsers(connName, sysStruList, sysOrgans, sysOffices, sysStruUserList, userIds, sysUsers, sysStaffs, sysStruStaffList);
        }
    }
}

