/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.groupingmodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authentication.enums.AccessType;
import com.jxdinfo.hussar.authentication.enums.AuthenticationEnum;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.config.manager.api.HussarConfigApi;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.groupingmodel.dao.SysTenantStruMapper;
import com.jxdinfo.hussar.tenant.groupingmodel.dto.DefaultTenantDto;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantMultUser;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantUser;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISwitchTenantService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantMultUserService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantStruService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantUserService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class SwitchTenantServiceImpl
implements ISwitchTenantService {
    private static Logger log = LoggerFactory.getLogger(SwitchTenantServiceImpl.class);
    private static final Long[] ADMINS = new Long[]{716665713812840448L, 1450757642371981314L, 716671816189616128L, 1450757642371981314L, 1450757481235202050L, 1450757642371981324L};
    private static final Long[] THREE_SENIOR_ADMINS = new Long[]{1450757481235202050L, 1450757642371981314L, 1450757642371981324L};
    private static final String SYSTEM_TENANT_CODE = "0";
    private static final String IS_ONLY_TENANT_ZERO = "1";
    private static final String IS_ONLY_TENANT_ZERO_KEY = "hussar.isOnlyTenantZero.enable";
    private static Long GRADE_SYSTEMADMIN_ROLE = 1450715195867925063L;
    private static Long GRADE_SECAUDITADMIN_ROLE = 145078193586892596L;
    private static Long GRADE_SECURITYADMIN_ROLE = 1450785935166925011L;
    private static Long SECAUDITADMIN_ROLE = 1450785135866925061L;
    private static Long SYSTEMADMIN_ROLE = 1450785135866925067L;
    private static Long SECURITYADMIN_ROLE = 1450785135866925068L;
    @Lazy
    @Resource
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantStruMapper tenantStruMapper;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private HussarDynamicProperties hussarDynamicProperties;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantMultUserService tenantMultUserService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private IHussarBaseUserIdentityService hussarBaseUserIdentityService;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Resource
    private HussarConfigApi hussarConfigApi;
    @Lazy
    @Autowired(required=false)
    private ISysTenantStruService sysTenantStruService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantUserService sysTenantUserService;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;

    public List<SysTenant> switchTenantList(Long userId) {
        String isOnlyTenantZero;
        boolean protectFlag;
        List resultList = this.sysTenantService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantStatus, (Object)IS_ONLY_TENANT_ZERO)).orderByAsc(SysTenant::getTenantSeq)).orderByDesc(HussarBaseEntity::getCreateTime));
        if (!ArrayUtils.contains((Object[])ADMINS, (Object)userId)) {
            SysTenantMultUser tenantMultUser = this.tenantMultUserService.getOne("master", (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysTenantMultUser::getUserId, (Object)userId));
            List tenantUerIds = resultList.stream().map(SysTenant::getTenantAdminId).collect(Collectors.toList());
            if (tenantMultUser != null) {
                SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)tenantMultUser.getTenantId());
                resultList.clear();
                resultList.add(sysTenant);
            } else if (tenantUerIds.contains(userId)) {
                SysTenant sysTenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantAdminId, (Object)userId));
                resultList.clear();
                resultList.add(sysTenant);
            } else {
                List struByStruIds;
                HashSet struCollection = Sets.newHashSet();
                List sysStruUserList = this.sysStruUserService.list("master", (Wrapper)Wrappers.lambdaQuery().eq(SysStruUser::getUserId, (Object)userId));
                if (CollectionUtils.isNotEmpty((Collection)sysStruUserList) && (struByStruIds = this.sysStruService.getStruByStruIds("master", sysStruUserList.stream().map(SysStruUser::getStruId).collect(Collectors.toList()))) != null) {
                    for (SysStru sysStru : struByStruIds) {
                        Set collect = Arrays.stream(sysStru.getStruFid().split("/")).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toSet());
                        struCollection.addAll(collect);
                    }
                }
                List tenantStrus = this.sysTenantStruService.list("master");
                List tenantIdList = tenantStrus.stream().filter(t -> struCollection.contains(t.getStruId())).map(SysTenantStru::getTenantId).collect(Collectors.toList());
                LambdaQueryWrapper sysTenantUserQuery = new LambdaQueryWrapper();
                sysTenantUserQuery.eq(SysTenantUser::getUserId, (Object)userId);
                List list = this.sysTenantUserService.list("master", sysTenantUserQuery);
                if (HussarUtils.isNotEmpty((Object)list)) {
                    List collect = list.stream().map(SysTenantUser::getTenantId).collect(Collectors.toList());
                    if (HussarUtils.isEmpty(tenantIdList)) {
                        tenantIdList.addAll(collect);
                    } else {
                        for (int i = 0; i < collect.size(); ++i) {
                            Long aLong = (Long)collect.get(i);
                            if (tenantIdList.contains(aLong)) continue;
                            tenantIdList.add(aLong);
                        }
                    }
                }
                resultList = resultList.stream().filter(r -> tenantIdList.contains(r.getId()) || SYSTEM_TENANT_CODE.equals(r.getTenantCode())).collect(Collectors.toList());
            }
        }
        if ((protectFlag = this.protectionStatusConfigBoService.isFenBaoEnable("master").booleanValue()) && ArrayUtils.contains((Object[])THREE_SENIOR_ADMINS, (Object)userId) && (HussarUtils.isEmpty((Object)(isOnlyTenantZero = String.valueOf(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(IS_ONLY_TENANT_ZERO_KEY)))) || IS_ONLY_TENANT_ZERO.equals(isOnlyTenantZero))) {
            resultList = resultList.stream().filter(r -> SYSTEM_TENANT_CODE.equals(r.getTenantCode())).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty((Object)resultList) && protectFlag && !ArrayUtils.contains((Object[])THREE_SENIOR_ADMINS, (Object)userId)) {
            if (resultList.size() == 1 && SYSTEM_TENANT_CODE.equals(((SysTenant)resultList.get(0)).getTenantCode())) {
                log.info("\u5f53\u524d\u7528\u6237\u53ea\u5728\u5e73\u53f0\u7ea7\u79df\u6237\u4e0b\u6709\u6570\u636e\uff0c\u4e0d\u9700\u8981\u53bb\u6389\u5e73\u53f0\u7ea7\uff0c\u5f53\u524d\u7528\u6237ID\uff1a{}", (Object)userId);
            } else {
                resultList = resultList.stream().filter(r -> !SYSTEM_TENANT_CODE.equals(r.getTenantCode())).collect(Collectors.toList());
            }
        }
        return resultList;
    }

    public SysTenant getDefaultTenant(String username) {
        SysUsers sysUsers = (SysUsers)this.usersService.getOne("master", (Wrapper)Wrappers.lambdaQuery().eq(SysUsers::getUserAccount, (Object)username));
        if (null == sysUsers || ArrayUtils.contains((Object[])ADMINS, (Object)sysUsers.getId())) {
            SysTenant defaultTenant = new SysTenant();
            defaultTenant.setTenantCode(SYSTEM_TENANT_CODE);
            defaultTenant.setTenantName("\u5e73\u53f0\u7ea7");
            defaultTenant.setConnName("master");
            return defaultTenant;
        }
        List<SysTenant> tenantList = this.switchTenantList(sysUsers.getId());
        ArrayList collect = tenantList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysTenant>(Comparator.comparing(SysTenant::getTenantSeq).thenComparing(Comparator.comparing(HussarBaseEntity::getCreateTime).reversed()))), ArrayList::new));
        if (HussarUtils.isNotEmpty((Object)collect)) {
            return (SysTenant)collect.get(0);
        }
        SysTenant defaultTenant = new SysTenant();
        defaultTenant.setTenantCode(SYSTEM_TENANT_CODE);
        defaultTenant.setTenantName("\u5e73\u53f0\u7ea7");
        defaultTenant.setConnName("master");
        return defaultTenant;
    }

    public SysTenant getDefaultTenantWithKaptcha(DefaultTenantDto defaultTenantDto) {
        this.verifyCode(defaultTenantDto);
        return this.getDefaultTenant(defaultTenantDto.getUsername());
    }

    public void verifyCode(DefaultTenantDto defaultTenantDto) {
        String loginType = defaultTenantDto.getIsIndex();
        if (!Objects.equals(loginType, AccessType.MOBILE.getLoginType())) {
            String kaptcha = StringUtils.trimToEmpty((String)defaultTenantDto.getKaptcha());
            String cacheName = "KAPTCHA_CODE";
            String kaptchasuffix = StringUtils.trimToEmpty((String)defaultTenantDto.getKaptchasuffix());
            String code = (String)HussarFixedCacheUtil.get((String)cacheName, (Object)kaptchasuffix, String.class);
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_VERIFY_CODE.getValue()));
            }
            if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                BaseException e = new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CAPTCHA_CODE_ERROR.getValue()));
                throw e;
            }
        }
    }

    @HussarDs(value="#connName")
    public Boolean switchTenant(String connName, HussarTenantDefinition tenantInfo) {
        UserDetails userDetails = this.getUserDetails(tenantInfo);
        userDetails = this.hussarBaseUserIdentityService.handleUserIdentity(userDetails, tenantInfo.getAppId());
        HussarSecurityUtils.updateUserDetails((UserDetails)userDetails);
        return Boolean.TRUE;
    }

    @NotNull
    private UserDetails getUserDetails(HussarTenantDefinition tenantInfo) {
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        userDetails.addExtendUserMap(this.hussarDynamicProperties.getDatasourceKeyByHeader(), (Object)tenantInfo.getConnName());
        userDetails.setTenantId(tenantInfo.getTenantId());
        userDetails.setTenantCode(tenantInfo.getTenantCode());
        userDetails.addExtendUserMap("tenantName", (Object)tenantInfo.getTenantName());
        userDetails.addExtendUserMap("tcode", (Object)tenantInfo.getTenantCode());
        userDetails.addExtendUserMap("connName", (Object)tenantInfo.getConnName());
        return userDetails;
    }

    private ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, Long userId, String connName) {
        List<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue()) || roleList.contains(SysUserAndRole.DEVELOP_ROLE.getValue())) {
            List resourcesList = this.sysResourcesService.list(connName);
            resourcePermissions = new ArrayList();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.sysResourcesService.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty(resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }
}

