/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.model.OutSideTenantLog;
import com.jxdinfo.hussar.tenant.common.model.TenantDbModel;
import com.jxdinfo.hussar.tenant.common.service.IOutSideUpdateTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.IStorageExecutorService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController(value="com.jxdinfo.hussar.tenant.common.controller.outsideCreateStorageController")
@RequestMapping(value={"/hussarBase/tenant/remote"})
public class OutsideCreateStorageController {
    private static Logger LOGGER = LoggerFactory.getLogger(OutsideCreateStorageController.class);
    @Autowired
    private IOutSideUpdateTenantLogService outSideUpdateTenantLogService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    @PostMapping(value={"/dealCreateStorage"})
    public void dealCreateStorage(@RequestBody Map<String, Object> params) {
        AsyncContext asyncContext;
        Map storageProperties = (Map)params.get("storageProperties");
        String tenantDbModelStr = (String)params.get("tenantDbModel");
        TenantDbModel tenantDbModel = (TenantDbModel)JSON.parseObject((String)tenantDbModelStr, TenantDbModel.class);
        String serviceName = (String)storageProperties.get("serviceName");
        String tenantCode = (String)storageProperties.get("tenantCode");
        String connName = (String)storageProperties.get("connName");
        String caller = (String)storageProperties.get("caller");
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            throw new BaseException("request is null");
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        HttpServletRequest request = servletRequestAttributes.getRequest();
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(request));
        AsyncContext finalAsyncContext = asyncContext = request.startAsync();
        finalAsyncContext.setTimeout(900000000L);
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        CompletableFuture.runAsync(() -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
            OutSideTenantLog result = new OutSideTenantLog();
            result.setServiceName(serviceName);
            result.setTenantCode(tenantCode);
            try {
                HussarContextHolder.setTenant((String)connName, (String)tenantCode);
                ((IStorageExecutorService)SpringContextHolder.getBean(IStorageExecutorService.class)).createDatabaseAndInitData(storageProperties, tenantDbModel);
                result.setSuccess(Boolean.valueOf(true));
                result.setJdbcUrl((String)storageProperties.get("jdbcUrl"));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("\u5fae\u670d\u52a1{}\u6267\u884c\u521b\u5efa\u6570\u636e\u50a8\u5b58\u51fa\u9519", (Object)serviceName, (Object)e);
                result.setSuccess(Boolean.valueOf(false));
                result.setSuccess(Boolean.valueOf(false));
                ExceptionUtil.getExceptionAllinformation((Throwable)e);
                result.setErrMsg(e.getMessage());
            }
            finally {
                if (HussarUtils.isNotEmpty((Object)finalAsyncContext)) {
                    finalAsyncContext.complete();
                }
            }
            this.outSideUpdateTenantLogService.updateTenantLog(result, caller);
        }, hussarBaseTenantExecutor);
    }
}

