/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.runner;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.tenant.runner.autoRegisterTenantMicroServiceRunner")
@Order(value=900004)
public class AutoRegisterTenantMicroServiceRunner
implements ApplicationRunner {
    private static Logger LOGGER = LoggerFactory.getLogger(AutoRegisterTenantMicroServiceRunner.class);
    @Autowired
    private ISysTenantRegisterService tenantRegisterService;

    public void run(ApplicationArguments args) throws Exception {
        boolean microService = EnvironmentUtil.isMicroService();
        if (!microService) {
            return;
        }
        String currentServiceName = EnvironmentUtil.getServiceName((boolean)true);
        if (HussarUtils.isNotBlank((CharSequence)currentServiceName)) {
            try {
                SysTenantRegister sysTenantRegister = this.tenantRegisterService.getByServiceName(currentServiceName);
                if (HussarUtils.isEmpty((Object)sysTenantRegister)) {
                    sysTenantRegister = new SysTenantRegister();
                    sysTenantRegister.setRegName("\u79df\u6237\u5fae\u670d\u52a1" + currentServiceName);
                    sysTenantRegister.setServiceName(currentServiceName);
                }
                sysTenantRegister.setRegStatus("1");
                this.tenantRegisterService.saveOrUpdate((Object)sysTenantRegister);
                LOGGER.info("\u79df\u6237\u5fae\u670d\u52a1{}\u81ea\u52a8\u6ce8\u518c\u6210\u529f", (Object)currentServiceName);
            }
            catch (Exception e) {
                LOGGER.error("\u79df\u6237\u5fae\u670d\u52a1{}\u81ea\u52a8\u6ce8\u518c\u5931\u8d25,\u4e3a\u4e86\u4fdd\u8bc1\u79df\u6237\u5fae\u670d\u52a1\u6b63\u5e38\u4f7f\u7528\uff0c\u8bf7\u9996\u5148\u5728\u5f00\u53d1\u8005\u4e2d\u5fc3->\u79df\u6237\u7ba1\u7406->\u79df\u6237\u670d\u52a1\u6ce8\u518c\u4e2d\u6ce8\u518c\u8be5\u5fae\u670d\u52a1", (Object)currentServiceName);
            }
        }
    }
}

