/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.model.OutSideTenantRetryUpgradeResult;
import com.jxdinfo.hussar.tenant.common.model.OutSideTenantUpgradeResult;
import com.jxdinfo.hussar.tenant.common.model.RetryUpgradeMicroServiceModel;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.TenantUpgradeMicroServiceInfo;
import com.jxdinfo.hussar.tenant.common.model.UpgradeMicroServiceModel;
import com.jxdinfo.hussar.tenant.common.service.IOutSideUpgradeCallBackService;
import com.jxdinfo.hussar.tenant.common.service.IUpgradeProcedureService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController(value="com.jxdinfo.hussar.tenant.common.controller.outsideUpgradeController")
@RequestMapping(value={"/hussarBase/tenant/remote"})
public class OutsideUpgradeController {
    private static Logger LOGGER = LoggerFactory.getLogger(OutsideUpgradeController.class);
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    @PostMapping(value={"/executUpgradeOutSide"})
    public void dealUpgrade(@RequestBody UpgradeMicroServiceModel upgradeMicroServiceModel) {
        String serviceName = upgradeMicroServiceModel.getServiceName();
        String caller = upgradeMicroServiceModel.getCaller();
        List tenantUpgradeMicroServiceInfoList = upgradeMicroServiceModel.getTenantUpgradeMicroServiceInfoList();
        if (HussarUtils.isEmpty((Object)tenantUpgradeMicroServiceInfoList)) {
            return;
        }
        ArrayList<OutSideTenantUpgradeResult> upgradeResultList = new ArrayList<OutSideTenantUpgradeResult>();
        for (TenantUpgradeMicroServiceInfo info : tenantUpgradeMicroServiceInfoList) {
            String tenantCode = info.getTenantCode();
            String connName = info.getConnName();
            String dbType = info.getDbType();
            OutSideTenantUpgradeResult upgradeResult = new OutSideTenantUpgradeResult();
            upgradeResult.setServiceName(serviceName);
            upgradeResult.setTenantCode(tenantCode);
            try {
                String path = "tenantsql/upgrade/" + dbType;
                Object[] upgradeExecuteSQLScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
                if (HussarUtils.isNotEmpty((Object[])upgradeExecuteSQLScripts)) {
                    for (Object resource : upgradeExecuteSQLScripts) {
                        String updateScript = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                        boolean check = StringUtils.isNotBlank((CharSequence)updateScript);
                        if (check) continue;
                        throw new BaseException("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\uff0c\u5347\u7ea7\u811a\u672c\u4e3a\u7a7a");
                    }
                } else {
                    throw new BaseException("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                }
                ((IHussarBaseSQLExecutor)SpringContextHolder.getBean(IHussarBaseSQLExecutor.class)).execTenantSqlFile(connName, dbType, (Resource[])upgradeExecuteSQLScripts, true);
                upgradeResult.setSuccess(Boolean.valueOf(true));
            }
            catch (Exception e) {
                upgradeResult.setSuccess(Boolean.valueOf(false));
                upgradeResult.setErrMsg(e.getMessage());
                LOGGER.error("\u5347\u7ea7\u670d\u52a1\u3010" + serviceName + "\u3011- \u79df\u6237\uff1a" + upgradeResult.getTenantCode() + "\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                e.printStackTrace();
            }
            upgradeResultList.add(upgradeResult);
        }
        IOutSideUpgradeCallBackService callBackService = (IOutSideUpgradeCallBackService)SpringContextHolder.getBean(IOutSideUpgradeCallBackService.class);
        callBackService.invokeCaller(upgradeResultList, caller);
    }

    @PostMapping(value={"/retryUpgradeOutSide"})
    public void retryUpgrade(@RequestBody RetryUpgradeMicroServiceModel retryUpgradeMicroServiceModel) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        BaseException.throwBy((null == requestAttributes ? 1 : 0) != 0, (String)"request is null");
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        HttpServletRequest request = servletRequestAttributes.getRequest();
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(request));
        AsyncContext finalAsyncContext = request.startAsync();
        finalAsyncContext.setTimeout(900000000L);
        CompletableFuture.runAsync(() -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
            try {
                this.doRetryUpgrade(retryUpgradeMicroServiceModel);
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
            finally {
                if (HussarUtils.isNotEmpty((Object)finalAsyncContext)) {
                    finalAsyncContext.complete();
                }
            }
        }, this.hussarThreadPoolConfiguration.getAsyncExecutor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRetryUpgrade(RetryUpgradeMicroServiceModel retryUpgradeMicroServiceModel) {
        List retryingUpgrades = retryUpgradeMicroServiceModel.getRetryingUpgrades();
        String tenantCode = retryUpgradeMicroServiceModel.getTenantCode();
        LinkedHashMap tenantUpgradeDirMap = retryUpgradeMicroServiceModel.getTenantUpgradeDirMap();
        Map upgradeProcedureMap = retryUpgradeMicroServiceModel.getUpgradeProcedureMap();
        String caller = retryUpgradeMicroServiceModel.getCaller();
        OutSideTenantRetryUpgradeResult outSideTenantRetryUpgradeResult = new OutSideTenantRetryUpgradeResult();
        outSideTenantRetryUpgradeResult.setTenantCode(tenantCode);
        outSideTenantRetryUpgradeResult.setOutsideServiceName(EnvironmentUtil.getServiceName((boolean)true));
        try {
            block20: for (SysTenantUpgrade retryingUpgrade : retryingUpgrades) {
                switch ((String)tenantUpgradeDirMap.get(retryingUpgrade.getUpgradeType())) {
                    case "procedure": {
                        try {
                            ((IUpgradeProcedureService)SpringContextHolder.getBean(IUpgradeProcedureService.class)).invoke((List)upgradeProcedureMap.get(retryingUpgrade.getUpgradeStep()));
                            retryingUpgrade.setUpdateStatus("1");
                            retryingUpgrade.setUpdateError(null);
                            continue block20;
                        }
                        catch (Exception e) {
                            retryingUpgrade.setUpdateStatus("0");
                            retryingUpgrade.setUpdateError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                            LOGGER.error("\u79df\u6237{}\u5347\u7ea7\u7b2c{}\u6b65\u6267\u884c\u5347\u7ea7\u7a0b\u5e8f\u5931\u8d25!", (Object)tenantCode, (Object)retryingUpgrade.getUpgradeStep());
                            throw new BaseException((Throwable)e);
                        }
                    }
                }
                try {
                    String scriptPath = String.format("classpath*:tenantsql/upgrade/%s/mysql/%s", tenantUpgradeDirMap.get(retryingUpgrade.getUpgradeType()), retryingUpgrade.getSqlPath());
                    ((IHussarBaseSQLExecutor)SpringContextHolder.getBean(IHussarBaseSQLExecutor.class)).execTenantSqlFile(retryingUpgrade.getConnName(), "mysql", SpringContextHolder.getApplicationContext().getResources(scriptPath), true);
                    retryingUpgrade.setUpdateStatus("1");
                    retryingUpgrade.setUpdateError(null);
                }
                catch (Exception e) {
                    retryingUpgrade.setUpdateStatus("0");
                    retryingUpgrade.setUpdateError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                    LOGGER.error("\u79df\u6237{}\u5347\u7ea7\u7b2c{}\u6b65\u6267\u884cSQL\u5931\u8d25!", (Object)tenantCode, (Object)retryingUpgrade.getUpgradeStep());
                    throw new BaseException((Throwable)e);
                    return;
                }
            }
        }
        catch (BaseException e) {
            outSideTenantRetryUpgradeResult.setIsSuccess(Boolean.valueOf(false));
            throw new BaseException((Throwable)e);
        }
        finally {
            outSideTenantRetryUpgradeResult.setRetryUpgradeResultList(retryingUpgrades);
            IOutSideUpgradeCallBackService callBackService = (IOutSideUpgradeCallBackService)SpringContextHolder.getBean(IOutSideUpgradeCallBackService.class);
            callBackService.retryInvokeCaller(outSideTenantRetryUpgradeResult, caller);
        }
    }
}

