/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.OutSideTenantUpgradeResult;
import com.jxdinfo.hussar.tenant.common.model.TenantUpgradeMicroServiceInfo;
import com.jxdinfo.hussar.tenant.common.model.UpgradeMicroServiceModel;
import com.jxdinfo.hussar.tenant.common.service.IOutSideUpgradeCallBackService;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.tenant.common.controller.outsideUpgradeController")
@RequestMapping(value={"/hussarBase/tenant/remote"})
public class OutsideUpgradeController {
    private static Logger LOGGER = LoggerFactory.getLogger(OutsideUpgradeController.class);
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSQLExecutor;
    @Autowired(required=false)
    private IOutSideUpgradeCallBackService outSideUpgradeCallBackService;

    @PostMapping(value={"/executUpgradeOutSide"})
    public void dealUpgrade(@RequestBody UpgradeMicroServiceModel upgradeMicroServiceModel) {
        String serviceName = upgradeMicroServiceModel.getServiceName();
        String caller = upgradeMicroServiceModel.getCaller();
        List tenantUpgradeMicroServiceInfoList = upgradeMicroServiceModel.getTenantUpgradeMicroServiceInfoList();
        if (HussarUtils.isEmpty((Object)tenantUpgradeMicroServiceInfoList)) {
            return;
        }
        ArrayList<OutSideTenantUpgradeResult> upgradeResultList = new ArrayList<OutSideTenantUpgradeResult>();
        for (TenantUpgradeMicroServiceInfo info : tenantUpgradeMicroServiceInfoList) {
            String tenantCode = info.getTenantCode();
            String connName = info.getConnName();
            String dbType = info.getDbType();
            OutSideTenantUpgradeResult upgradeResult = new OutSideTenantUpgradeResult();
            upgradeResult.setServiceName(serviceName);
            upgradeResult.setTenantCode(tenantCode);
            try {
                String path = "tenantsql/upgrade/" + dbType;
                Object[] upgradeExecuteSQLScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
                if (HussarUtils.isNotEmpty((Object[])upgradeExecuteSQLScripts)) {
                    for (Object resource : upgradeExecuteSQLScripts) {
                        String updateScript = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                        boolean check = StringUtils.isNotBlank((CharSequence)updateScript);
                        if (check) continue;
                        throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\uff0c\u5347\u7ea7\u811a\u672c\u4e3a\u7a7a");
                    }
                } else {
                    throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                }
                this.hussarBaseSQLExecutor.execSqlFile(connName, (Resource[])upgradeExecuteSQLScripts);
                upgradeResult.setSuccess(Boolean.valueOf(true));
            }
            catch (Exception e) {
                upgradeResult.setSuccess(Boolean.valueOf(false));
                upgradeResult.setErrMsg(e.getMessage());
                LOGGER.error("\u5347\u7ea7\u670d\u52a1\u3010" + serviceName + "\u3011- \u79df\u6237\uff1a" + upgradeResult.getTenantCode() + "\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                e.printStackTrace();
            }
            upgradeResultList.add(upgradeResult);
        }
        if (this.outSideUpgradeCallBackService != null) {
            this.outSideUpgradeCallBackService.invokeCaller(upgradeResultList, caller);
        }
    }
}

