/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.UpgradeMicroServiceModel;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.tenant.common.listener.microServiceUpgradeMessageListener")
public class MicroServiceUpgradeMessageListener
implements MessageListener {
    private static Logger LOGGER = LoggerFactory.getLogger(MicroServiceUpgradeMessageListener.class);

    private RedisTemplate getRedisTemplate() {
        return (RedisTemplate)SpringContextHolder.getBean((String)"redisTemplate");
    }

    private ISysTenantUpgradeService getUpgradeService() {
        return (ISysTenantUpgradeService)SpringContextHolder.getBean(ISysTenantUpgradeService.class);
    }

    private ISysTenantService getSysTenantService() {
        return (ISysTenantService)SpringContextHolder.getBean(ISysTenantService.class);
    }

    public void onMessage(Message message, byte[] pattern) {
        LOGGER.info("MicroServiceUpgradeMessageListener", (Object)message);
        byte[] messageBody = message.getBody();
        UpgradeMicroServiceModel upgradeMicroServiceModel = (UpgradeMicroServiceModel)this.getRedisTemplate().getValueSerializer().deserialize(messageBody);
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        String serviceName = upgradeMicroServiceModel.getServiceName();
        Long tenantId = upgradeMicroServiceModel.getTenantId();
        if (Objects.equals(serviceName, currentServiceName)) {
            List list;
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)"0");
            wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
            if (tenantId != null) {
                wrapper.eq(SysTenant::getId, (Object)tenantId);
            }
            if (HussarUtils.isNotEmpty((Object)(list = this.getSysTenantService().list((Wrapper)wrapper)))) {
                ((ExecutorService)SpringContextHolder.getBean(ExecutorService.class)).execute(() -> {
                    for (SysTenant tenant : list) {
                        SysTenantUpgrade sysTenantUpgrade = new SysTenantUpgrade();
                        this.asyncUpdateMicroServiceOne(currentServiceName, sysTenantUpgrade, tenant);
                    }
                });
            }
        }
    }

    private void asyncUpdateMicroServiceOne(String serviceName, SysTenantUpgrade sysTenantUpgrade, SysTenant tenant) {
        String connName = tenant.getConnName();
        sysTenantUpgrade.setTenantCode(tenant.getTenantCode());
        sysTenantUpgrade.setTenantId(tenant.getId());
        sysTenantUpgrade.setConnName(connName);
        sysTenantUpgrade.setServiceName(serviceName);
        LambdaQueryWrapper datasourceWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        SysTenantDatasource sysTenantDatasource = (SysTenantDatasource)((ISysTenantDataSourceService)SpringContextHolder.getBean(ISysTenantDataSourceService.class)).getOne((Wrapper)datasourceWrapper);
        if (HussarUtils.isNotEmpty((Object)sysTenantDatasource)) {
            String dbUrl = sysTenantDatasource.getJdbcUrl();
            String dbType = DbUtil.getDbType((String)dbUrl);
            try {
                String path = "tenantsql/upgrade/" + dbType;
                Object[] upgradeExecuteSQLScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
                if (HussarUtils.isNotEmpty((Object[])upgradeExecuteSQLScripts)) {
                    for (Object resource : upgradeExecuteSQLScripts) {
                        boolean check;
                        String updateScript = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                        boolean bl = check = StringUtils.isNotBlank((CharSequence)updateScript) && updateScript.contains("UPDATE");
                        if (check) continue;
                        throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                    }
                } else {
                    throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                }
                ((IHussarBaseSQLExecutor)SpringContextHolder.getBean(IHussarBaseSQLExecutor.class)).execSqlFile(connName, (Resource[])upgradeExecuteSQLScripts);
                sysTenantUpgrade.setUpdateStatus("1");
            }
            catch (Exception e) {
                sysTenantUpgrade.setUpdateStatus("0");
                sysTenantUpgrade.setUpdateError(e.getMessage());
                LOGGER.error("\u5347\u7ea7\u670d\u52a1\u3010" + serviceName + "\u3011- \u79df\u6237\uff1a" + tenant.getTenantCode() + "\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                e.printStackTrace();
            }
            this.getUpgradeService().saveOrUpdate((Object)sysTenantUpgrade);
        }
    }
}

