/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.listener;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.service.IStorageExecutorService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.model.HussarMethod;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.tenant.common.listener.createStorageMessageListener")
public class CreateStorageMessageListener
implements MessageListener {
    private static Logger LOGGER = LoggerFactory.getLogger(CreateStorageMessageListener.class);

    private RedisTemplate getRedisTemplate() {
        return (RedisTemplate)SpringContextHolder.getBean((String)"redisTemplate");
    }

    private IStorageExecutorService getStorageExecutorService() {
        return (IStorageExecutorService)SpringContextHolder.getBean(IStorageExecutorService.class);
    }

    private ISysTenantLogService getSysTenantLogService() {
        return (ISysTenantLogService)SpringContextHolder.getBean(ISysTenantLogService.class);
    }

    public void onMessage(Message message, byte[] pattern) {
        LOGGER.info("CreateStorageMessageListener", (Object)message);
        byte[] messageBody = message.getBody();
        List storagePropertiesList = (List)this.getRedisTemplate().getValueSerializer().deserialize(messageBody);
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (HussarUtils.isNotEmpty((Object)storagePropertiesList)) {
            String tenantCode = (String)((Map)storagePropertiesList.get(0)).get("tenantCode");
            int startNo = StepConstants.MICROSERVICE_CREATE_DB_MIN;
            List sysTenantLogs = this.getSysTenantLogService().listByTenantCode(tenantCode);
            List<Object> logs = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)sysTenantLogs)) {
                logs = sysTenantLogs.stream().filter(item -> item.getStepNo() <= StepConstants.MICROSERVICE_CREATE_DB_MAX && item.getStepNo() >= StepConstants.MICROSERVICE_CREATE_DB_MIN && item.getExecStatus().equals(0)).collect(Collectors.toList());
            }
            Map logMap = Maps.newHashMap();
            if (HussarUtils.isNotEmpty(logs)) {
                logMap = EntityUtils.toMap(logs, SysTenantLog::getServiceName);
            }
            for (Map storageProperties : storagePropertiesList) {
                String serviceName = (String)storageProperties.get("serviceName");
                String connName = (String)storageProperties.get("connName");
                if (!HussarUtils.isNotEmpty((Object)serviceName) || !Objects.equals(currentServiceName, serviceName)) continue;
                SysTenantLog createDb = (SysTenantLog)logMap.get(serviceName);
                boolean flag = HussarUtils.isEmpty((Object)createDb);
                if (flag) {
                    createDb = new SysTenantLog();
                } else {
                    createDb.setExecStatus(Integer.valueOf(2));
                    this.getSysTenantLogService().updateById((Object)createDb);
                }
                try {
                    if (flag) {
                        createDb.setStepNo(Integer.valueOf(startNo++));
                        createDb.setServiceName(currentServiceName);
                        createDb.setMethodTag("createDb");
                        createDb.setTenantCode(tenantCode);
                        createDb.setBeanName("com.jxdinfo.hussar.datasource.service.feign.impl.remoteHussarBaseStorageExecutorServiceImpl");
                        createDb.setMethodName("createDatabaseAndInitData");
                        createDb.setMethodDesc("\u521b\u5efa\u6570\u636e\u5b58\u50a8");
                        createDb.setConnName(connName);
                        Class[] paramClass = new Class[]{Map.class};
                        Object[] paramValues = new Object[]{storageProperties};
                        createDb.setMethodParams(JSON.toJSONString((Object)Lists.newArrayList((Object[])new HussarMethod[]{new HussarMethod(Map.class, paramClass, paramValues)})));
                        createDb.setErrorTimes(Integer.valueOf(0));
                    }
                    createDb.setExecStatus(Integer.valueOf(1));
                    LOGGER.info("\u670d\u52a1{}\u6536\u5230\u6d88\u606f", (Object)serviceName);
                    this.getStorageExecutorService().createDatabaseAndInitData(storageProperties);
                    this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)createDb);
                }
                catch (Exception e) {
                    createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
                    createDb.setExecStatus(Integer.valueOf(0));
                    createDb.setExecError(e.getMessage());
                    this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)createDb);
                    throw new BaseException("\u670d\u52a1" + currentServiceName + "\u521b\u5efa\u6570\u636e\u5b58\u50a8\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }
}

