/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.config;

import com.jxdinfo.hussar.support.cache.config.HussarCacheConfiguration;
import com.jxdinfo.hussar.tenant.common.listener.CreateStorageMessageListener;
import com.jxdinfo.hussar.tenant.common.listener.MicroServiceUpgradeMessageListener;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.scheduling.annotation.EnableAsync;

@ConditionalOnProperty(prefix="hussar.core.tenant", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableAsync
@Configuration
@ComponentScan(value={"com.jxdinfo.hussar.tenant.common.service.feign.impl", "com.jxdinfo.hussar.tenant.common.listener", "com.jxdinfo.hussar.tenant.common.dynamicfeign"})
@AutoConfigureAfter(value={HussarCacheConfiguration.class})
public class RemoteHussarTenantCommonConfiguration {
    @Bean
    public RedisMessageListenerContainer container(RedisConnectionFactory factory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(factory);
        container.addMessageListener((MessageListener)new CreateStorageMessageListener(), (Topic)new ChannelTopic("topic_storage_create"));
        container.addMessageListener((MessageListener)new MicroServiceUpgradeMessageListener(), (Topic)new ChannelTopic("topic_microservice_upgrade"));
        return container;
    }
}

