/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.service.IStorageExecutorService;
import com.jxdinfo.hussar.tenant.common.model.OutSideTenantLog;
import com.jxdinfo.hussar.tenant.common.service.IOutSideUpdateTenantLogService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.tenant.common.controller.outsideCreateStorageController")
@RequestMapping(value={"/hussarBase/tenant/remote"})
public class OutsideCreateStorageController {
    private static Logger LOGGER = LoggerFactory.getLogger(OutsideCreateStorageController.class);
    @Autowired
    private IOutSideUpdateTenantLogService outSideUpdateTenantLogService;
    private static ExecutorService hussarBaseTenantExecutor = (ExecutorService)SpringContextHolder.getBean(ExecutorService.class);

    @PostMapping(value={"/dealCreateStorage"})
    public void dealCreateStorage(@RequestBody Map<String, Object> storageProperties) {
        String serviceName = (String)storageProperties.get("serviceName");
        String tenantCode = (String)storageProperties.get("tenantCode");
        String connName = (String)storageProperties.get("connName");
        String caller = (String)storageProperties.get("caller");
        CompletableFuture.runAsync(() -> {
            OutSideTenantLog result = new OutSideTenantLog();
            result.setServiceName(serviceName);
            result.setTenantCode(tenantCode);
            try {
                HussarContextHolder.setTenant((String)connName, (String)tenantCode);
                ((IStorageExecutorService)SpringContextHolder.getBean(IStorageExecutorService.class)).createDatabaseAndInitData(storageProperties);
                result.setSuccess(Boolean.valueOf(true));
                result.setJdbcUrl((String)storageProperties.get("jdbcUrl"));
            }
            catch (Exception e) {
                LOGGER.error("\u5fae\u670d\u52a1{}\u6267\u884c\u521b\u5efa\u6570\u636e\u50a8\u5b58\u51fa\u9519", (Object)serviceName, (Object)e);
                result.setSuccess(Boolean.valueOf(false));
                result.setErrMsg(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            }
            this.outSideUpdateTenantLogService.updateTenantLog(result, caller);
        }, hussarBaseTenantExecutor);
    }
}

