/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.storage;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarTenantExtendProperties;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.dto.QuerySysTenantSqlDto;
import com.jxdinfo.hussar.tenant.common.factory.StorageFactory;
import com.jxdinfo.hussar.tenant.common.manager.IDatabaseManager;
import com.jxdinfo.hussar.tenant.common.manager.ISchemaManager;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSql;
import com.jxdinfo.hussar.tenant.common.model.TenantDbModel;
import com.jxdinfo.hussar.tenant.common.service.IStorageExecutorService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSqlService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.init.UncategorizedScriptException;

public abstract class AbstractRdbStorageExecutorService
implements IStorageExecutorService,
InitializingBean {
    @Autowired
    private ISchemaManager schemaManager;
    @Autowired
    private IDatabaseManager databaseManager;
    @Autowired
    private SysDataSourceService sysDataSourceService;
    @Autowired(required=false)
    private ISysTenantSqlService sysTenantSqlService;
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Autowired
    private HussarTenantExtendProperties hussarTenantExtendProperties;

    @HussarTransactional
    public void createDatabaseAndInitData(Map<String, Object> storageProperties, TenantDbModel tenantDbModel) throws BaseException, IOException, SQLException, InterruptedException, UncategorizedScriptException {
        String creation = tenantDbModel.getCreation();
        SysDataSourceDto sysDataSourceDto = tenantDbModel.getSysDataSourceDto();
        String connName = sysDataSourceDto.getConnName();
        sysDataSourceDto.setThrowWhenConnNameExist(false);
        if (creation.equals("1")) {
            this.schemaManager.createSchemaAndInitData(sysDataSourceDto);
        } else {
            if (this.hussarTenantExtendProperties.isAutoCreateDb()) {
                this.sysDataSourceService.saveDataSourceWithCheck(sysDataSourceDto, false);
            }
            if (this.hussarTenantExtendProperties.isAutoExecuteSql()) {
                this.databaseManager.executeInitData(sysDataSourceDto);
            }
        }
        boolean tenantOpen = TenantCacheUtil.openTenant();
        if (tenantOpen) {
            this.recordTenantSqlInfo(storageProperties, tenantDbModel, connName);
        }
    }

    private void recordTenantSqlInfo(Map<String, Object> storageProperties, TenantDbModel tenantDbModel, String connName) throws IOException {
        String tenantCode = (String)storageProperties.get("tenantCode");
        String serviceName = StringUtils.trimToEmpty((String)tenantDbModel.getServiceName());
        QuerySysTenantSqlDto querySysTenantSqlDto = new QuerySysTenantSqlDto();
        querySysTenantSqlDto.setTenantCode(tenantCode);
        querySysTenantSqlDto.setServiceName(serviceName);
        String currentSqlPath = this.sysTenantSqlService.getCurrentSqlPath(querySysTenantSqlDto);
        boolean exist = StringUtils.isBlank((CharSequence)currentSqlPath);
        if (exist) {
            currentSqlPath = this.getCurrentSqlPath(tenantDbModel, currentSqlPath);
        }
        if (StringUtils.isNotBlank((CharSequence)currentSqlPath)) {
            this.saveTenantSqlRecord(connName, tenantCode, serviceName, currentSqlPath);
        }
    }

    private void saveTenantSqlRecord(String connName, String tenantCode, String serviceName, String currentSqlPath) {
        QuerySysTenantSqlDto querySysTenantSqlDto = new QuerySysTenantSqlDto();
        querySysTenantSqlDto.setTenantCode(tenantCode);
        querySysTenantSqlDto.setSqlPath(currentSqlPath);
        querySysTenantSqlDto.setServiceName(serviceName);
        SysTenantSql sysTenantSql = this.sysTenantSqlService.getOneTenantSql(querySysTenantSqlDto);
        boolean add = false;
        if (null == sysTenantSql) {
            sysTenantSql = new SysTenantSql();
            HussarTenantDefinition tenantByTenantCode = this.sysTenantService.getTenantByTenantCode(tenantCode);
            sysTenantSql.setTenantId(tenantByTenantCode.getTenantId());
            add = true;
        }
        sysTenantSql.setConnName(connName);
        sysTenantSql.setTenantCode(tenantCode);
        sysTenantSql.setServiceName(serviceName);
        sysTenantSql.setSqlPath(currentSqlPath);
        sysTenantSql.setExecuteStatus("1");
        if (add) {
            this.sysTenantSqlService.save((Object)sysTenantSql);
        } else {
            this.sysTenantSqlService.updateById((Object)sysTenantSql);
        }
    }

    private String getCurrentSqlPath(TenantDbModel tenantDbModel, String currentSqlPath) throws IOException {
        String dbType = DbUtil.getDbType((String)tenantDbModel.getSysDataSourceDto().getJdbcUrl());
        Object[] upgradeExecuteSQLScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
        if (HussarUtils.isNotEmpty((Object[])upgradeExecuteSQLScripts)) {
            int len = upgradeExecuteSQLScripts.length;
            Object resource = upgradeExecuteSQLScripts[len - 1];
            String uri = resource.getURI().toString();
            currentSqlPath = uri.substring(uri.indexOf("tenantsql"));
        }
        return currentSqlPath;
    }

    public void afterPropertiesSet() throws Exception {
        StorageFactory.add((String)"rdb", (IStorageExecutorService)this);
    }
}

