/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.tenant.common.dto.InitTenantUpgradeDto;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeMetaInfo;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeOptionConfig;
import com.jxdinfo.hussar.tenant.common.entity.UpgradeStep;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgradeRecord;
import com.jxdinfo.hussar.tenant.common.service.IInitTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeMetaInfoService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.vo.InitTenantUpgradeVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.common.service.impl.InitTenantUpgradeServiceImpl")
public class InitTenantUpgradeServiceImpl
implements IInitTenantUpgradeService {
    @Autowired
    private ISysTenantUpgradeMetaInfoService sysTenantUpgradeMetaInfoService;
    @Autowired
    private ISysTenantUpgradeService sysTenantUpgradeService;

    public InitTenantUpgradeVo initTenantUpgrade(InitTenantUpgradeDto initTenantUpgradeDto) {
        return this.init(initTenantUpgradeDto, false);
    }

    private InitTenantUpgradeVo init(InitTenantUpgradeDto initTenantUpgradeDto, boolean master) {
        String serviceName = EnvironmentUtil.getServiceName();
        UpgradeOptionConfig upgradeOptionConfig = initTenantUpgradeDto.getUpgradeOptionConfig();
        List tenantList = initTenantUpgradeDto.getTenantList();
        String toVersion = initTenantUpgradeDto.getToVersion();
        boolean i18n = upgradeOptionConfig.isI18n();
        boolean clp = upgradeOptionConfig.isClp();
        boolean sp = upgradeOptionConfig.isSp();
        HashMap<String, List> map = new HashMap<String, List>();
        SysTenantUpgradeRecord tenantUpgradeRecord = null;
        SysTenantUpgrade upgrade = null;
        InitTenantUpgradeVo vo = new InitTenantUpgradeVo();
        ArrayList<SysTenantUpgrade> tenantUpgradeList = new ArrayList<SysTenantUpgrade>();
        ArrayList<SysTenantUpgradeRecord> tenantUpgradeRecordList = new ArrayList<SysTenantUpgradeRecord>();
        vo.setTenantUpgradeList(tenantUpgradeList);
        vo.setTenantUpgradeRecordList(tenantUpgradeRecordList);
        this.sysTenantUpgradeMetaInfoService.init();
        for (HussarTenantDefinition hussarTenantDefinition : tenantList) {
            String version = hussarTenantDefinition.getTenantVersion();
            Long tenantId = hussarTenantDefinition.getTenantId();
            String tenantCode = hussarTenantDefinition.getTenantCode();
            String tenantName = hussarTenantDefinition.getTenantName();
            String connName = hussarTenantDefinition.getConnName();
            if (version.compareTo(toVersion) >= 0) continue;
            Integer max = this.sysTenantUpgradeService.getMaxByTenantCode(tenantCode);
            String k = version + "-" + toVersion;
            List versionMetaNoContainFromList = (List)map.get(k);
            if (HussarUtils.isEmpty((Object)versionMetaNoContainFromList)) {
                versionMetaNoContainFromList = this.sysTenantUpgradeMetaInfoService.getVersionMetaNoContainFrom(version, toVersion);
                map.put(k, versionMetaNoContainFromList);
            }
            for (UpgradeMetaInfo upgradeMetaInfo : versionMetaNoContainFromList) {
                List upgradeSteps = upgradeMetaInfo.getUpgradeSteps();
                String dirName = upgradeMetaInfo.getDirName();
                for (UpgradeStep upgradeStep : upgradeSteps) {
                    String upgradeType = upgradeStep.getType();
                    if (!i18n && upgradeType.equals("international") || !sp && upgradeType.equals("level-protection-sub") || !clp && upgradeType.equals("level-protection")) continue;
                    upgrade = new SysTenantUpgrade();
                    upgrade.setId(Long.valueOf(IdWorker.getId((Object)upgrade)));
                    upgrade.setTenantId(tenantId);
                    upgrade.setTenantCode(tenantCode);
                    upgrade.setTenantName(tenantName);
                    upgrade.setDirName(dirName);
                    upgrade.setConnName(connName);
                    upgrade.setServiceName(serviceName);
                    upgrade.setCurrentVersion(upgradeMetaInfo.getVersion());
                    upgrade.setUpgradeType(upgradeType);
                    max = max + 1;
                    upgrade.setUpgradeStep(max);
                    upgrade.setSqlPath(upgradeMetaInfo.getSqlFileName());
                    upgrade.setUpdateStatus("2");
                    String upgradeDescription = upgradeStep.getDescription();
                    if (StringUtils.isNotBlank((CharSequence)serviceName)) {
                        upgradeDescription = serviceName + ":" + upgradeDescription;
                    }
                    upgrade.setUpgradeDescription(upgradeDescription);
                    tenantUpgradeList.add(upgrade);
                }
            }
            if (!master) continue;
            tenantUpgradeRecord = new SysTenantUpgradeRecord();
            tenantUpgradeRecord.setId(Long.valueOf(IdWorker.getId((Object)tenantUpgradeRecord)));
            tenantUpgradeRecord.setConnName(connName);
            tenantUpgradeRecord.setFromVersion(version);
            tenantUpgradeRecord.setTenantCode(tenantCode);
            tenantUpgradeRecord.setTenantId(tenantId);
            tenantUpgradeRecord.setToVersion(toVersion);
            tenantUpgradeRecord.setUpdateStatus("2");
            tenantUpgradeRecordList.add(tenantUpgradeRecord);
        }
        return vo;
    }

    public InitTenantUpgradeVo initTenantUpgradeMaster(InitTenantUpgradeDto initTenantUpgradeDto) {
        return this.init(initTenantUpgradeDto, true);
    }
}

