/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.cache;

import com.jxdinfo.hussar.platform.core.support.service.CacheCreatorService;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import javax.annotation.Resource;

public class DynamicCachePrefixServiceImpl
implements CacheCreatorService {
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    private static final HussarTenantDefinition HUSSAR_DEFAULT_TENANT = new DefaultTenant();
    private static final String HUSSAR_DEFAULT_TENANTCODE = "0";

    public String creatorCachePrefix() {
        boolean tenantOpen = this.hussarTenantProperties.isEnabled();
        String tenantCode = null;
        String domain = null;
        if (tenantOpen) {
            HussarTenantDefinition hussarTenant = HussarContextHolder.getHussarTenant();
            if (null == hussarTenant) {
                hussarTenant = HUSSAR_DEFAULT_TENANT;
            }
            domain = hussarTenant.getTenantDomain();
            tenantCode = hussarTenant.getTenantCode();
        }
        if (HussarUtils.isNotBlank(domain)) {
            return "tenant:" + domain;
        }
        if (HussarUtils.isNotBlank(tenantCode)) {
            return "tenant:" + tenantCode;
        }
        return "tenant:0";
    }
}

