/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.manager.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseDatabaseOperateService;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.manager.IDatabaseManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultDatabaseManagerImpl
implements IDatabaseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDatabaseManagerImpl.class);
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSQLExecutor;

    public void executeInitData(SysDataSourceDto sysDataSourceDto) {
        String connName = sysDataSourceDto.getConnName();
        String dbType = DbUtil.getDbType((String)sysDataSourceDto.getJdbcUrl());
        if (HussarUtils.isNotEmpty((Object)sysDataSourceDto.getDbMode()) && sysDataSourceDto.getDbMode().equals("kingbase_pg")) {
            dbType = "postgresql";
        }
        IHussarBaseDatabaseOperateService hussarBaseDatabaseOperateService = DatabaseFactory.get((String)dbType);
        try {
            LOGGER.info("\u6570\u636e\u6e90{}\u6267\u884c\u811a\u672c\u3002\u3002\u3002", (Object)connName);
            this.hussarBaseSQLExecutor.execTenantSqlFile(connName, dbType, hussarBaseDatabaseOperateService.getInitExecuteSQLScripts());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }
}

