/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.config;

import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.jxdinfo.hussar.platform.core.support.service.CacheCreatorService;
import com.jxdinfo.hussar.tenant.common.cache.DynamicCachePrefixServiceImpl;
import com.jxdinfo.hussar.tenant.common.creator.BaseTenantCreator;
import com.jxdinfo.hussar.tenant.common.manager.IDatabaseManager;
import com.jxdinfo.hussar.tenant.common.manager.ISchemaManager;
import com.jxdinfo.hussar.tenant.common.manager.impl.DefaultDatabaseManagerImpl;
import com.jxdinfo.hussar.tenant.common.manager.impl.DefaultSchemaManagerImpl;
import com.jxdinfo.hussar.tenant.common.service.IStorageExecutorService;
import com.jxdinfo.hussar.tenant.common.storage.DefaultRdbStorageExecutorService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@ConditionalOnProperty(prefix="hussar.core.tenant", name={"enabled"}, havingValue="true", matchIfMissing=false)
@Configuration
public class HussarTenantCommonAutoConfig {
    @Order(value=1)
    @Bean(value={"com.jxdinfo.hussar.tenant.baseTenantCreator"})
    public BaseTenantCreator baseTenantCreator() {
        return new BaseTenantCreator();
    }

    @Bean(value={"com.jxdinfo.hussar.tenant.cache.dynamicCachePrefixServiceImpl"})
    public CacheCreatorService tenantCacheCreatorService() {
        return new DynamicCachePrefixServiceImpl();
    }

    @Bean(value={"com.jxdinfo.hussar.tenant.tenantIdWorker"})
    public DefaultIdentifierGenerator tenantIdWorker() {
        return new DefaultIdentifierGenerator(8L, 8L);
    }

    @Bean
    @ConditionalOnMissingBean
    public IStorageExecutorService storageExecutorService() {
        return new DefaultRdbStorageExecutorService();
    }

    @Bean
    @ConditionalOnMissingBean
    public IDatabaseManager tenantDatabaseManager() {
        return new DefaultDatabaseManagerImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public ISchemaManager tenantSchemaManager() {
        return new DefaultSchemaManagerImpl();
    }
}

