/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.interceptor;

import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HussarTenantInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        IHussarTenantCommonService tenantCommonService = (IHussarTenantCommonService)SpringContextHolder.getBean(IHussarTenantCommonService.class);
        HussarTenantDefinition tenantInfo = tenantCommonService.parse();
        if (HussarUtils.isNotEmpty((Object)tenantInfo)) {
            this.checkTeant(tenantInfo);
        }
        HussarContextHolder.setTenant((HussarTenantDefinition)tenantInfo);
        return super.preHandle(request, response, handler);
    }

    private void checkTeant(HussarTenantDefinition tenantInfo) {
        if (StringUtils.isNotBlank((CharSequence)tenantInfo.getTenantCode()) && !tenantInfo.getConnName().equals("master")) {
            Boolean timeLimit = tenantInfo.getTimeLimit();
            LocalDateTime startTime = tenantInfo.getStartTime();
            LocalDateTime endTime = tenantInfo.getEndTime();
            String tenantStatus = tenantInfo.getTenantStatus();
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("0"), (String)"\u79df\u6237\u5df2\u5220\u9664");
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("2"), (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((tenantStatus.equalsIgnoreCase("3") || tenantStatus.equalsIgnoreCase("4") ? 1 : 0) != 0, (String)"\u79df\u6237\u4e0d\u53ef\u7528");
            AssertUtil.isFalse((timeLimit != false && endTime.isBefore(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((timeLimit != false && startTime.isAfter(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u672a\u751f\u6548");
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        HussarContextHolder.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

