/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.interceptor;

import com.jxdinfo.hussar.common.exception.TenantDisableException;
import com.jxdinfo.hussar.common.exception.TenantOverdueException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HussarTenantInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        IHussarTenantCommonService tenantCommonService = (IHussarTenantCommonService)SpringContextHolder.getBean(IHussarTenantCommonService.class);
        HussarTenantDefinition tenantInfo = tenantCommonService.parse();
        if (HussarUtils.isNotEmpty((Object)tenantInfo)) {
            this.checkTeant(request, tenantInfo);
        }
        HussarContextHolder.setTenant((HussarTenantDefinition)tenantInfo);
        return super.preHandle(request, response, handler);
    }

    private void checkTeant(HttpServletRequest request, HussarTenantDefinition tenantInfo) {
        if (StringUtils.isNotBlank((CharSequence)tenantInfo.getTenantCode()) && !tenantInfo.getConnName().equals("master")) {
            Boolean timeLimit = tenantInfo.getTimeLimit();
            LocalDateTime endTime = tenantInfo.getEndTime();
            String tenantStatus = tenantInfo.getTenantStatus();
            if (tenantStatus.equalsIgnoreCase("0") || tenantStatus.equalsIgnoreCase("2")) {
                List cacheKeys;
                if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser()) && StringUtils.isNotBlank((CharSequence)BaseSecurityUtil.getUser().getAccessToken())) {
                    HussarSecurityUtils.revokeAccessToken((String)BaseSecurityUtil.getUser().getAccessToken());
                }
                if (HussarUtils.isNotEmpty((Object)(cacheKeys = HussarFixedCacheUtil.getKeysLike((String)"tenant_info", (String)"?")))) {
                    for (String cacheKey : cacheKeys) {
                        if (!cacheKey.equals(tenantInfo.getTenantId())) continue;
                        HussarFixedCacheUtil.evict((String)"tenant_info", (Object)cacheKey);
                        break;
                    }
                }
            }
            if (request != null) {
                if (request.getRequestURI().contains("baseData/getBaseData")) {
                    return;
                }
                if (tenantStatus.equalsIgnoreCase("0")) {
                    throw new TenantDisableException("\u79df\u6237\u5df2\u5220\u9664\uff01");
                }
                if (tenantStatus.equalsIgnoreCase("2")) {
                    throw new TenantOverdueException("\u79df\u6237\u5df2\u5931\u6548\uff01");
                }
                if (timeLimit.booleanValue() && endTime.isBefore(Java8DateUtils.currentLocalDateTime())) {
                    throw new TenantOverdueException("\u79df\u6237\u5df2\u5931\u6548\uff01");
                }
            }
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        HussarContextHolder.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

