/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.domain.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.MiddleStep;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.model.TenantDbModel;
import com.jxdinfo.hussar.tenant.common.service.IOutSideDeleteDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.impl.AbstractHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.domain.dao.SysTenantDomainMapper;
import com.jxdinfo.hussar.tenant.domain.model.SolitarydomainTenant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.DomainValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.domain.service.impl.hussarBaseSolitarydomainTenantServiceImpl")
public class HussarBaseSolitarydomainTenantServiceImpl
extends AbstractHussarBaseTenantService<SolitarydomainTenant> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseSolitarydomainTenantServiceImpl.class);
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantDomainMapper sysTenantDomainMapper;

    public Page<SolitarydomainTenant> searchTenant(QueryTenantDto queryTenantDto) {
        Page page = new Page(queryTenantDto.getCurrent(), queryTenantDto.getSize());
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("tenantCode", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantCode()));
        queryOrgParams.put("tenantName", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantName()));
        queryOrgParams.put("tenantDomain", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantDomain()));
        queryOrgParams.put("tenantStatus", queryTenantDto.getTenantStatus());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SolitarydomainTenant> solitarydomainTenants = this.sysTenantDomainMapper.searchSolitarydomainTenant((Page<SolitarydomainTenant>)page, queryOrgParams);
        page.setRecords(solitarydomainTenants);
        return page;
    }

    public SolitarydomainTenant findTenantById(Long tenantId) {
        HussarTenantDefinition tenantByTenantId = this.getTenantByTenantId(tenantId);
        return (SolitarydomainTenant)TenantUtil.convert((HussarTenantDefinition)tenantByTenantId, SolitarydomainTenant.class);
    }

    @HussarTransactional
    public void initTenantAdmin(String connName, SolitarydomainTenant solitaryTenant) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setUserName(solitaryTenant.getLinkman());
        sysUsers.setMobile(solitaryTenant.getContactNumber());
        sysUsers.setUserAccount(solitaryTenant.getUserAccount());
        TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
        String encodeSecure = TenantUtil.getEncodeSecure((String)solitaryTenant.getSecure());
        sysUsers.setPassword(encodeSecure);
        Integer userOrder = this.usersService.getUserMaxOrder();
        userOrder = HussarUtils.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        sysUsers.setUserOrder(userOrder);
        this.usersService.save(connName, (Object)sysUsers);
        solitaryTenant.setTenantAdminId(sysUsers.getId());
    }

    protected List<TenantDbModel> checkAndGetTenantDbModelList(SolitarydomainTenant solitarydomainTenant) {
        boolean notMaster;
        String connName = solitarydomainTenant.getConnName();
        boolean bl = notMaster = HussarUtils.isNotBlank((CharSequence)connName) && !connName.equalsIgnoreCase("master");
        if (!notMaster) {
            throw new BaseException("\u975e\u6cd5\u6570\u636e\u6e90\u540d\u79f0");
        }
        if (connName.contains("-") || connName.contains("_")) {
            throw new BaseException("\u6570\u636e\u6e90\u540d\u79f0\u4e0d\u80fd\u5305\u542b-\u6216\u8005_");
        }
        Set allDatasourcesName = this.dynamicDatasourceService.getAllDatasourcesName();
        boolean contains = false;
        if (HussarUtils.isNotEmpty((Object)allDatasourcesName)) {
            for (String dsName : allDatasourcesName) {
                if (!dsName.equalsIgnoreCase(connName)) continue;
                contains = true;
                break;
            }
        }
        if (contains) {
            throw new BaseException("\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d");
        }
        Optional<SysTenantDatasource> anyDs = this.sysTenantDataSourceService.list().stream().filter(item -> item.getConnName().equalsIgnoreCase(connName)).findAny();
        if (anyDs.isPresent()) {
            throw new BaseException("\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d");
        }
        List storagePropertiesList = solitarydomainTenant.getStoragePropertiesList();
        if (HussarUtils.isEmpty((Object)storagePropertiesList)) {
            throw new BaseException("\u79df\u6237\u6570\u636e\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a");
        }
        List tenantDbModelList = this.sysTenantDataSourceService.ofTenant((HussarTenantDefinition)solitarydomainTenant);
        for (TenantDbModel dto : tenantDbModelList) {
            this.checkDb(dto);
        }
        return tenantDbModelList;
    }

    protected void createDbInSingleEnvironment(SolitarydomainTenant solitarydomainTenant, List<TenantDbModel> tenantDbModelList, HussarTenantDefinition definition, List<Map<String, Object>> storagePropertiesList, String currentServiceName) {
        this.createDbOfSingle((HussarTenantDefinition)solitarydomainTenant, tenantDbModelList, definition, storagePropertiesList, currentServiceName);
    }

    protected void createDbInMicroServiceEnvironment(SolitarydomainTenant solitarydomainTenant, List<TenantDbModel> tenantDbModelList, HussarTenantDefinition definition, List<Map<String, Object>> storagePropertiesList, String currentServiceName, Map<String, TenantDbModel> tenantDbModelMap) {
        this.createDbOfMicroService((HussarTenantDefinition)solitarydomainTenant, tenantDbModelList, definition, storagePropertiesList, currentServiceName, tenantDbModelMap);
    }

    protected List<MiddleStep> defineDynamicStep(SolitarydomainTenant solitarydomainTenant) {
        String defaultBeanName = "com.jxdinfo.hussar.tenant.domain.service.impl.hussarBaseSolitarydomainTenantServiceImpl";
        ArrayList<MiddleStep> result = new ArrayList<MiddleStep>();
        MiddleStep step1 = new MiddleStep();
        step1.setStepNo(Integer.valueOf(82));
        step1.setBeanName(defaultBeanName);
        step1.setMethodName("initTenantPermissionData");
        step1.setMethodDesc("\u79df\u6237\u5e93\u63d2\u5165\u6743\u9650\u6570\u636e");
        Class[] initTenantPermissionDataParamClass = new Class[]{String.class};
        step1.setParamClass(initTenantPermissionDataParamClass);
        result.add(step1);
        MiddleStep step2 = new MiddleStep();
        step2.setStepNo(Integer.valueOf(83));
        step2.setBeanName(defaultBeanName);
        step2.setMethodName("initTenantAdmin");
        step2.setMethodDesc("\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458");
        Class[] initTenantAdminParamClass = new Class[]{String.class, SolitarydomainTenant.class};
        step2.setParamClass(initTenantAdminParamClass);
        result.add(step2);
        MiddleStep step3 = new MiddleStep();
        step3.setStepNo(Integer.valueOf(84));
        step3.setMethodTag("initTenantAdminRole");
        step3.setBeanName(defaultBeanName);
        step3.setMethodName("initTenantAdminRole");
        step3.setMethodDesc("\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u89d2\u8272");
        Class[] initTenantAdminRoleParamClass = new Class[]{String.class, Long.class};
        step3.setParamClass(initTenantAdminRoleParamClass);
        result.add(step3);
        MiddleStep step4 = new MiddleStep();
        step4.setStepNo(Integer.valueOf(86));
        step4.setBeanName(defaultBeanName);
        step4.setMethodName("initClientInfo");
        step4.setMethodDesc("\u521d\u59cb\u5316\u79df\u6237\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f");
        Class[] initClientInfoParamClass = new Class[]{String.class, SolitarydomainTenant.class};
        step4.setParamClass(initClientInfoParamClass);
        result.add(step4);
        return result;
    }

    protected void executeStepFail(int stepNo, SolitarydomainTenant solitarydomainTenant, List<TenantDbModel> tenantDbModelList) {
    }

    protected void executeStepSuccess(int stepNo, SolitarydomainTenant solitarydomainTenant, List<TenantDbModel> tenantDbModelList) {
    }

    protected boolean canExecute(int stepNo, SolitarydomainTenant solitarydomainTenant, List<TenantDbModel> tenantDbModelList) {
        return true;
    }

    protected Object[] getParamValues(int stepNo, SolitarydomainTenant solitarydomainTenant, List<TenantDbModel> tenantDbModelList) {
        String connName = solitarydomainTenant.getConnName();
        if (82 == stepNo) {
            Object[] arr = new Object[]{connName};
            return arr;
        }
        if (83 == stepNo || 86 == stepNo) {
            Object[] arr = new Object[]{connName, solitarydomainTenant};
            return arr;
        }
        if (84 == stepNo) {
            Long userId = solitarydomainTenant.getTenantAdminId();
            Object[] arr = new Object[]{connName, userId};
            return arr;
        }
        return new Object[0];
    }

    protected void checkEditTenant(SolitarydomainTenant solitarydomainTenant) {
    }

    protected void updateSpecificData(SolitarydomainTenant solitarydomainTenant, Collection<String> serviceNames, List<TenantDbModel> tenantDbModelList) {
    }

    protected void deleteSpecificData(SysTenant tenant) {
        if (tenant == null) {
            return;
        }
        String connName = tenant.getConnName();
        try {
            String currentServiceName;
            List serviceList;
            LOGGER.info("\u5220\u9664\u79df\u6237\u6570\u636e\u6e90\u4fe1\u606f");
            LambdaQueryWrapper dswrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName)).eq(SysTenantDatasource::getDatasourceType, (Object)"1");
            SysTenantDatasource dsTemp = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)dswrapper);
            if (HussarUtils.isNotEmpty((Object)dsTemp)) {
                dsTemp.setDelFlag("1");
                this.sysTenantDataSourceService.updateById((Object)dsTemp);
            }
            this.dynamicDatasourceService.removeDynamicDatasource(connName);
            boolean microService = EnvironmentUtil.isMicroService();
            if (microService && HussarUtils.isNotEmpty((Object)(serviceList = this.sysTenantRegisterService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantRegister::getServiceName, (Object)(currentServiceName = EnvironmentUtil.getServiceName((boolean)true))))))) {
                for (SysTenantRegister temp : serviceList) {
                    ((IOutSideDeleteDataSourceService)SpringContextHolder.getBean(IOutSideDeleteDataSourceService.class)).doDeleteDataSource(connName, temp.getServiceName());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79df\u6237\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    @HussarTransactional
    public void saveTenant(SolitarydomainTenant solitaryTenant) {
        SysTenant tenant = TenantUtil.convert2SysTenant((HussarTenantDefinition)solitaryTenant);
        this.sysTenantService.saveOrUpdate((Object)tenant);
    }

    public void checkBaseTenantProperty(SolitarydomainTenant solitarydomainTenant) {
        String domain = solitarydomainTenant.getTenantDomain();
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            AssertUtil.isTrue((boolean)DomainValidator.getInstance().isValid(domain), (String)"\u975e\u6cd5\u57df\u540d\uff01");
            Optional<SysTenant> anyDomain = this.tenantService.list().stream().filter(item -> item.getTenantDomain().equalsIgnoreCase(domain)).findAny();
            if (anyDomain.isPresent()) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u79df\u6237\u7ed1\u5b9a\u57df\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            }
        }
    }
}

