/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.domain.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.impl.AbstractHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.domain.dao.SysTenantDomainMapper;
import com.jxdinfo.hussar.tenant.domain.model.SolitarydomainTenant;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.domain.service.impl.hussarBaseSolitarydomainTenantServiceImpl")
public class HussarBaseSolitarydomainTenantServiceImpl
extends AbstractHussarBaseTenantService<SolitarydomainTenant> {
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantDomainMapper sysTenantDomainMapper;

    public Page<SolitarydomainTenant> searchTenant(QueryTenantDto queryTenantDto) {
        Page page = new Page(queryTenantDto.getCurrent(), queryTenantDto.getSize());
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("tenantCode", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantCode()));
        queryOrgParams.put("tenantName", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantName()));
        queryOrgParams.put("tenantDomain", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantDomain()));
        queryOrgParams.put("tenantStatus", queryTenantDto.getTenantStatus());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        this.updateTenantStatus();
        List<SolitarydomainTenant> solitarydomainTenants = this.sysTenantDomainMapper.searchSolitarydomainTenant(page, queryOrgParams);
        page.setRecords(solitarydomainTenants);
        return page;
    }

    public SolitarydomainTenant findTenantById(Long tenantId) {
        HussarTenantDefinition tenantByTenantId = this.getTenantByTenantId(tenantId);
        return (SolitarydomainTenant)TenantUtil.convert((HussarTenantDefinition)tenantByTenantId, SolitarydomainTenant.class);
    }

    @HussarTransactional
    public void initTenantAdmin(String connName, SolitarydomainTenant solitaryTenant) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setUserName(solitaryTenant.getLinkman());
        sysUsers.setMobile(solitaryTenant.getContactNumber());
        sysUsers.setUserAccount(solitaryTenant.getUserAccount());
        TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
        String encodeSecure = TenantUtil.getEncodeSecure((String)solitaryTenant.getSecure());
        sysUsers.setPassword(encodeSecure);
        Integer userOrder = this.usersService.getUserMaxOrder();
        userOrder = HussarUtils.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        sysUsers.setUserOrder(userOrder);
        this.usersService.save(connName, (Object)sysUsers);
        solitaryTenant.setTenantAdminId(sysUsers.getId());
    }

    @HussarTransactional
    public void saveTenant(SolitarydomainTenant solitaryTenant) {
        SysTenant tenant = TenantUtil.convert2SysTenant((HussarTenantDefinition)solitaryTenant);
        this.sysTenantService.saveOrUpdate((Object)tenant);
    }
}

