/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.domain.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDeveloper;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDeveloperService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.impl.AbstractHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.domain.dao.SysTenantDomainMapper;
import com.jxdinfo.hussar.tenant.domain.model.SolitarydomainTenant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.domain.service.impl.hussarBaseSolitarydomainTenantServiceImpl")
public class HussarBaseSolitarydomainTenantServiceImpl
extends AbstractHussarBaseTenantService<SolitarydomainTenant> {
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantDomainMapper sysTenantDomainMapper;
    @Autowired
    private ISysTenantDeveloperService tenantDelegateUserService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;

    public Page<SolitarydomainTenant> searchTenant(QueryTenantDto queryTenantDto) {
        Page page = new Page(queryTenantDto.getCurrent(), queryTenantDto.getSize());
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("tenantCode", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantCode()));
        queryOrgParams.put("tenantName", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantName()));
        queryOrgParams.put("tenantDomain", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantDomain()));
        queryOrgParams.put("tenantStatus", queryTenantDto.getTenantStatus());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        this.updateTenantStatus();
        List<SolitarydomainTenant> solitarydomainTenants = this.sysTenantDomainMapper.searchSolitarydomainTenant(page, queryOrgParams);
        page.setRecords(solitarydomainTenants);
        return page;
    }

    public SolitarydomainTenant findTenantById(Long tenantId) {
        HussarTenantDefinition tenantByTenantId = this.getTenantByTenantId(tenantId);
        return (SolitarydomainTenant)TenantUtil.convert((HussarTenantDefinition)tenantByTenantId, SolitarydomainTenant.class);
    }

    @HussarTransactional
    public void initTenantAdmin(String connName, SolitarydomainTenant solitaryTenant) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(TenantConstant.ADMIN_USER);
        sysUsers.setUserName(solitaryTenant.getLinkman());
        sysUsers.setMobile(solitaryTenant.getContactNumber());
        sysUsers.setUserAccount(solitaryTenant.getUserAccount());
        TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
        String encodeSecure = TenantUtil.getEncodeSecure((String)solitaryTenant.getSecure());
        sysUsers.setPassword(encodeSecure);
        this.usersService.save(connName, (Object)sysUsers);
        solitaryTenant.setTenantAdminId(sysUsers.getId());
        SysTenant sysTenant1 = (SysTenant)this.sysTenantService.getById((Serializable)solitaryTenant.getTenantId());
        SysUsers nowUser = this.sysUsersService.getById(sysTenant1.getUserId());
        ArrayList<SysTenantDeveloper> addList = new ArrayList<SysTenantDeveloper>();
        SysTenantDeveloper tenantDelegateUser = new SysTenantDeveloper();
        tenantDelegateUser.setUserId(nowUser.getId());
        tenantDelegateUser.setTenantId(solitaryTenant.getTenantId());
        addList.add(tenantDelegateUser);
        this.tenantDelegateUserService.saveBatch(addList);
        ArrayList<SysUsers> tenantUsers = new ArrayList<SysUsers>();
        SysUsers adminUser = new SysUsers();
        adminUser.setId(nowUser.getId());
        adminUser.setUserName(nowUser.getUserName());
        adminUser.setMobile(nowUser.getMobile());
        adminUser.setUserAccount(nowUser.getUserAccount());
        adminUser.setAccountStatus(UserStatus.OK.getCode());
        adminUser.setIsCpublic("0");
        adminUser.setTypeProperty("1");
        adminUser.setSecurityLevel(Integer.valueOf(3));
        adminUser.setMaxSessions(Integer.valueOf(-1));
        adminUser.setCorporationId(Long.valueOf(12L));
        adminUser.setDepartmentId(Long.valueOf(12L));
        adminUser.setIsSys("1");
        adminUser.setLoginIpLimit("0");
        adminUser.setLoginTimeLimit("0");
        String adminEncodeSecure = TenantUtil.getEncodeSecure((String)"123456");
        adminUser.setPassword(adminEncodeSecure);
        tenantUsers.add(adminUser);
        this.sysUsersService.saveBatch(connName, tenantUsers);
        ArrayList<SysUserRole> tenantUserRoles = new ArrayList<SysUserRole>();
        SysUserRole sysUserRole1 = new SysUserRole();
        sysUserRole1.setUserId(nowUser.getId());
        sysUserRole1.setGrantedRole(SysUserAndRole.TENANT_ADMIN_ROLE.getValue());
        sysUserRole1.setAdminOption(UserRoleStatus.OK.getCode());
        tenantUserRoles.add(sysUserRole1);
        SysUserRole sysUserRole2 = new SysUserRole();
        sysUserRole2.setUserId(nowUser.getId());
        sysUserRole2.setGrantedRole(SysUserAndRole.DEVELOP_ROLE.getValue());
        sysUserRole2.setAdminOption(UserRoleStatus.OK.getCode());
        tenantUserRoles.add(sysUserRole2);
        this.sysUserRoleService.saveBatch(connName, tenantUserRoles);
    }

    @HussarTransactional
    public void saveTenant(SolitarydomainTenant solitaryTenant) {
        SysTenant tenant = TenantUtil.convert2SysTenant((HussarTenantDefinition)solitaryTenant);
        this.sysTenantService.saveOrUpdate((Object)tenant);
    }
}

