/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.domain.service.impl;

import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideModuleService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideSolitarydomainTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.domain.model.SolitarydomainTenant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.domain.service.impl.OutSideSolitarydomainTenantServiceImpl")
public class OutSideSolitarydomainTenantServiceImpl
implements IOutSideSolitarydomainTenantService {
    @Resource
    private ISysTenantService sysTenantService;
    @Resource
    private IHussarBaseTenantService<SolitarydomainTenant> hussarBaseTenantService;

    public void addSolitaryTenant(String appName, String domainName, String userName) {
        SolitarydomainTenant tenant = new SolitarydomainTenant();
        String tenantCode = this.generateTenantCode(appName, userName);
        tenant.setTenantCode(tenantCode);
        tenant.setTenantName(tenantCode);
        tenant.setTenantDomain(domainName);
        tenant.setLinkman(userName);
        tenant.setUserAccount(userName);
        tenant.setSecure("123456");
        tenant.setConnName(tenantCode);
        tenant.setServiceName(appName);
        IOutSideModuleService outSideModuleService = (IOutSideModuleService)SpringContextHolder.getBean(IOutSideModuleService.class);
        ApiResponse apiResponse = outSideModuleService.getModules(appName);
        List moduleList = (List)apiResponse.getData();
        if (HussarUtils.isEmpty((Object)moduleList)) {
            AssertUtil.isNotNull((Object)moduleList, (String)"\u672a\u914d\u7f6e\u521b\u5efa\u79df\u6237\u7684\u670d\u52a1\u6a21\u5757\uff0c\u8bf7\u68c0\u67e5!");
        }
        ArrayList storagePropertiesList = new ArrayList();
        for (String moduleName : moduleList) {
            HashMap<String, Object> storageProperties = new HashMap<String, Object>();
            storageProperties.put("serviceName", moduleName);
            storageProperties.put("creation", "1");
            storageProperties.put("storageType", "rdb");
            storageProperties.put("dbType", "a");
            storageProperties.put("isShowConfig", true);
            storageProperties.put("dbNameShow", true);
            storageProperties.put("exampleShow", false);
            storageProperties.put("patternShow", false);
            storageProperties.put("isShowPwd", false);
            storageProperties.put("testLoading", false);
            if (moduleName.contains("-")) {
                moduleName = moduleName.substring(moduleName.lastIndexOf("-") + 1);
            }
            storageProperties.put("connName", tenantCode + "_" + moduleName);
            storagePropertiesList.add(storageProperties);
        }
        tenant.setStoragePropertiesList(storagePropertiesList);
        this.hussarBaseTenantService.addTenant((Object)tenant);
    }

    private String generateTenantCode(String appName, String userName) {
        String tenantCode = userName + "-" + appName;
        List list = this.sysTenantService.getTenantByTcode(tenantCode);
        if (HussarUtils.isEmpty((Object)list)) {
            return tenantCode;
        }
        SysTenant sysTenant = (SysTenant)list.get(0);
        String tCode = sysTenant.getTenantCode();
        if (tCode.endsWith(appName)) {
            tenantCode = tCode + "-1";
        } else {
            String number = tCode.substring(tCode.lastIndexOf("-") + 1);
            int num = Integer.parseInt(number) + 1;
            tenantCode = tenantCode + "-" + num;
        }
        return tenantCode;
    }
}

