/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.domain.service.impl;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.IOutSideImportData2TenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.impl.AbstractHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.tenant.domain.dao.SysTenantDomainMapper;
import com.jxdinfo.hussar.tenant.domain.model.SolitarydomainTenant;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.domain.service.impl.hussarBaseSolitarydomainTenantServiceImpl")
public class HussarBaseSolitarydomainTenantServiceImpl
extends AbstractHussarBaseTenantService<SolitarydomainTenant> {
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysTenantService sysTenantService;
    @Resource
    private SysTenantDomainMapper sysTenantDomainMapper;

    public Page<SolitarydomainTenant> searchTenant(QueryTenantDto queryTenantDto) {
        Page page = new Page(queryTenantDto.getCurrent(), queryTenantDto.getSize());
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("tenantCode", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantCode()));
        queryOrgParams.put("tenantName", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantName()));
        queryOrgParams.put("tenantDomain", SqlQueryUtil.transferSpecialChar((String)queryTenantDto.getTenantDomain()));
        queryOrgParams.put("tenantStatus", queryTenantDto.getTenantStatus());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        this.updateTenantStatus();
        List<SolitarydomainTenant> solitarydomainTenants = this.sysTenantDomainMapper.searchSolitarydomainTenant(page, queryOrgParams);
        page.setRecords(solitarydomainTenants);
        return page;
    }

    public SolitarydomainTenant findTenantById(Long tenantId) {
        HussarTenantDefinition tenantByTenantId = this.getTenantByTenantId(tenantId);
        return (SolitarydomainTenant)TenantUtil.convert((HussarTenantDefinition)tenantByTenantId, SolitarydomainTenant.class);
    }

    @HussarTransactional
    public void initTenantAdmin(String connName, SolitarydomainTenant solitaryTenant) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(TenantConstant.ADMIN_USER);
        sysUsers.setUserName(solitaryTenant.getLinkman());
        sysUsers.setMobile(solitaryTenant.getContactNumber());
        sysUsers.setUserAccount(solitaryTenant.getUserAccount());
        TenantUtil.setDefaultUserFields((SysUsers)sysUsers);
        String encodeSecure = TenantUtil.getEncodeSecure((String)solitaryTenant.getSecure());
        sysUsers.setPassword(encodeSecure);
        this.usersService.save(connName, (Object)sysUsers);
        solitaryTenant.setTenantAdminId(sysUsers.getId());
    }

    public void afterAddTenant(SolitarydomainTenant solitarydomainTenant) {
        String serviceName = solitarydomainTenant.getServiceName();
        if (HussarUtils.isNotEmpty((Object)serviceName)) {
            String tenantDomain = solitarydomainTenant.getTenantDomain();
            String webServiceIp = ((NacosDiscoveryProperties)SpringContextHolder.getBean(NacosDiscoveryProperties.class)).getIp();
            IOutSideImportData2TenantService outSideImportData2TenantService = (IOutSideImportData2TenantService)SpringContextHolder.getBean(IOutSideImportData2TenantService.class);
            AssertUtil.isNotNull((Object)outSideImportData2TenantService, (String)"\u83b7\u53d6IOutSideGetDataFileService\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f15\u5165hussar-tenant-outside\u5305\uff01");
            Boolean res = (Boolean)outSideImportData2TenantService.importData2Tenant(serviceName, tenantDomain).getData();
            if (!res.booleanValue()) {
                throw new BaseException(serviceName + "\u5e94\u7528\u5bfc\u5165\u6570\u636e\u5230\u79df\u6237\u5e93\u5931\u8d25");
            }
        }
    }

    @HussarTransactional
    public void saveTenant(SolitarydomainTenant solitaryTenant) {
        SysTenant tenant = TenantUtil.convert2SysTenant((HussarTenantDefinition)solitaryTenant);
        this.sysTenantService.saveOrUpdate((Object)tenant);
    }
}

