/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.domain.service.feign.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import com.jxdinfo.hussar.tenant.domain.model.SolitarydomainTenant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@DependsOn(value={"springContextHolder"})
@Service(value="com.jxdinfo.hussar.tenant.domain.service.feign.impl.remoteDomainTenantTypeParseServiceImpl")
public class RemoteDomainTenantTypeParseServiceImpl
implements IHussarTenantCommonService {
    @Lazy
    @Autowired(required=false)
    private ISysTenantService tenantService;
    @Autowired
    private IHussarBaseTenantService<SolitarydomainTenant> solitarydomainTenantService;

    public HussarTenantDefinition parse() {
        String domain = TenantCommonUtil.getTenantCodeByDomain();
        if (!TenantCommonUtil.isLocal((String)domain)) {
            return this.search(domain);
        }
        return new DefaultTenant();
    }

    public HussarTenantDefinition search(String domain) {
        HussarTenantDefinition tenantByDomain = TenantCacheUtil.loadFromCacheByDomain((String)domain);
        if (HussarUtils.isEmpty((Object)tenantByDomain) && HussarUtils.isEmpty((Object)(tenantByDomain = this.tenantService.getTenantByDomain(domain)))) {
            return new DefaultTenant();
        }
        return tenantByDomain;
    }
}

