/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.domain.service.feign.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import com.jxdinfo.hussar.tenant.domain.model.SolitarydomainTenant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@HussarTokenDs
@DependsOn(value={"springContextHolder"})
@Service(value="com.jxdinfo.hussar.tenant.domain.service.feign.impl.remoteDomainTenantTypeParseServiceImpl")
public class RemoteDomainTenantTypeParseServiceImpl
implements IHussarTenantCommonService {
    @Autowired
    private ISysTenantService tenantService;
    @Autowired
    private IHussarBaseTenantService<SolitarydomainTenant> solitarydomainTenantService;

    public HussarTenantDefinition parse() {
        String domain = TenantCommonUtil.getTenantCodeByDomain();
        if (!TenantCommonUtil.isLocal((String)domain)) {
            return this.search(domain);
        }
        return new DefaultTenant();
    }

    private HussarTenantDefinition search(String domain) {
        HussarTenantDefinition tenantByDomain = TenantCacheUtil.loadFromCacheByDomain((String)domain);
        if (HussarUtils.isEmpty((Object)tenantByDomain)) {
            SysTenant tenant = (SysTenant)this.tenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantDomain, (Object)domain));
            if (HussarUtils.isEmpty((Object)tenant)) {
                throw new BaseException("\u672a\u67e5\u8be2\u5230\u79df\u6237\u57df\u540d\u4fe1\u606f:" + domain);
            }
            Long tenantId = tenant.getId();
            tenantByDomain = this.solitarydomainTenantService.getTenantByTenantId(tenantId);
        }
        return tenantByDomain;
    }
}

