/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TenantCacheUtil {
    private TenantCacheUtil() {
    }

    @Deprecated
    public static HussarTenantDefinition loadFromCacheByTenantId(Long tenantId) {
        if (!TenantCacheUtil.openTenant()) {
            return null;
        }
        if (tenantId == null) {
            return null;
        }
        String cacheName = "tenant_info";
        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
        if (HussarUtils.isNotEmpty((Object)cacheKeys)) {
            for (String cacheKey : cacheKeys) {
                HussarTenantDefinition definition = (HussarTenantDefinition)((Object)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey));
                if (!Objects.equals(definition.getTenantId(), tenantId)) continue;
                return definition;
            }
        }
        return null;
    }

    public static HussarTenantDefinition loadFromCacheByTenantCode(String tenantCode) {
        if (!TenantCacheUtil.openTenant()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        String cacheName = "tenant_info";
        HussarTenantDefinition definition = (HussarTenantDefinition)((Object)HussarFixedCacheUtil.get((String)cacheName, (Object)tenantCode));
        return definition;
    }

    public static List<HussarTenantDefinition> loadFromCacheByTenantCodes(List<String> tenantCode) {
        if (!TenantCacheUtil.openTenant()) {
            return new ArrayList<HussarTenantDefinition>();
        }
        String cacheName = "tenant_info";
        ArrayList<HussarTenantDefinition> list = new ArrayList<HussarTenantDefinition>();
        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
        for (String cacheKey : cacheKeys) {
            String tenantCodeFromCache;
            HussarTenantDefinition definition = (HussarTenantDefinition)((Object)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey));
            if (!HussarUtils.isNotEmpty((Object)((Object)definition)) || !tenantCode.contains(tenantCodeFromCache = StringUtils.trimToEmpty((String)definition.getTenantCode()))) continue;
            list.add(definition);
        }
        return list;
    }

    public static HussarTenantDefinition loadFromCacheByDomain(String domain) {
        if (!TenantCacheUtil.openTenant()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)domain)) {
            return null;
        }
        String cacheName = "tenant_info";
        HussarTenantDefinition definition = (HussarTenantDefinition)((Object)HussarFixedCacheUtil.get((String)cacheName, (Object)domain));
        return definition;
    }

    public static Map<String, Object> loadDatasourceFromCache(String tenantCode, String serviceName) {
        if (!TenantCacheUtil.openTenant() || StringUtils.isBlank((CharSequence)tenantCode)) {
            return new HashMap<String, Object>();
        }
        String cacheName = "tenant_datasource_info";
        Map map = (Map)HussarFixedCacheUtil.get((String)cacheName, (Object)(tenantCode + ":" + serviceName));
        return map;
    }

    public static void putTenat2Cache(HussarTenantDefinition hussarTenatDefinition) {
        if (TenantCacheUtil.openTenant() && HussarUtils.isNotEmpty((Object)((Object)hussarTenatDefinition))) {
            String cacheName = "tenant_info";
            String domain = hussarTenatDefinition.getTenantDomain();
            String tenantCode = hussarTenatDefinition.getTenantCode();
            String key = null;
            if (StringUtils.isNotBlank((CharSequence)domain)) {
                key = domain.trim();
            } else if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
                key = tenantCode.trim();
            } else {
                throw new BaseException("\u79df\u6237\u7f16\u7801\u6216\u79df\u6237\u57df\u540d\u4e3a\u7a7a");
            }
            HussarFixedCacheUtil.put((String)cacheName, (Object)key, (Object)((Object)hussarTenatDefinition));
        }
    }

    public static void putTenantDataSourceCacheBatch(HussarTenantDefinition hussarTenatDefinition) {
        if (TenantCacheUtil.openTenant() && HussarUtils.isNotEmpty((Object)((Object)hussarTenatDefinition))) {
            List<Map<String, Object>> propertiesList = hussarTenatDefinition.getStoragePropertiesList();
            if (HussarUtils.isEmpty(propertiesList)) {
                return;
            }
            String cacheName = "tenant_datasource_info";
            String tenantCode = hussarTenatDefinition.getTenantCode();
            for (Map<String, Object> storageProperties : propertiesList) {
                String serviceName = (String)storageProperties.get("serviceName");
                serviceName = HussarUtils.isBlank((CharSequence)serviceName) ? "single" : serviceName;
                String cacheKey = tenantCode + ":" + serviceName;
                Map<String, Object> storage = TenantCacheUtil.loadDatasourceFromCache(tenantCode, cacheKey);
                if (HussarUtils.isNotEmpty(storage)) {
                    HussarFixedCacheUtil.evict((String)cacheName, (Object)cacheKey);
                }
                HussarFixedCacheUtil.put((String)cacheName, (Object)cacheKey, storageProperties);
            }
        }
    }

    public static void putTenantDataSourceCache(String tenantCode, Map<String, Object> storageProperties) {
        if (TenantCacheUtil.openTenant() && HussarUtils.isNotEmpty(storageProperties)) {
            String cacheKey;
            Map<String, Object> storage;
            String cacheName = "tenant_datasource_info";
            boolean microService = EnvironmentUtil.isMicroService();
            String suffix = "single";
            if (microService) {
                suffix = (String)storageProperties.get("serviceName");
            }
            if (HussarUtils.isNotEmpty(storage = TenantCacheUtil.loadDatasourceFromCache(tenantCode, cacheKey = tenantCode + ":" + suffix))) {
                HussarFixedCacheUtil.evict((String)cacheName, (Object)cacheKey);
            }
            HussarFixedCacheUtil.put((String)cacheName, (Object)cacheKey, storageProperties);
        }
    }

    public static void clearTenantDatasourceCache(Long tenantId, String serviceName) {
        if (TenantCacheUtil.openTenant()) {
            String cacheName = "tenant_datasource_info";
            serviceName = HussarUtils.isBlank((CharSequence)serviceName) ? "single" : serviceName;
            String cacheKey = tenantId + ":" + serviceName;
            HussarFixedCacheUtil.evict((String)cacheName, (Object)cacheKey);
        }
    }

    public static void clearTenantCache() {
        if (TenantCacheUtil.openTenant()) {
            String cacheName = "tenant_info";
            List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
            for (String cacheKey : cacheKeys) {
                HussarFixedCacheUtil.evict((String)cacheName, (Object)cacheKey);
            }
        }
    }

    public static boolean openTenant() {
        return ((HussarTenantProperties)SpringContextHolder.getBean(HussarTenantProperties.class)).isEnabled();
    }
}

