/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.jdbc.datasource.init.ScriptStatementFailedException;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.jdbc.datasource.init.UncategorizedScriptException;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class TenantUpgradeScriptUtils {
    public static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    public static final String FALLBACK_STATEMENT_SEPARATOR = "\n";
    public static final String EOF_STATEMENT_SEPARATOR = "^^^ END OF SCRIPT ^^^";
    public static final String DEFAULT_COMMENT_PREFIX = "--";
    public static final String[] DEFAULT_COMMENT_PREFIXES = new String[]{"--"};
    public static final String DEFAULT_BLOCK_COMMENT_START_DELIMITER = "/*";
    public static final String DEFAULT_BLOCK_COMMENT_END_DELIMITER = "*/";
    private static final Logger logger = LoggerFactory.getLogger(TenantUpgradeScriptUtils.class);

    private TenantUpgradeScriptUtils() {
    }

    public static void executeSqlScript(Connection connection, String dbType, Resource resource) throws ScriptException {
        TenantUpgradeScriptUtils.executeSqlScript(connection, dbType, new EncodedResource(resource));
    }

    public static void executeSqlScript(Connection connection, String dbType, EncodedResource resource) throws ScriptException {
        TenantUpgradeScriptUtils.executeSqlScript(connection, dbType, resource, false, false);
    }

    public static void executeSqlScript(Connection connection, String dbType, EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops) throws ScriptException {
        try {
            List statements = DatabaseFactory.get((String)dbType).preTreatment(connection, resource.getResource(), true);
            int stmtNumber = 0;
            try (Statement stmt = connection.createStatement();){
                for (String statement : statements) {
                    TenantUpgradeScriptUtils.execSql(resource, continueOnError, ignoreFailedDrops, ++stmtNumber, stmt, statement);
                }
            }
        }
        catch (ScriptException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UncategorizedScriptException("Failed to execute database script from resource [" + resource + "]", (Throwable)ex);
        }
    }

    private static void execSql(EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops, int stmtNumber, Statement stmt, String statement) {
        try {
            stmt.execute(statement);
        }
        catch (SQLException ex) {
            boolean dropStatement = StringUtils.startsWithIgnoreCase((String)statement.trim(), (String)"drop");
            if (continueOnError || dropStatement && ignoreFailedDrops) {
                if (logger.isDebugEnabled()) {
                    logger.debug(ScriptStatementFailedException.buildErrorMessage((String)statement, (int)stmtNumber, (EncodedResource)resource), (Throwable)ex);
                }
            }
            throw new ScriptStatementFailedException(statement, stmtNumber, resource, (Throwable)ex);
        }
    }

    static String readScript(EncodedResource resource, @Nullable String separator, String[] commentPrefixes, String blockCommentEndDelimiter) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(resource.getReader());){
            String string = TenantUpgradeScriptUtils.readScript(lnr, commentPrefixes, separator, blockCommentEndDelimiter);
            return string;
        }
    }

    public static String readScript(LineNumberReader lineNumberReader, @Nullable String commentPrefix, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        String[] stringArray;
        if (commentPrefix != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = commentPrefix;
        } else {
            stringArray = null;
        }
        String[] commentPrefixes = stringArray;
        return TenantUpgradeScriptUtils.readScript(lineNumberReader, commentPrefixes, separator, blockCommentEndDelimiter);
    }

    public static String readScript(LineNumberReader lineNumberReader, @Nullable String[] commentPrefixes, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (blockCommentEndDelimiter != null && currentStatement.contains(blockCommentEndDelimiter) || commentPrefixes != null && !TenantUpgradeScriptUtils.startsWithAny(currentStatement, commentPrefixes, 0)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        TenantUpgradeScriptUtils.appendSeparatorToScriptIfNecessary(scriptBuilder, separator);
        return scriptBuilder.toString();
    }

    private static void appendSeparatorToScriptIfNecessary(StringBuilder scriptBuilder, @Nullable String separator) {
        if (separator == null) {
            return;
        }
        String trimmed = separator.trim();
        if (trimmed.length() == separator.length()) {
            return;
        }
        if (scriptBuilder.lastIndexOf(trimmed) == scriptBuilder.length() - trimmed.length()) {
            scriptBuilder.append(separator.substring(trimmed.length()));
        }
    }

    public static boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            char c = script.charAt(i);
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            if (c == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(delim, i)) continue;
            return true;
        }
        return false;
    }

    public static void splitSqlScript(String script, char separator, List<String> statements) throws ScriptException {
        TenantUpgradeScriptUtils.splitSqlScript(script, String.valueOf(separator), statements);
    }

    public static void splitSqlScript(String script, String separator, List<String> statements) throws ScriptException {
        TenantUpgradeScriptUtils.splitSqlScript(null, script, separator, new String[]{DEFAULT_COMMENT_PREFIX}, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER, statements);
    }

    public static void splitSqlScript(@Nullable EncodedResource resource, String script, String separator, String[] commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) throws ScriptException {
        ScriptUtils.splitSqlScript((EncodedResource)resource, (String)script, (String)separator, (String[])commentPrefix, (String)blockCommentStartDelimiter, (String)blockCommentEndDelimiter, statements);
    }

    private static boolean startsWithAny(String script, String[] prefixes, int offset) {
        for (String prefix : prefixes) {
            if (!script.startsWith(prefix, offset)) continue;
            return true;
        }
        return false;
    }
}

