/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TenantCommonUtil {
    private TenantCommonUtil() {
    }

    public static String getTenantCodeByUrl() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        String hussarCodeKey = "tcode";
        String tcode = "";
        tcode = request.getParameter(hussarCodeKey);
        if (HussarUtils.isBlank((CharSequence)tcode)) {
            tcode = request.getHeader(hussarCodeKey);
        }
        return tcode;
    }

    public static boolean isLocal(String serverName) {
        return HussarUtils.isBlank((CharSequence)serverName) || serverName.contains("127.0.0.1") || serverName.contains("localhost");
    }

    public static String getTenantCodeByDomain() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        String hussarCodeKey = "domain";
        String domain = request.getHeader(hussarCodeKey);
        return domain;
    }
}

