/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.factory;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.service.IStorageExecutorService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageFactory.class);
    private static Map<String, IStorageExecutorService> map = new ConcurrentHashMap<String, IStorageExecutorService>();

    private StorageFactory() {
    }

    public static void add(String type, IStorageExecutorService operateService) {
        map.put(type, operateService);
    }

    public static IStorageExecutorService get(String type) {
        LOGGER.info(type);
        if (HussarUtils.isEmpty(map)) {
            throw new BaseException("\u672a\u53d1\u73b0type=[" + type + "]\u7684IStorageExecutorService\u5b9e\u73b0\u7c7b\uff01");
        }
        IStorageExecutorService databaseOperateService = map.get(type);
        AssertUtil.isNotNull((Object)databaseOperateService, (String)"\u6ca1\u6709\u627e\u5230\u8be5\u7c7b\u578b\u7684\u5b9e\u73b0\u7c7b");
        return databaseOperateService;
    }
}

