/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TenantCommonUtil {
    private TenantCommonUtil() {
    }

    public static String getTenantCodeByUrl() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (HussarUtils.isEmpty((Object)request)) {
            return null;
        }
        String hussarCodeKey = "tcode";
        String tcode = "";
        tcode = request.getParameter(hussarCodeKey);
        if (HussarUtils.isBlank((CharSequence)tcode)) {
            tcode = request.getHeader(hussarCodeKey);
        }
        return tcode;
    }

    public static boolean isLocal(String serverName) {
        return HussarUtils.isBlank((CharSequence)serverName) || serverName.contains("127.0.0.1") || serverName.contains("localhost");
    }

    public static String getTenantCodeByDomain() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (HussarUtils.isEmpty((Object)request)) {
            return null;
        }
        String hussarCodeKey = "domain";
        String domain = request.getHeader(hussarCodeKey);
        return domain;
    }

    public static String getCurrentServiceName() {
        if (EnvironmentUtil.isMicroService()) {
            return ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        }
        return "";
    }
}

