/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TenantCacheUtil {
    private TenantCacheUtil() {
    }

    public static HussarTenantDefinition loadFromCacheByTenantId(Long tenantId) {
        String cacheName = "tenant_info";
        return (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)tenantId);
    }

    public static HussarTenantDefinition loadFromCacheByTenantCode(String tenantCode) {
        String cacheName = "tenant_info";
        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
        if (HussarUtils.isNotEmpty((Object)cacheKeys)) {
            for (String cacheKey : cacheKeys) {
                HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
                String tenantCodeFromCache = StringUtils.trimToEmpty((String)definition.getTenantCode());
                if (!Objects.equals(tenantCode, tenantCodeFromCache)) continue;
                return definition;
            }
        }
        return null;
    }

    public static List<HussarTenantDefinition> loadFromCacheByTenantCodes(List<String> tenantCode) {
        String cacheName = "tenant_info";
        ArrayList<HussarTenantDefinition> list = new ArrayList<HussarTenantDefinition>();
        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
        for (String cacheKey : cacheKeys) {
            HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
            String tenantCodeFromCache = StringUtils.trimToEmpty((String)definition.getTenantCode());
            if (!tenantCode.contains(tenantCodeFromCache)) continue;
            list.add(definition);
        }
        return list;
    }

    public static HussarTenantDefinition loadFromCacheByDomain(String domain) {
        String cacheName = "tenant_info";
        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
        for (String cacheKey : cacheKeys) {
            HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
            String tenantCodeFromCache = StringUtils.trimToEmpty((String)definition.getTenantDomain());
            if (!Objects.equals(domain, tenantCodeFromCache)) continue;
            return definition;
        }
        return null;
    }

    public static void putTenat2Cache(HussarTenantDefinition hussarTenatDefinition) {
        if (HussarUtils.isNotEmpty((Object)hussarTenatDefinition)) {
            String cacheName = "tenant_info";
            Long tenantId = hussarTenatDefinition.getTenantId();
            HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantId(tenantId);
            if (HussarUtils.isNotEmpty((Object)definition)) {
                HussarFixedCacheUtil.evict((String)cacheName, (Object)tenantId);
            }
            HussarFixedCacheUtil.put((String)cacheName, (Object)tenantId, (Object)hussarTenatDefinition);
        }
    }

    public static void clearTenantCache() {
        String cacheName = "tenant_info";
        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
        for (String cacheKey : cacheKeys) {
            HussarFixedCacheUtil.evict((String)cacheName, (Object)cacheKey);
        }
    }
}

