/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.utils.HussarReflectionUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.service.IStorageExecutorService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.model.HussarMethod;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenantJobInfo;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import java.util.List;
import java.util.Map;
import org.springframework.core.env.Environment;

public class TenantLogUtil {
    private TenantLogUtil() {
    }

    public static SysTenantLog newCreateDbLog(Class entityClass, String tenantCode, String connName, String serviceName, Map<String, Object> masterstorageProperties) {
        SysTenantLog createDb = new SysTenantLog();
        createDb.setStepNo(StepConstants.CREATE_DB);
        createDb.setServiceName(serviceName);
        createDb.setMethodTag("createDb");
        createDb.setTenantCode(tenantCode);
        createDb.setBeanName(HussarReflectionUtils.getBeanName(((IStorageExecutorService)SpringContextHolder.getBean(IStorageExecutorService.class)).getClass()));
        createDb.setMethodName("createDatabaseAndInitData");
        createDb.setMethodDesc("\u521b\u5efa\u6570\u636e\u5b58\u50a8");
        createDb.setConnName(connName);
        Class[] paramClass = new Class[]{Map.class};
        Object[] paramValues = new Object[]{masterstorageProperties};
        createDb.setMethodParams(JSON.toJSONString((Object)new HussarMethod(entityClass, paramClass, paramValues)));
        createDb.setExecStatus(2);
        createDb.setErrorTimes(0);
        if (EnvironmentUtil.isMicroService() && HussarUtils.isBlank((CharSequence)serviceName)) {
            createDb.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        if (HussarUtils.isNotBlank((CharSequence)createDb.getServiceName())) {
            createDb.setMethodDesc("\u5fae\u670d\u52a1\uff1a" + createDb.getServiceName() + "\u521b\u5efa\u6570\u636e\u5b58\u50a8");
        }
        return createDb;
    }

    public static <T extends HussarTenantDefinition> SysTenantLog newBeforeAddTenantLog(T t) {
        SysTenantLog beforeAddTenantLog = new SysTenantLog();
        beforeAddTenantLog.setStepNo(StepConstants.BEFORE_ADD_TENANT);
        beforeAddTenantLog.setMethodTag("beforeAddTenant");
        beforeAddTenantLog.setTenantCode(t.getTenantCode());
        beforeAddTenantLog.setBeanName(HussarReflectionUtils.getBeanName(((IHussarBaseTenantService)SpringContextHolder.getBean(IHussarBaseTenantService.class)).getClass()));
        beforeAddTenantLog.setMethodName("beforeAddTenant");
        beforeAddTenantLog.setMethodDesc("\u524d\u7f6e\u64cd\u4f5c");
        beforeAddTenantLog.setConnName(t.getConnName());
        Class[] paramClass = new Class[]{t.getClass()};
        Object[] paramValues = new Object[]{t};
        beforeAddTenantLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(t.getClass(), paramClass, paramValues)));
        beforeAddTenantLog.setExecStatus(2);
        beforeAddTenantLog.setErrorTimes(0);
        if (EnvironmentUtil.isMicroService()) {
            beforeAddTenantLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return beforeAddTenantLog;
    }

    public static <T extends HussarTenantDefinition> SysTenantLog newInitTenantPermissionLog(T t) {
        SysTenantLog initTenantPermissionLog = new SysTenantLog();
        initTenantPermissionLog.setStepNo(StepConstants.INIT_TENANT_PERMISSION);
        initTenantPermissionLog.setMethodTag("initTenantPermissionData");
        initTenantPermissionLog.setTenantCode(t.getTenantCode());
        initTenantPermissionLog.setBeanName(HussarReflectionUtils.getBeanName(((IHussarBaseTenantService)SpringContextHolder.getBean(IHussarBaseTenantService.class)).getClass()));
        initTenantPermissionLog.setMethodName("initTenantPermissionData");
        initTenantPermissionLog.setMethodDesc("\u79df\u6237\u5e93\u63d2\u5165\u6743\u9650\u6570\u636e");
        initTenantPermissionLog.setConnName(t.getConnName());
        Class[] paramClass = new Class[]{String.class};
        Object[] paramValues = new Object[]{t.getConnName()};
        initTenantPermissionLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(t.getClass(), paramClass, paramValues)));
        initTenantPermissionLog.setExecStatus(2);
        initTenantPermissionLog.setErrorTimes(0);
        if (EnvironmentUtil.isMicroService()) {
            initTenantPermissionLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return initTenantPermissionLog;
    }

    public static <T extends HussarTenantDefinition> SysTenantLog initTenantAdminLog(T t) {
        SysTenantLog initTenantAdminLog = new SysTenantLog();
        initTenantAdminLog.setStepNo(StepConstants.INIT_TENANT_ADMIN);
        initTenantAdminLog.setMethodTag("initTenantAdmin");
        initTenantAdminLog.setTenantCode(t.getTenantCode());
        initTenantAdminLog.setBeanName(HussarReflectionUtils.getBeanName(((IHussarBaseTenantService)SpringContextHolder.getBean(IHussarBaseTenantService.class)).getClass()));
        initTenantAdminLog.setMethodName("initTenantAdmin");
        initTenantAdminLog.setMethodDesc("\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458");
        initTenantAdminLog.setConnName(t.getConnName());
        Class[] paramClass = new Class[]{String.class, t.getClass()};
        Object[] paramValues = new Object[]{t.getConnName(), t};
        initTenantAdminLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(t.getClass(), paramClass, paramValues)));
        initTenantAdminLog.setExecStatus(2);
        initTenantAdminLog.setErrorTimes(0);
        if (EnvironmentUtil.isMicroService()) {
            initTenantAdminLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return initTenantAdminLog;
    }

    public static <T extends HussarTenantDefinition> SysTenantLog newInitTenantAdminRoleLog(T t) {
        SysTenantLog initTenantAdminRoleLog = new SysTenantLog();
        initTenantAdminRoleLog.setStepNo(StepConstants.INIT_TENANT_ROLE);
        initTenantAdminRoleLog.setMethodTag("initTenantAdminRole");
        initTenantAdminRoleLog.setTenantCode(t.getTenantCode());
        initTenantAdminRoleLog.setBeanName("com.jxdinfo.hussar.authorization.permit.service.impl.sysUserRoleServiceImpl");
        initTenantAdminRoleLog.setMethodName("saveUserRole");
        initTenantAdminRoleLog.setMethodDesc("\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u89d2\u8272");
        initTenantAdminRoleLog.setConnName(t.getConnName());
        Class[] paramClass = new Class[]{String.class, Long.class};
        Object[] paramValues = new Object[]{t.getConnName(), t.getTenantAdminId()};
        initTenantAdminRoleLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(t.getClass(), paramClass, paramValues)));
        initTenantAdminRoleLog.setExecStatus(2);
        initTenantAdminRoleLog.setErrorTimes(0);
        if (EnvironmentUtil.isMicroService()) {
            initTenantAdminRoleLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return initTenantAdminRoleLog;
    }

    public static <T extends HussarTenantDefinition> SysTenantLog newInitClientInfoLog(T t) {
        SysTenantLog initClientInfoLog = new SysTenantLog();
        initClientInfoLog.setStepNo(StepConstants.INIT_CLIENT_INFO);
        initClientInfoLog.setMethodTag("initClientInfo");
        initClientInfoLog.setTenantCode(t.getTenantCode());
        initClientInfoLog.setBeanName(HussarReflectionUtils.getBeanName(((IHussarBaseTenantService)SpringContextHolder.getBean(IHussarBaseTenantService.class)).getClass()));
        initClientInfoLog.setMethodName("initClientInfo");
        initClientInfoLog.setMethodDesc("\u521d\u59cb\u5316\u79df\u6237\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f");
        initClientInfoLog.setConnName(t.getConnName());
        Class[] paramClass = new Class[]{String.class, HussarTenantDefinition.class};
        Object[] paramValues = new Object[]{t.getConnName(), t};
        initClientInfoLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(t.getClass(), paramClass, paramValues)));
        initClientInfoLog.setExecStatus(2);
        initClientInfoLog.setErrorTimes(0);
        if (EnvironmentUtil.isMicroService()) {
            initClientInfoLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return initClientInfoLog;
    }

    public static SysTenantLog newInitJobInfoLog(String tenantCode, String connName, List<SysTenantJobInfo> tenantJobInfoList) {
        SysTenantLog initJobInfoLog = new SysTenantLog();
        initJobInfoLog.setStepNo(StepConstants.INIT_JOB_INFO);
        initJobInfoLog.setMethodTag("initJobInfo");
        initJobInfoLog.setTenantCode(tenantCode);
        initJobInfoLog.setBeanName("com.jxdinfo.hussar.tenant.common.service.impl.sysTenantJobInfoServiceImpl");
        initJobInfoLog.setMethodName("saveBatch");
        initJobInfoLog.setMethodDesc("\u521d\u59cb\u5316\u79df\u6237\u5b9a\u65f6\u4efb\u52a1");
        initJobInfoLog.setConnName(connName);
        Class[] paramClass = new Class[]{String.class, List.class};
        Object[] paramValues = new Object[]{"master", tenantJobInfoList};
        initJobInfoLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(List.class, paramClass, paramValues)));
        initJobInfoLog.setExecStatus(2);
        initJobInfoLog.setErrorTimes(0);
        if (EnvironmentUtil.isMicroService()) {
            initJobInfoLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return initJobInfoLog;
    }

    public static <T extends HussarTenantDefinition> SysTenantLog newSaveTenantLog(T t) {
        SysTenantLog saveTenantLog = new SysTenantLog();
        saveTenantLog.setStepNo(StepConstants.SAVE_TENANT);
        saveTenantLog.setMethodTag("saveTenant");
        saveTenantLog.setTenantCode(t.getTenantCode());
        saveTenantLog.setBeanName(HussarReflectionUtils.getBeanName(((IHussarBaseTenantService)SpringContextHolder.getBean(IHussarBaseTenantService.class)).getClass()));
        saveTenantLog.setMethodName("saveTenant");
        saveTenantLog.setMethodDesc("\u4fdd\u5b58\u79df\u6237\u57fa\u672c\u4fe1\u606f");
        saveTenantLog.setConnName(t.getConnName());
        Class[] paramClass = new Class[]{t.getClass()};
        Object[] paramValues = new Object[]{t};
        saveTenantLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(t.getClass(), paramClass, paramValues)));
        saveTenantLog.setExecStatus(2);
        saveTenantLog.setErrorTimes(0);
        if (EnvironmentUtil.isMicroService()) {
            saveTenantLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return saveTenantLog;
    }

    public static <T extends HussarTenantDefinition> SysTenantLog newAfterAddTenantLog(T t) {
        SysTenantLog afterAddTenantLog = new SysTenantLog();
        afterAddTenantLog.setStepNo(StepConstants.AFTER_ADD_TENANT);
        afterAddTenantLog.setMethodTag("afterAddTenant");
        afterAddTenantLog.setTenantCode(t.getTenantCode());
        afterAddTenantLog.setBeanName(HussarReflectionUtils.getBeanName(((IHussarBaseTenantService)SpringContextHolder.getBean(IHussarBaseTenantService.class)).getClass()));
        afterAddTenantLog.setMethodName("afterAddTenant");
        afterAddTenantLog.setMethodDesc("\u540e\u7f6e\u64cd\u4f5c");
        afterAddTenantLog.setConnName(t.getConnName());
        Class[] paramClass = new Class[]{t.getClass()};
        Object[] paramValues = new Object[]{t};
        afterAddTenantLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(t.getClass(), paramClass, paramValues)));
        afterAddTenantLog.setExecStatus(2);
        afterAddTenantLog.setErrorTimes(0);
        if (EnvironmentUtil.isMicroService()) {
            afterAddTenantLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return afterAddTenantLog;
    }
}

