/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;

public class HussarContextHolder {
    private static TransmittableThreadLocal<HussarTenantDefinition> tenanThreadLocal = new TransmittableThreadLocal();

    public static final void setTenant(HussarTenantDefinition tenantEntity) {
        tenanThreadLocal.set((Object)tenantEntity);
    }

    public static final HussarTenantDefinition getHussarTenant() {
        HussarTenantDefinition tenantEntity = (HussarTenantDefinition)tenanThreadLocal.get();
        if (tenantEntity == null) {
            tenantEntity = new DefaultTenant();
        }
        return tenantEntity;
    }

    public static final String getConnName() {
        return HussarContextHolder.getHussarTenant().getConnName();
    }

    public static final void remove() {
        tenanThreadLocal.remove();
    }

    public static final void setTenant(String connName, String tenantCode) {
        if (HussarUtils.isNotBlank((CharSequence)connName) && HussarUtils.isNotBlank((CharSequence)tenantCode) && !connName.equals("master")) {
            HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantCode(tenantCode);
            if (HussarUtils.isNotEmpty((Object)definition)) {
                HussarContextHolder.setTenant(definition);
            } else {
                HussarContextHolder.setTenant(new DefaultTenant());
            }
        } else {
            HussarContextHolder.setTenant(new DefaultTenant());
        }
    }
}

