/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TenantCacheUtil {
    private TenantCacheUtil() {
    }

    public static HussarTenantDefinition loadFromCacheByTenantId(Long tenantId) {
        if (!TenantCacheUtil.openTenant()) {
            return null;
        }
        if (tenantId == null) {
            return null;
        }
        String cacheName = "tenant_info";
        return (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)tenantId);
    }

    public static HussarTenantDefinition loadFromCacheByTenantCode(String tenantCode) {
        if (!TenantCacheUtil.openTenant()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        String cacheName = "tenant_info";
        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
        if (HussarUtils.isNotEmpty((Object)cacheKeys)) {
            for (String cacheKey : cacheKeys) {
                String tenantCodeFromCache;
                HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
                if (!HussarUtils.isNotEmpty((Object)definition) || !Objects.equals(tenantCode, tenantCodeFromCache = StringUtils.trimToEmpty((String)definition.getTenantCode()))) continue;
                return definition;
            }
        }
        return null;
    }

    public static List<HussarTenantDefinition> loadFromCacheByTenantCodes(List<String> tenantCode) {
        if (!TenantCacheUtil.openTenant()) {
            return null;
        }
        String cacheName = "tenant_info";
        ArrayList<HussarTenantDefinition> list = new ArrayList<HussarTenantDefinition>();
        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
        for (String cacheKey : cacheKeys) {
            String tenantCodeFromCache;
            HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
            if (!HussarUtils.isNotEmpty((Object)definition) || !tenantCode.contains(tenantCodeFromCache = StringUtils.trimToEmpty((String)definition.getTenantCode()))) continue;
            list.add(definition);
        }
        return list;
    }

    public static HussarTenantDefinition loadFromCacheByDomain(String domain) {
        if (!TenantCacheUtil.openTenant()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)domain)) {
            return null;
        }
        String cacheName = "tenant_info";
        List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
        for (String cacheKey : cacheKeys) {
            String tenantCodeFromCache;
            HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
            if (!HussarUtils.isNotEmpty((Object)definition) || !Objects.equals(domain, tenantCodeFromCache = StringUtils.trimToEmpty((String)definition.getTenantDomain()))) continue;
            return definition;
        }
        return null;
    }

    public static void putTenat2Cache(HussarTenantDefinition hussarTenatDefinition) {
        if (TenantCacheUtil.openTenant() && HussarUtils.isNotEmpty((Object)hussarTenatDefinition)) {
            String cacheName = "tenant_info";
            Long tenantId = hussarTenatDefinition.getTenantId();
            HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantId(tenantId);
            if (HussarUtils.isNotEmpty((Object)definition)) {
                HussarFixedCacheUtil.evict((String)cacheName, (Object)tenantId);
            }
            HussarFixedCacheUtil.put((String)cacheName, (Object)tenantId, (Object)hussarTenatDefinition);
        }
    }

    public static void clearTenantCache() {
        if (TenantCacheUtil.openTenant()) {
            String cacheName = "tenant_info";
            List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
            for (String cacheKey : cacheKeys) {
                HussarFixedCacheUtil.evict((String)cacheName, (Object)cacheKey);
            }
        }
    }

    public static boolean openTenant() {
        return ((HussarTenantProperties)SpringContextHolder.getBean(HussarTenantProperties.class)).isEnabled();
    }
}

