/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.template.print.utils;

import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.template.print.enums.TemplateEnum;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class HeaderParser {
    public static Map<String, Integer> parseHeader(Sheet sheet) {
        LinkedHashMap<String, Integer> headerMap = new LinkedHashMap<String, Integer>();
        List mergedRegions = sheet.getMergedRegions();
        Row firstRow = sheet.getRow(0);
        if (firstRow == null) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.THE_EXCEL_HEADER_CANNOT_BE_EMPTY.getMessage()));
        }
        Row secondRow = sheet.getRow(1);
        for (Cell cell : firstRow) {
            String parentHeader = cell.getStringCellValue().trim();
            CellRangeAddress mergedRegion = HeaderParser.findMergedRegion(cell, mergedRegions);
            if (mergedRegion != null) {
                for (int i = mergedRegion.getFirstColumn(); i <= mergedRegion.getLastColumn(); ++i) {
                    String childHeader = secondRow.getCell(i).getStringCellValue().trim();
                    headerMap.put(parentHeader + "." + childHeader, i);
                }
                continue;
            }
            headerMap.put(parentHeader, cell.getColumnIndex());
        }
        return headerMap;
    }

    private static CellRangeAddress findMergedRegion(Cell cell, List<CellRangeAddress> regions) {
        for (CellRangeAddress region : regions) {
            if (!region.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return region;
        }
        return null;
    }
}

