/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.template.print.utils;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.template.print.enums.TemplateEnum;
import com.jxdinfo.hussar.template.print.service.CheckHookExtendService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckHookUtil {
    private static final Logger logger = LoggerFactory.getLogger(CheckHookUtil.class);

    public static boolean isCheckHookNotEmpty(String tableName) {
        return ToolUtil.isNotEmpty((Object)CheckHookUtil.checkHookExtendService(tableName));
    }

    public static <T> void readExcel(String entityName, List<T> importList, InputStream input) {
        if (CheckHookUtil.isCheckHookNotEmpty(entityName)) {
            try (InputStream inputStream = input;){
                CheckHookUtil.checkHookExtendService(entityName).readExcel(importList, inputStream);
            }
            catch (Exception e) {
                throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.FILE_READING_FAILED.getMessage()), (Throwable)e);
            }
        }
    }

    public static <T> void check(String entityName, List<T> importList, String fileName) throws Exception {
        if (CheckHookUtil.isCheckHookNotEmpty(entityName)) {
            CheckHookUtil.checkHookExtendService(entityName).check(importList, fileName);
        }
    }

    public static <T> void importData(String entityName, List<T> importList, String fileName) throws Exception {
        if (CheckHookUtil.isCheckHookNotEmpty(entityName)) {
            CheckHookUtil.checkHookExtendService(entityName).importData(importList, fileName);
        }
    }

    public static CheckHookExtendService checkHookExtendService(String entityName) {
        try {
            return (CheckHookExtendService)SpringContextHolder.getBean((String)String.format("%s_%s", "CheckHookExtend", entityName));
        }
        catch (Exception e) {
            logger.info(TranslateUtil.getTranslateName((String)TemplateEnum.THIS_POLICY_CLASS_IS_NOT_CURRENTLY_IMPLEMENTED.getMessage()), (Object)String.format("%s_%s", "CheckHookExtend", entityName));
            return null;
        }
    }
}

