/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.template.print.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.template.print.utils.NoCodeFileUtil;
import com.jxdinfo.hussar.template.print.utils.NoCodeSecurityUtil;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.template.print.controller.FormOutLinkController")
@RequestMapping(value={"/public_release"})
public class FormOutLinkController {
    @Resource
    private OssService ossService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormOutLinkController.class);

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u56fe\u6587\u5c55\u793a\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/attachment/fileDownload"})
    public void fileDownload(@RequestParam(value="fileId") Long fileId, @RequestParam(required=false, value="token") String token, HttpServletResponse response) {
        NoCodeSecurityUtil.setLoginInfo(token, null);
        ApiResponse ossResponse = this.ossService.backgroundDownload(fileId);
        AttachmentManagerModelVo managerModelVo = this.ossService.getByFileId(fileId);
        if (ossResponse.isSuccess() && HussarUtils.isNotEmpty((Object)managerModelVo)) {
            byte[] data = (byte[])ossResponse.getData();
            String fileName = managerModelVo.getFileName();
            try {
                NoCodeFileUtil.returnByteArray(data, fileName, response);
            }
            catch (IOException e) {
                throw new HussarException("\u670d\u52a1\u5668\u5f02\u5e38");
            }
        }
    }
}

